/*  src_experimental/drivers/tpu/tpud.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef _TPUD_H
#define _TPUD_H

#define TPU_ILEVEL 0x4 //!< Interrupt level of the TPU (for reference only)
#define TCR1FREQ 1000000 //!< clock frequency of the TCR1 TPU timer (for reference only)
#define TCR2FREQ 1000000 //!< clock frequency of the TCR2 TPU timer (for reference only)

int TPU_init();
int TPU_makepwm(unsigned char nr);
int TPU_initchannel(unsigned char nr);
int TPU_setpwmperiod(unsigned char nr, unsigned short period);
int TPU_setpwmdc(unsigned char nr, unsigned char hightime);
int TPU_makepac(unsigned char nr);
int TPU_makeqd(unsigned char ch1,unsigned char ch2);
unsigned short TPU_getpac(unsigned char nr);
short TPU_getqd(unsigned char nr);
short TPU_readqd(unsigned char nr);
int TPU_setisr(unsigned char ch, void (*isr) (void));
int TPU_clearisr(unsigned char ch, void (*isr) (void));
int TPU_makedio(unsigned char nr);
int TPU_setdio(unsigned char nr, unsigned char v);


#endif

