/*  src_experimental/drivers/tty/io_sci.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stddef.h>
#include <cubeos.h>
#include <sys_var.h>
#include <iobuf.h>
#include <kerror.h>
#include <ttyio.h>
#include <mc68332.h>
#include <ivtab.h>
#include <qsm.h>
#include <softreset.h>

struct TTY_tty_dev *_QSM_sci_tty;

int _QSM_sci_int_count;

void QSM_sci_int (void)
{
	char c;
	short statesave;
	struct iobuf *sci_in;
	struct iobuf *sci_out;
	_QSM_sci_int_count++;


	sci_in = _QSM_sci_tty->inq;
	sci_out = _QSM_sci_tty->outq;

	/* SCSR:
	   Bit8: TDRE (transmit data reg empty)
	   Bit7: TC   (transmit complete)
	   Bit6: RDRF (receive data reg full)
	   Bit5: RAF  (receiver busy)
	   Bit4: IDLE (idle line detected)
	   Bit3: OR   (overrun error)
	   Bit2: NF   (noise error)
	   Bit1: FE   (framing error)
	   Bit0: PF   (parity error)
	 */
	while ((statesave = readshort (SCI_SCSR)) & (0x40 | 0x02)) {	// RDRF | FE 

		if ((statesave | 0x02) && (_QSM_sci_tty->break_process))
			_QSM_sci_tty->break_process ();
		if (!_QSM_sci_tty->char_process) {
			if (sci_in->cnt < sci_in->buflen) {
				c = (char) (readshort (SCI_SCDR) & 0xff);
				if (c == RESET_CHAR)
					KERN_softreset ();
				sci_in->data[sci_in->head] = c;
				sci_in->head = (sci_in->head + 1) % sci_in->buflen;
				sci_in->cnt++;
			} else {
				_KERN_sys_error |= SYS_ERR_SCIBUF_OVF;
				c = (char) (readshort (SCI_SCDR) & 0xff);
				if (c == RESET_CHAR)
					KERN_softreset ();
				sci_in->data[sci_in->head] = c;
			}
		} else {
			_QSM_sci_tty->char_process ((char) readshort (SCI_SCDR) & 0xff);
		}
	}

	while ((sci_out->cnt > 0) && (readshort (SCI_SCSR) & 0x100)) {
		writeshort (SCI_SCDR, ((unsigned short) sci_out->data[sci_out->tail]) & 0xff);
		sci_out->tail = (sci_out->tail + 1) % sci_out->buflen;
		sci_out->cnt--;
	}
	/* hold possibly pending transmitter interrupt */
	if (sci_out->cnt == 0)
		writeshort (SCI_SCCR1, readshort (SCI_SCCR1) & 0xff7f);

}

char QSM_sci_rxchar ()
{
	short x;
	char c;
	do {
		x = readshort (SCI_SCSR);
		if (x & 0x5f) {	// any receiver flags set ?

			c = readshort (SCI_SCDR) & 0xff;
		}
	} while (!(x & 0x40));

	return c;
}

//void TTY_soutchar (char byte);
//
//char TTY_sinchar (void)
//{
//      struct iobuf *sci_in;
//      char c;
//
//      sci_in = _QSM_sci_tty->inq;
//
//      /* Block until char is there */
//      while (sci_in->cnt == 0);
//      disable ();
//      c = sci_in->data[sci_in->tail];
//      sci_in->tail = (sci_in->tail + 1) % sci_in->buflen;
//      sci_in->cnt--;
//      if (sci_in->cnt > sci_in->buflen) {
//              KERN_complain (ERR_PANIC, "More than BUFLEN bytes in the buffer");
//      }
//      enable ();
//      if (_TTY_console_echo)
//              TTY_soutchar (c);
//      return (c);
//}


void _QSM_sci_dis_tx ()
{
	writeshort (SCI_SCCR1, readshort (SCI_SCCR1) & 0xff7f);
}

void _QSM_sci_en_tx ()
{
	writeshort (SCI_SCCR1, readshort (SCI_SCCR1) | 0x80);
}

void _QSM_sci_dis_rx ()
{
	writeshort (SCI_SCCR1, readshort (SCI_SCCR1) & 0xffdf);
}

void _QSM_sci_en_rx ()
{
	writeshort (SCI_SCCR1, readshort (SCI_SCCR1) | 0x20);
}
void _QSM_sci_txbyte (char byte)
{
	while (!(readshort (SCI_SCSR) & 0x100));
	writeshort (SCI_SCDR, ((unsigned short) byte) & 0xff);
}

int _QSM_sci_sethandshake (char handshake)
{
	switch (handshake) {
	case TTY_HS_NONE:
	case TTY_HS_XONXOFF:
	case TTY_HS_RTSCTS:
		break;
	default:
		return (-1);
	}
	_QSM_sci_tty->hsmode = handshake;
	return (0);
}
int _QSM_sci_setbps (int bpsrate)
{
	return (-1);
};
void _QSM_sci_setrts (int how)
{
	return;
};



//void TTY_soutchar (char byte)
//{
//      struct iobuf *sci_out;
//
//      sci_out = _QSM_sci_tty->outq;
//      disable ();
//
//      if (TTY_Blocking_Serial_Out) {
////              writeshort (SCI_SCCR1, readshort (SCI_SCCR1) & 0xff5f);
//              writeshort (SCI_SCCR1, readshort (SCI_SCCR1) & 0xff7f);
//              while (sci_out->cnt > 0) {
//                      while (!(readshort (SCI_SCSR) & 0x100));
//                      writeshort (SCI_SCDR, ((unsigned short) sci_out->data[sci_out->tail]) & 0xff);
//                      sci_out->tail = (sci_out->tail + 1) % sci_out->buflen;
//                      sci_out->cnt--;
//              }
//              while (!(readshort (SCI_SCSR) & 0x100));
//              writeshort (SCI_SCDR, ((unsigned short) byte) & 0xff);
//      } else {
//
//              if (sci_out->cnt == sci_out->buflen) {
//                      enable ();
//                      return;
//              }               /* Ignore overflow */
//              sci_out->data[sci_out->head] = byte;
//              sci_out->head = (sci_out->head + 1) % sci_out->buflen;
//              sci_out->cnt++;
//
//              /* enable pending transmitter interrupt */
//              if (sci_out->cnt == 1)
//                      writeshort (SCI_SCCR1, readshort (SCI_SCCR1) | 0x80);
//
//      }
//      enable ();
//
//}


void QSM_sciinit (struct TTY_tty_dev *TTY_tty)
{
//      short v;

	_QSM_sci_int_count = 0x42;
	_QSM_sci_tty = TTY_tty;

	iobuf_init (_QSM_sci_tty->inq, BUFLEN);
	iobuf_init (_QSM_sci_tty->outq, BUFLEN);

	_QSM_sci_tty->txchar = _QSM_sci_txbyte;
	_QSM_sci_tty->en_tx_irq = _QSM_sci_en_tx;
	_QSM_sci_tty->dis_tx_irq = _QSM_sci_dis_tx;
	_QSM_sci_tty->en_rx_irq = _QSM_sci_en_rx;
	_QSM_sci_tty->dis_rx_irq = _QSM_sci_dis_rx;
	_QSM_sci_tty->sethandshake = _QSM_sci_sethandshake;
	_QSM_sci_tty->setbps = _QSM_sci_setbps;
	_QSM_sci_tty->setrts = _QSM_sci_setrts;
	_QSM_sci_tty->hsmode = TTY_HS_NONE;
	_QSM_sci_tty->mode = 0;
	_QSM_sci_tty->state = 0;
	_QSM_sci_tty->char_process = NULL;
	_QSM_sci_tty->break_process = NULL;

	QSM_init ();

	writeshort (SCI_SCCR0, 9);	/* 58200 baud @ 16.77MHz */
	/* Bit12..0: SCBR  (baud rate divider 1 = 1/32(CK)) */
	writeshort (SCI_SCCR1, 0x002c);
	/* 
	   Bit14: LOOPS (feedback loop mode)
	   Bit13: WOMS  (TXD in wired-or mode)
	   Bit12: ILT   (idle line detect type [long,short])
	   Bit11: PT    (parity type [odd,even])
	   Bit10: PE    (parity enable)
	   Bit9 : M     (mode select: [9,8] data bits)
	   Bit8 : WAKE  (wake up by address mark)
	   Bit7 : TIE   (transmit interupt enable)
	   Bit6 : TCIE  (transmit complete interupt enable)
	   *Bit5 : RIE   (receiver interupt enable)
	   Bit4 : ILIE  (idle line interupt enable)
	   *Bit3 : TE    (transmitter enable)
	   *Bit2 : RE    (receiver enable)
	   Bit1 : RWU   (call receiver wakeup function)
	   Bit0 : SBK   (send break)
	 */
//      v=readshort(SCI_SCSR);
	//      writeshort(SCI_SCDR,'?');
	//      v=readshort(SCI_SCSR);
	//      v=readshort(SCI_SCDR);


}
