/*  src_experimental/drivers/tty/ttyio.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stddef.h>
#include <mc68681.h>
#include <cubeos.h>
#include <sys_var.h>
#include <iobuf.h>
#include <kerror.h>
#include <io_sci.h>
#include <io_duart.h>
#include <stdio.h>

struct TTY_tty_dev TTY_tty[3];
struct iobuf TTY_tty_in[3];
struct iobuf TTY_tty_out[3];

void TTY_outchar (char byte);

char _TTY_console_echo;

int _TTY_contty;

void TTY_setcontty (int whichtty)
{
	_TTY_contty = whichtty;
}

void TTY_conecho_on ()
{
	_TTY_console_echo = 1;
}

void TTY_conecho_off ()
{
	_TTY_console_echo = 0;
}


void TTY_setmode (struct TTY_tty_dev *tty, char mode)
{
	tty->mode = mode;
}
char TTY_getmode (struct TTY_tty_dev *tty)
{
	return (tty->mode);
}
char TTY_getstate (struct TTY_tty_dev *tty)
{
	return (tty->state);
}

char TTY_readchar (struct TTY_tty_dev *tty)
{

	char c;

	/* Block until char is there */
	if (tty->mode & TTY_MODE_RXBLOCKING) {
		while (tty->inq->cnt == 0);
	} else {
		if (tty->inq->cnt == 0)
			tty->state |= TTY_STATE_RXEMPTY;
		return (0);
	}
	tty->state &= (0xff - TTY_STATE_RXEMPTY);

	disable ();
	c = tty->inq->data[tty->inq->tail];
	tty->inq->tail = (tty->inq->tail + 1) % tty->inq->buflen;
	tty->inq->cnt--;
	if (tty->inq->cnt > tty->inq->buflen) {
		KERN_complain (ERR_PANIC, "More than inq->buflen bytes in the buffer");
	}
	if (tty->hsmode == TTY_HS_RTSCTS) {
		/* handle rts enable case */
		if (tty->inq->cnt < (tty->inq->buflen - TTY_RTS_TRESHOLD))
			tty->setrts (1);
	}
	enable ();
//	printf("\n<%x\n",c);fflush(stdout);
	return (c);
}


void TTY_writechar (struct TTY_tty_dev *tty, char byte)
{

//	printf("\n>%x\n",byte);fflush(stdout);

	disable ();

	if (tty->mode | TTY_MODE_TXUNBUF) {
		tty->dis_tx_irq ();
		while (tty->outq->cnt > 0) {
			tty->txchar (tty->outq->data[tty->outq->tail]);
			tty->outq->tail = (tty->outq->tail + 1) % tty->outq->buflen;
			tty->outq->cnt--;
		}
		tty->txchar (byte);
	} else {

		if (tty->outq->cnt == tty->outq->buflen) {
			/* buffer is full */
			tty->en_tx_irq ();	/* in case it was off for any reason */
			if (tty->mode | TTY_MODE_TXBLOCKING) {
				enable ();
				while (tty->outq->cnt == tty->outq->buflen);
				disable ();
			} else {
				tty->state |= TTY_STATE_TXFULL;
				enable ();
				// here, we have to block the I/O-doing thread
				// until there is space in the TX buffer
				// then we have to restart the I/O
				// recursively.
//				KERN_ssleep();
				return;
			}
		}
		tty->outq->data[tty->outq->head] = byte;
		tty->outq->head = (tty->outq->head + 1) % tty->outq->buflen;
		tty->outq->cnt++;

		/* enable pending transmitter interrupt */
		if (tty->outq->cnt > 0)
			tty->en_tx_irq ();
	}
	enable ();
}


char TTY_inchar (void)
{
	char c;

	/* Block until char is there */
	while (TTY_tty[_TTY_contty].inq->cnt == 0);
	disable ();
	c = TTY_tty[_TTY_contty].inq->data[TTY_tty[_TTY_contty].inq->tail];
	TTY_tty[_TTY_contty].inq->tail = (TTY_tty[_TTY_contty].inq->tail + 1) % TTY_tty[_TTY_contty].inq->buflen;
	TTY_tty[_TTY_contty].inq->cnt--;
	if (TTY_tty[_TTY_contty].inq->cnt > TTY_tty[_TTY_contty].inq->buflen) {
		KERN_complain (ERR_PANIC, "More than inq->buflen bytes in the buffer");
	}
	enable ();
	if (_TTY_console_echo)
		TTY_outchar (c);
	return (c);
}

void TTY_soutchar(char byte)
{
TTY_tty[_TTY_contty].dis_tx_irq ();
while (TTY_tty[_TTY_contty].outq->cnt > 0) {
	TTY_tty[_TTY_contty].txchar (TTY_tty[_TTY_contty].outq->data[TTY_tty[_TTY_contty].outq->tail]);
	TTY_tty[_TTY_contty].outq->tail = (TTY_tty[_TTY_contty].outq->tail + 1) % TTY_tty[_TTY_contty].outq->buflen;
	TTY_tty[_TTY_contty].outq->cnt--;
	}
TTY_tty[_TTY_contty].txchar (byte);
}

void TTY_outchar (char byte)
{

//	KERN_usleep (1000);

if (TTY_Blocking_Serial_Out){
	TTY_soutchar(byte);
	return;
}
	while (TTY_tty[_TTY_contty].outq->cnt == TTY_tty[_TTY_contty].outq->buflen);

	disable ();


		if (TTY_tty[_TTY_contty].outq->cnt == TTY_tty[_TTY_contty].outq->buflen) {
			TTY_tty[_TTY_contty].en_tx_irq ();
			enable ();
			return;
		}		/* Ignore overflow */
		TTY_tty[_TTY_contty].outq->data[TTY_tty[_TTY_contty].outq->head] = byte;
		TTY_tty[_TTY_contty].outq->head = (TTY_tty[_TTY_contty].outq->head + 1) % TTY_tty[_TTY_contty].outq->buflen;
		TTY_tty[_TTY_contty].outq->cnt++;

		/* enable pending transmitter interrupt */
		if (TTY_tty[_TTY_contty].outq->cnt > 0)
			TTY_tty[_TTY_contty].en_tx_irq ();
	enable ();
}

void dummy ()
{
	return;
}

void TTY_init (void)
{
	int i;

/*      init_LED ();
   LED_OFF ();
   for (i = 0; i < 100000; i++);
   LED_ON ();
   for (i = 0; i < 100000; i++);
   LED_OFF (); */

	for (i = 0; i < 3; i++) {
		TTY_tty[i].inq = &TTY_tty_in[i];
		TTY_tty[i].outq = &TTY_tty_out[i];
	}


//#ifdef CUBE3
	//      TTY_setcontty (1);          /* DUART */
	//#else
	//      TTY_setcontty (0);              /* DUART */
	//#endif
#ifdef DUART_BASE
	DUART_duart (&TTY_tty[1], &TTY_tty[2]);
#else

	TTY_tty[1].txchar = dummy;
	TTY_tty[1].en_tx_irq = dummy;
	TTY_tty[1].dis_tx_irq = dummy;
	TTY_tty[1].en_rx_irq = dummy;
	TTY_tty[1].dis_rx_irq = dummy;
	TTY_tty[1].sethandshake = dummy;
	TTY_tty[1].setbps = dummy;
	TTY_tty[1].setrts = dummy;
	TTY_tty[1].hsmode = TTY_HS_NONE;
	TTY_tty[1].mode = 0;
	TTY_tty[1].state = 0;
	TTY_tty[1].char_process = NULL;
	TTY_tty[1].break_process = NULL;

	iobuf_init (TTY_tty[1].inq, BUFLEN);
	iobuf_init (TTY_tty[1].outq, BUFLEN);

	TTY_tty[2].txchar = dummy;
	TTY_tty[2].en_tx_irq = dummy;
	TTY_tty[2].dis_tx_irq = dummy;
	TTY_tty[2].en_rx_irq = dummy;
	TTY_tty[2].dis_rx_irq = dummy;
	TTY_tty[2].sethandshake = dummy;
	TTY_tty[2].setbps = dummy;
	TTY_tty[2].setrts = dummy;
	TTY_tty[2].hsmode = TTY_HS_NONE;
	TTY_tty[2].mode = 0;
	TTY_tty[2].state = 0;
	TTY_tty[2].char_process = NULL;
	TTY_tty[2].break_process = NULL;

	iobuf_init (TTY_tty[2].inq, BUFLEN);
	iobuf_init (TTY_tty[2].outq, BUFLEN);

#endif
	QSM_sciinit (&TTY_tty[0]);
	TTY_setcontty (0);
	TTY_conecho_on ();

}
