/*  src_experimental/init/fbintest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include "fbintest.h"
#include <stdio.h>
#include "testmak.h"
#include <cubeos.h>
#include <fastbin.h>

int FBinTest ()
{

	int i;

#ifndef FASTBIN_BASE
	failif (1, "No fastbins configured in OS build...");
#else
	failif (FASTBIN_BASE == 0, "No fastbins in current config...");

	printf ("init_fastbin\n");

	FBIN_init ();

	printf ("Making fastbins...");
	fflush (stdout);
	for (i = 0; i < 15; i++) {
		printf ("%d ", i);
		checkif (FBIN_make (i, FBTYPE_TTL, i) == 0, "couldn't make fastbin");
	}
	printf ("\n");

	printf ("Enabling fastbins...");
	fflush (stdout);
	for (i = 0; i < 15; i++) {
		printf ("%d ", i);
		checkif (FBIN_set (i, 1) == 0, "couldn't enable fastbin");
	}
	printf ("\n");

	printf ("disabeling fastbins...");
	fflush (stdout);
	for (i = 0; i < 15; i++) {
		printf ("%d ", i);
		checkif (FBIN_set (i, 0) == 0, "couldn't disable fastbin");
	}
	printf ("\n");

	printf ("Flashing fastbins FAST");
	fflush (stdout);
	for (i = 1; i < 1000000; i++) {
		writeshort (FASTBIN_BASE, 0xffff);
		writeshort (FASTBIN_BASE, 0x0000);
	}
	printf ("\nOK\n");

#endif
	return (0);
}
