/*  src_experimental/init/listtest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stddef.h>
//#include <assert.h>
#include <list.h>
#include "listtest.h"
#include "testmak.h"
int ListTest ()
{
	int i;
	list li;
	list *l;
	entry en[100];

	l = &li;
	LIST_init (l);
/* now we have a list */

	for (i = 0; i < 100; i++) {
		en[i].data = (void *) i;
		en[i].list = NULL;
	}

	for (i = 0; i < 100; i++)
		LIST_insert_head (l, &en[i]);

	checkif (LIST_entries (l) == 100, "lost an entry???");

	for (i = 99; i > 0; i--) {
		checkif (i == (int) (LIST_head (&li)->data), "malformed data");
		LIST_delete (LIST_head (l));
	}

	checkif (LIST_entries (l) == 1, "wrong number of entries");
	checkif (LIST_head (l) == &en[0], "unexpected head");

	LIST_delete (LIST_head (l));
	checkif (LIST_head (l) == NULL, "list not empty");	/* list is now empty */
	checkif (LIST_entries (l) == 0, "counter out of sync");

	LIST_delete (LIST_head (l));	/* delete something */
	LIST_delete (&en[0]);	/* delete something else */
	LIST_insert_before (&en[0], NULL);
	LIST_insert_after (&en[0], NULL);
	checkif (LIST_tail (l) == NULL, "list not empty");	/* list is still empty */

	for (i = 0; i < 100; i++)
		LIST_insert_tail (l, &en[i]);
	checkif (LIST_entries (l) == 100, "wrong number of entries");

	for (i = 0; i < 100; i++) {
		checkif (i == (int) (LIST_head (&li)->data), "malformed data");
		LIST_delete (LIST_head (l));
	}
	checkif (LIST_entries (l) == 0, "list not empty");

	for (i = 0; i < 100; i++)
		checkif (en[i].list == NULL, "entry still in list");

	for (i = 0; i < 99; i++)
		LIST_insert_tail (l, &en[i]);
	checkif (LIST_entries (l) == 99, "wrong number of entries");

	LIST_insert_before (&en[99], &en[98]);
	checkif (LIST_tail (l) == &en[98], "wrong tail");
	checkif (LIST_entries (l) == 100, "wrong mumber of entries");

	LIST_delete (LIST_tail (l));
	checkif (LIST_entries (l) == 99, "wrong number of entries");
	checkif (LIST_tail (l) == &en[99], "wrong tail");

	LIST_insert_after (&en[98], &en[0]);
	checkif (LIST_head (l) == &en[0], "wrong head");
	checkif (LIST_entries (l) == 100, "wrong number of entries");

	LIST_delete (LIST_head (l));
	checkif (LIST_head (l) == &en[98], "wrong head");
	checkif (LIST_entries (l) == 99, "wrong number of entries");

	for (i = 99; i > 0; i--) {
		checkif (i == LIST_entries (l), "wrong number of entries");
		LIST_delete (LIST_head (l));
	}

	printf ("Passed\n");
	return (0);
}
