/*  src_experimental/init/radiotest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stdio.h>
#include <cubeos.h>
#include <rdio.h>
#include <rsm.h>
#include <ptimer.h>

extern unsigned char _DUART_imrsave;

int RadioTestRx ()
{
	int i;
	char frame[RSM_FRAMELEN];

	printf ("\nCubeOS RSM-RX-Test\n");
	printf ("calling RSM_init_rx()\n");
	RSM_init_rx ();
	printf ("ok\n");
//	printf ("_RSM_enabled = %d\n", _RSM_enabled);
	printf ("imrsave = %x\n", _DUART_imrsave);

	for (i = 0; i < 1000000; i++) {
		if (!RSM_getframe (frame)) {
			printf (".");
			fflush (stdout);
		}
	}

//	printf ("_RSM_enabled = %d\n", _RSM_enabled);
	printf ("imrsave = %x\n", _DUART_imrsave);

	RSM_deinitrx ();

//	printf ("_RSM_enabled = %d\n", _RSM_enabled);
	printf ("imrsave = %x\n", _DUART_imrsave);

	printf ("RSM_good = %d\n_RSM_bad = %d \n_RSM_ugly = %d at %d\n_RSM_bytes = %d\n",
		RSM_good, _RSM_bad, _RSM_ugly, _RSM_uglycount, _RSM_bytes);


	return (0);
}

int RadioTestTx ()
{
	int i, j;
	char frame[RSM_FRAMELEN];

	printf ("\nCubeOS RSM-TX-Test\n");
	printf ("calling RSM_init_tx()\n");
	RSM_init_tx ();
	for (i = 1; i < 100000; i++);
	printf ("ok\n");

	printf ("Sending 100 test packets");
	fflush (stdout);
	for (i = 0; i < 100; i++) {
		sprintf (frame, "RSM-RX-Test Packet %d", i);
		for (j = strlen (frame); j < (RSM_FRAMELEN - 1); j++)
			frame[i] = 'X';
		frame[RSM_FRAMELEN - 1] = 0;
		RSM_send_frame (frame);
		printf (".");
		fflush (stdout);
	}


	RSM_deinittx ();
	printf ("\n");

	return (0);
}
