/*  src_experimental/init/readcmd.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include "readcmd.h"
#include <cubeos.h>
#include <stdio.h>
#include <ttyio.h>

char commandbuf[MAXCLEN];

char *readcmd (char *prompt)
{
	char *iptr;		/* points to the location of the next insert */
	char c;
	int done;
	int processed;
	if (prompt)
		printf ("%s", prompt);
	fflush (stdout);
	TTY_conecho_off ();
	done = 0;

	iptr = commandbuf;

	while (!done) {
		processed = 0;
		c = TTY_inchar ();
		if (c == CRin) {
			done = 1;
			processed = 1;
		}
		if (c == BSin) {
			/* Backspace */
			if (iptr > commandbuf) {
				iptr--;
				printf (BSout);
				fflush (stdout);
				processed = 1;
			}
		}
		if (c >= 0x20 && c <= 0x7E) {
			/* usual char */
			if ((iptr - commandbuf) < MAXCLEN) {
				(*iptr++) = c;
				TTY_outchar (c);
				processed = 1;
			}
		}
		/* default */
		if (processed == 0) {
			printf (BELLout);
			fflush (stdout);
		}
	}

	(*iptr) = 0;		/* End of String */
	TTY_conecho_on ();
	return (commandbuf);
}
