/*  src_experimental/init/schedtest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stdio.h>
#include <signal.h>
#include <cubeos.h>
#include <schedule.h>
#include "testmak.h"

int thread1count;
int thread2count;
int sleep_success;

void thread_1 ()
{
	int i;
	while (1) {
		thread1count++;
		for (i = 1; i < 1000; i++);
		TTY_outchar ('1');
	}
}

void thread_2 ()
{
	int i;
	while (1) {
		thread2count++;
		for (i = 1; i < 1000; i++);
		TTY_outchar ('2');
	}
}


int SchedTest ()
{
	int handle1, handle2;
	int i, j;

	thread1count = 0;
	thread2count = 0;

//      printf (" starting threads\n");
	//      fflush (stdout);
	//      handle1 = KERN_create(thread_1);
	//      handle2 = KERN_create(thread_2);
	//
	//      for (i = 1; i < 1000000; i++);
	//
	//      printf ("\nkilling threads\n");
	//      fflush (stdout);
	//      kill(handle1, SIGKILL);
	//      kill(handle2, SIGKILL);
	//
	//      for (i = 1; i < 100000; i++);   /* wait a bit to give time for the threads to react */
	//
	//      printf ("\n");
	//      printf (" Thread1 counted %d\n", thread1count);
	//      printf (" Thread2 counted %d\n", thread2count);
	//
	//      failif (thread1count == 0, "Thread 1 didn't run");
	//      failif (thread2count == 0, "Thread 2 didn't run");
	//
	//      failif (_KERN_ptable[handle1].state != STATE_EMPTY, "Thread 1 still running !");
	//      failif (_KERN_ptable[handle2].state != STATE_EMPTY, "Thread 2 still running !");
	//
	//      thread1count=0;
	//      thread2count=0;
	//
	printf (" starting new threads\n");
	fflush (stdout);
	handle1 = KERN_create (thread_1);
	handle2 = KERN_create (thread_2);

	for (i = 1; i < 1000000; i++);

	printf ("\nSuspending thread 1\n");
	fflush (stdout);
	//kill(handle1, SIGKILL);
	failif (KERN_suspend (handle1), "cannot suspend");
	for (i = 1; i < 1000000; i++);

	printf ("\nwaking up thread 1\n");
	fflush (stdout);
	failif (KERN_wakeup (handle1), "cannot wakeup");
	for (i = 1; i < 1000000; i++);

	printf ("\nkilling threads\n");
	fflush (stdout);
	kill (handle1, SIGKILL);
	kill (handle2, SIGKILL);

	for (i = 1; i < 100000; i++);	/* wait a bit to give time for the threads to react */

	printf ("\n");
	printf (" Thread1 counted %d\n", thread1count);
	printf (" Thread2 counted %d\n", thread2count);

	failif (thread1count == 0, "Thread 1 didn't run");
	failif (thread2count == 0, "Thread 2 didn't run");

	failif (thread1count >= (thread2count - 10), "Thread 1 was not suspended !");

	failif (_KERN_ptable[handle1].state != STATE_EMPTY, "Thread 1 still running !");
	failif (_KERN_ptable[handle2].state != STATE_EMPTY, "Thread 2 still running !");

	return (0);
}
