/*  src_experimental/init/tputest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stdio.h>
#include <cubeos.h>
#include <tpu.h>
#include <tpud.h>
#include "testmak.h"

int tpuirqtest;

void tpuisrw ();		/* wrapper code */

void tpu_int ()
{
	int dummy;

	dummy = getCISR (15);
	clearCISR (15);
	tpuirqtest++;

}

int TPUTest ()
{
	int i, j;

	printf ("Calling TPU_INIT\n");
	TPU_init ();
	printf ("Making Channel 15 PWM\n");
	TPU_makepwm (15);

	printf ("Sweeping Duty cycle...\n");
	for (i = 0; i <= 100; i++) {
		TPU_setpwmdc (15, i);
		for (j = 0; j < 3000; j++);
	}
	printf ("and down...\n");
	for (i = 100; i > 0; i--) {
		TPU_setpwmdc (15, i);
		for (j = 0; j < 3000; j++);
	}

	printf ("ok\n");
	printf ("Sweeping frequency...\n");
	for (i = 20875; i > 0; i--) {
		TPU_setpwmperiod (15, i);
		TPU_setpwmdc (15, 50);
//        for (j = 0; j < 10; j++) ;
	}

	TPU_setpwmperiod (15, 10000);
	TPU_setpwmdc (15, 50);
	printf ("ok\n");
	printf ("Testing irq callback\n");
	TPU_initchannel (15);

	tpuirqtest = 0;

	failif (TPU_setisr (15, tpuisrw), "could not set TPU ISR\n");

	TPU_makepwm (15);
	TPU_setpwmperiod (15, TCR1FREQ/1000 );
	TPU_setpwmdc (15, 1);
	setCIER (15, 0x1);
	setHSRR (15, 2);

	KERN_usleep(1000000);
//for (i = 1; i < 100000; i++);

	setCIER (15, 0x0);
	setHSRR (15, 2);

	printf ("seen %d isr calls\n", tpuirqtest);

	TPU_initchannel (15);

	failif (TPU_clearisr (15, tpuisrw), "could not clear TPU ISR\n");

	printf ("ok\n\r");

	failif (tpuirqtest == 0, "No ISR callbacks seen");

	return (0);

}
