/*  src_experimental/init/ttytest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <ttyio.h>
#include <iobuf.h>
#include <stdio.h>

extern struct TTY_tty_dev TTY_tty[3];
extern int _TTY_contty;
int break_count;

void break_handler ()
{
	break_count++;
}

int TTYTest ()
{
	int i;
	char *teststring = "the quick brown fox jumps over the lazy dog\n\r";
	char *pointer;

	printf ("testing direct blocking output\n");
	fflush (stdout);

	for (pointer = teststring; pointer[0] != 0; pointer++) {
		TTY_tty[0].txchar (pointer[0]);
		TTY_tty[1].txchar (pointer[0]);
		TTY_tty[2].txchar (pointer[0]);
	}

	printf("testing libc blocking output on console\n");
	TTY_setmode(TTY_tty[_TTY_contty],TTY_MODE_TXBLOCKING);
	printf("%s",teststring);
	TTY_setmode(TTY_tty[_TTY_contty],0);

	printf ("testing interrupt output\n");
	fflush (stdout);

	for (pointer = teststring; pointer[0] != 0; pointer++) {
		put (TTY_tty[0].outq, pointer[0]);
		put (TTY_tty[1].outq, pointer[0]);
		put (TTY_tty[2].outq, pointer[0]);
	}
	TTY_tty[0].en_tx_irq ();
	TTY_tty[1].en_tx_irq ();
	TTY_tty[2].en_tx_irq ();

	for (i = 1; i < 50000; i++);

	printf ("disabling interrupts output\n");
	fflush (stdout);
	TTY_tty[0].dis_tx_irq ();
	TTY_tty[1].dis_tx_irq ();
	TTY_tty[2].dis_tx_irq ();

	for (i = 1; i < 50000; i++);



	printf (" testing break input on console ");
	break_count = 0;
	TTY_tty[_TTY_contty].break_process = break_handler;
	printf (" send break now...");

	for (i = 1; i < 500000; i++)
		if (!(i % 10000)) {
			printf (".");
			fflush (stdout);
		}
	printf ("break_count = %d\n", break_count);
	TTY_tty[_TTY_contty].break_process = NULL;
	printf ("done\n");

	printf("testing serial input on console (type 10 chars) \n");
	printf("testing blocking input\n");
	TTY_setmode(&(TTY_tty[_TTY_contty]),TTY_MODE_RXBLOCKING);
	for(i=0;i<10;i++)
		{
		printf("got %x\n",TTY_readchar(&(TTY_tty[_TTY_contty])));
		}
	printf("ok\n");
/*	printf("testing nonblocking input\n");
	TTY_setmode(&(TTY_tty[_TTY_contty]),0);
	for(i=0;i<10;i++)
		{
		char c=0;;
		while (c == 0){
			c=TTY_readchar(&(TTY_tty[_TTY_contty]));
			KERN_usleep(1000);
		}
		printf("got %x\n",c);
		}
	printf("ok\n");
*/

/*	if (TTY_tty[2].en_rx_irq) {
		printf("enabeling interrupts\n");
		TTY_tty[2].en_rx_irq ();
	} else {
		printf("no enable routine for console!\n");
	} */

/*	printf("testing serial input on DUART 2 (type 10 chars) \n");
	printf("testing blocking input\n");
	TTY_setmode(&(TTY_tty[2]),TTY_MODE_RXBLOCKING);
	for(i=0;i<10;i++)
		{
		printf("got %x\n",TTY_readchar(&(TTY_tty[2])));
		}
	printf("ok\n");
*/

	
	fflush (stdout);


	return (0);
}
