/*  src_experimental/init/xdrtest.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <stdio.h>
#include <signal.h>
#include <cubeos.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <math.h>
#include <string.h>
#include "testmak.h"
#define XDRLEN 1024

int XDRTest ()
{
	char xdrbuffer[XDRLEN];

	XDR xdrs1, xdrs2, xdrs3;
	long i, j;
	double x;
	char *text;
	char *result;
	xdrstdio_create (&xdrs1, stdout, XDR_ENCODE);
	for (i = 0; i < 8; i++) {
		if (!xdr_long (&xdrs1, &i)) {
			printf ("failed!\n");
			return (1);
		}
	}
	printf ("\n");		// now we believe that the basic xdr works

	xdrmem_create (&xdrs2, xdrbuffer, XDRLEN, XDR_ENCODE);
	// first, put in 8 longs 
	for (i = 0; i < 8; i++) {
		if (!xdr_long (&xdrs2, &i)) {
			printf ("failed!\n");
			return (1);
		}
	}
	// 8 floats
	for (i = 0; i < 8; i++) {
		x = sin (i);
		if (!xdr_double (&xdrs2, &x)) {
			printf ("failed!\n");
			return (1);
		}
	}
	// a string
	text = "Hello World!";
	if (!xdr_string (&xdrs2, &text, 16)) {
		printf ("failed!\n");
		return (1);
	}
	xdrmem_create (&xdrs3, xdrbuffer, XDRLEN, XDR_DECODE);
	// 8 longs 
	for (i = 0; i < 8; i++) {
		if (!xdr_long (&xdrs3, &j)) {
			printf ("failed!\n");
			return (1);
		}
		printf ("%d ", i);
		if (i != j) {
			printf ("failed!\n");
			return (1);
		}
	}
	printf ("\n");
	// 8 floats
	for (i = 0; i < 8; i++) {
		if (!xdr_double (&xdrs3, &x)) {
			printf ("failed!\n");
			return (1);
		}
		printf ("%f ", x);
		if (sin (i) != x) {
			printf ("failed!\n");
			return (1);
		}
	}
	printf ("\n");
	// a string
	result = NULL;
	if (!xdr_string (&xdrs3, &result, 16)) {
		printf ("failed!\n");
		return (1);
	}
	printf (">%s<", result);
	if (strncmp ("Hello World!", result, 16)) {
		printf ("failed!\n");
		return (1);
	}
	free (result);
	return (0);
}
