/*  src/kernel/list.h
    CubeOS Version 0.4.90
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
/* basic list handling */

#ifndef _LIST_H
#define _LIST_H

/*! \file list.h
\ingroup LIST
*/

#define LIST_TYPE_USER 0
#define LIST_TYPE_SYS 1
#define LIST_TYPE_PRIO 2

typedef struct list_s list;
typedef struct entry_s entry;

/*!
\brief entry of a list
*/
struct entry_s {
list * list;  //!< pointing to the list the entry belongs to
entry * prev; //!< the previous entry in the list
entry * next; //!< the next entry in the list
void * data;  //!< pointer to the data content of the entry
int len;      //!< length of the contained data (in bytes)
} ;

/*!
\brief a list
*/
struct list_s
{
entry * head; //!< pointer to the head entry of the list
entry * tail; //!< pointer to the tail entry of the list
int entries;  //!< number of entries in the list
int type;     //!< type code for list, used in the scheduler
};

entry *LIST_head(list *l);
entry *LIST_tail(list *l);
int LIST_entries(list *l);
void LIST_init(list * l);
void LIST_insert_after(entry * e,entry *x);
void LIST_insert_before(entry * e,entry *x);
void LIST_insert_head(list *l,entry *e);
void LIST_insert_tail(list *l,entry *e);
void LIST_delete(entry *e);
void LIST_makeentry(entry *e);

#endif
