/*  src/kernel/ptimer.h
    CubeOS Version 0.4.90
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef PTIMER_H
#define PTIMER_H

/*! \file ptimer.h
\ingroup KERN
*/

#include <cubeos.h>

#define PTIMER_VECTOR 64 //!< the interrup vector table entry to be used for the ptimer

//#define PTIMER_IRQ_LEVEL 4
#define PTIMER_IRQ_LEVEL 6 //!< the interrupt level used by the ptimer

#define XTAL_FREQ 32768 //!<  68332 external clock frequency  in Hz 

#define PTIMER_PITR_VAL 0x0008	//!< timer period, 977 uSec */
#define TICKS_PER_SECOND 1024   //!< how many times the ISR is called per second
#define QUANTUM TICKS_PER_SECOND/8 //!< how long is a quantum,  every 64 ticks = 62.5msec 
//#define QUANTUM 1024 /* for scheduler debugging, once a second */
//#define PTIMER_PITR_VAL 0x0110 /* 1Sec */
//#define TICKS_PER_SECOND 1
//#define QUANTUM TICKS_PER_SECOND
//#define PTIMER_PITR_VAL 0x0101        /* 62.5 mSec */
//#define TICKS_PER_SECOND 16
//#define QUANTUM TICKS_PER_SECOND

int KERN_ptint(void);
void KERN_init_ptimer(void);
//unsigned long _gettimeofday();
//unsigned long _settimeofday(unsigned long val);
int KERN_installdispatcher(void (*dispatcher) ());
int KERN_removedispatcher();

#endif
