/*  src_experimental/kernel/schedule.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef SCHEDULE_H
#define SCHEDULE_H

/*! \file schedule.h
\ingroup KERN
*/

#define RR_SCHEDULER
#include <context.h> /* for regs */
#include <reent.h>
#include <list.h>    /* for entry type */
/* Again, goes into global_defs later */
#define MAX_PROCESSNUM 16 //!< size of the process table. Incrementing makes things (slightly) slower.
#define MAX_PRIONUM 16    //!< size of the priority table.
#define NO_TASK -1  //!< marker for empty task 

#define STATE_EMPTY    0   //!< thread slot not used 
#define STATE_RUNNING  1   //!< thread is on CPU 
#define STATE_READY    2   //!< thread ready to roll
#define STATE_SUSPEND  3   //!< thread sleeping
#define STATE_KILLED   4   //!< thread in coma (almost dead)

/*! \struct process
\brief process/thread table entry
\ingroup KERN
The process table entry contains all information the scheduler needs to schedule and all 
information, the context switch needs to switch. And some more...*/
struct process {
	reglist regs;	//!< This is the current state of the registers that is not kept on the stack 
	void *stack;	//!< This is the initial stack pointer, it is used to free() the stack after the process exits
	char state;     //!< This keeps the STATE_xxx-value
	char irq;	//!< irq level for the thread. currently not used
	int signal;	//!< incomming signal flags
	int mask;	//!< masked signals. Only signals with ther mask bit set can be received
	int ppid;	//!< parent thread id, just for reference, SIGCHILD is not implemented
	struct _reent reent; //!< reentrance structure of newlibc for this thread
	int message;	//!< incomming message field. 0 means no message pending
	struct sem_t * sem;  //!< pointer to the semaphore the thread is currently waiting for
	unsigned int time_delta; /*!< delta time before this thread has to be woken up. 
				      This is a delta and only makes sense in context of the delta queue */
	int prio;	//!< thread priority field
	entry me;       //!< This field is used for all list-like things like the delta list and semaphores
	int pid;	//!< to find the process id from a pointer to the process table entry
	int next; 
};
extern struct process _KERN_ptable[MAX_PROCESSNUM]; //!< The process table 
//extern int _KERN_deltahead;			    //!< head of the delta queue which holds time-suspended threads
extern list _KERN_delta;			    //!< kernel delta queue
extern list _KERN_prio[MAX_PRIONUM+1];
int KERN_schedinit();
int KERN_delta_handler();
int KERN_create(void * function);
void KERN_schedule(void);
int getpid();
//int pmsg_send(int pid,int message);
//int pmsg_receive();
int KERN_suspend(int i);
int wakeup(int i);
#endif
