/*  src_experimental/kernel/softreset.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <cubeos.h>

/*! \file softreset.c
\ingroup KERN
*/

/*!
\brief resets the hardware by using a dirty hack.
\ingroup KERN

This function disables the clock output of the 68332 that is used to retrigger
the external DS1232 watchdog chip. After losing the retrigger signal for about
500ms, the DS1232 will pull the reset line low. I would like to use the 
RESET assembler instruction, but that would only reset the external devices and
leave the CPU running, which might not be as clean as I'd like it to be.
*/
void KERN_softreset ()
{

	writeshort (SIM_MCR, readshort (SIM_MCR) | 0x8000);

//asm("movl #0xf00004,%%a0": : :"a0");
	//asm("movl (%%a0),%%a0": :);
	//asm("movl #0xf00000,%%a1": : :"a1");
	//asm("adda  %%a0,%%a1": : :"a0");
	//asm("jmp (%%a1)": :);

}
