/*  src_experimental/kernel/ssem.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
#ifndef SSEM_H

#define SSEM_H
/*! \file kernel/ssem.h
\ingroup KERN
simple semaphores with spin lock, to be used if waiting one quantum would be too long.
warning: not thread-aware, not deadlock-safe, don't use it for new
things unless you know exactly what you're doing !!! 
These semaphores are SAFE as long as there is only one producer and
one consumer, like in i2cd. However, they are not Mutex-Safe !!! 
*/


typedef int ssem_t;

#define ssem_post(x) x++; //!< post operation, should only be called in disabled() state
#define ssem_signal(x) ssem_post(x) //!< alias of ssem_port(), for thomas
#define ssem_wait(x) x--;while(x<0) //!< spinlock wait, does not return a propper value.
#define ssem_trywait(x) (x<0) //!< tests if a ssem_wait() might block.
#define ssem_getvalue(x,i) (*i=x) //!< reads the semaphore value

#define ssem_init(x,i,v) (x=v) //!< to fulfill posix conventions. Quite useless for CubeOS, but anyway ...
#define ssem_destroy(x) (0) //!< to fulfill posix conventions. Quite useless for CubeOS, but anyway ...

#endif
