/*  src_experimental/libc/cubereent.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
#include <sys/reent.h>
/*! \file cubereent.c
\ingroup LIBC

This file provides the initialisation of a newlib reentrancy structure
*/

#define NEWNEWLIB //!< switches between different newlib versions


/*!
\brief prepares a newlib reentrancy structure fo use
\param ptr is a pointer to a newlib reentrancy structure
\ingroup LIBC

*/
void _LIBC_init_reent (struct _reent *ptr)
{
#ifdef NEWNEWLIB
	struct _reent re = _REENT_INIT (re);

	bcopy (&re, ptr, sizeof (struct _reent));
	ptr->_stdin = &(ptr->__sf[0]);
	ptr->_stdout = &(ptr->__sf[1]);
	ptr->_stderr = &(ptr->__sf[2]);

#else
	ptr->_errno = 0;
	ptr->_stdin = &(ptr->__sf[0]);
	ptr->_stdout = &(ptr->__sf[1]);
	ptr->_stderr = &(ptr->__sf[2]);
	ptr->_inc = 0;
	ptr->_emergency[0] = 0;	/* Empty string */
	ptr->_current_category = 0;
	ptr->_current_locale = "C";
#endif
}
