/*  src_experimental/libc/kill.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
/* kill.c -- signal to a process.

 */

/*! \file kill.c
\ingroup LIBC
*/

#include <sys_var.h>
#include <schedule.h>

/*!
\brief kill - Sends a signal to a thread
\param pid is the thread id
\param sig is the signal to be send
\ingroup LIBC
\todo maybe this should also do a KERN_wakeup()
*/
int kill (int pid, int sig)
{

	if (pid > MAX_PROCESSNUM)
		return (-1);
	if (pid < 0)
		return (-1);
	if (_KERN_ptable[pid].state == STATE_EMPTY)
		return (-1);
	if (sig < 0)
		return (-1);
	if (sig > 31)
		return (-1);
	_KERN_ptable[pid].signal |= (1 << sig);
	return 0;
}
