/*  src_experimental/libc/kio.c
   CubeOS Version 0.4.90 experimental
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */

#include <stdio.h>
#include <kio.h>

/*! \file kio.c
\ingroup LIBC

This file contains the lower interface to the libc i/o routines.
Everything written in functions like printf etc. will end up here
*/

/* Interface routines for OS */
#define	OK	1
#define	CONSOLE	0

void TTY_outchar (char c);
char TTY_inchar ();


/* Internals */
/*!
\brief glue function between libc and TTY
\ingroup LIBC
*/
inline char _LIBC_inbyte ()
{
	return (TTY_inchar ());
}

/*!
\brief glue function between libc and TTY
\ingroup LIBC
*/
inline void _LIBC_outbyte (char c)
{
	TTY_outchar (c);
}

/*!
\brief glue function between libc and TTY
\ingroup LIBC
*/
void LIBC_outstring (char *str)
{
	char *ptr;

	ptr = str;
	while (ptr[0] != (char) 0)
		TTY_outchar (*ptr++);

}


/*!
\brief glue function between libc and TTY
\ingroup LIBC
*/
void _exit (int status)
{
	printf ("\n\r **** PROGRAM EXIT ****");
	printf ("\n\r **** EXIT CODE %d ****\n\r", status);
}
