/*  src/libc/sbrk.c
   CubeOS Version 0.4.90
   Copyright (C) 1999,2000 Holger Kenn

   CubeOS is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or any later version.

   CubeOS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

 */
/* sbrk.c -- allocate memory dynamically.

 * Copyright (c) 1995,1996 Cygnus Support
 *
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */
#include <errno.h>
#include "glue.h" // this really needs glue.h. don't remove!

/* \file sbrk.c
\ingroup LIBC

This file contains the central interface between the libc memory management
and the cubeOS memory management.
*/

/* just in case, most boards have at least some memory */
#ifndef RAMSIZE
#define RAMSIZE             (caddr_t)0x100000
#endif

char *heap_ptr; //!< this is the global heap pointer

/*!
\brief changes heap size size. Get nbytes more RAM. 
\ingroup LIBC

We just increment a pointer in what's left of memory on the board.
\todo this prevents memory to be freed upon reset since the pointer is still
in the pre-reset condition. Also the memory management relies on the ld file
upon compile time, we should better discover the memory on our own or
at least rely on the newer bootmon's memory sizer.
*/
char *sbrk (int nbytes)
{
	char *base;

	if (!heap_ptr)
		heap_ptr = (char *) &_end;
	base = heap_ptr;
	heap_ptr += nbytes;

	return base;
/* FIXME: We really want to make sure we don't run out of RAM, but this
 *       isn't very portable.
 */
#if 0
	if ((RAMSIZE - heap_ptr - nbytes) >= 0) {
		base = heap_ptr;
		heap_ptr += nbytes;
		return (base);
	} else {
		errno = ENOMEM;
		return ((char *) -1);
	}
#endif
}
