/*  src_experimental/net/rdio.h
    CubeOS Version 0.4.90 experimental
    Copyright (C) 1999,2000 Holger Kenn

    CubeOS is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or any later version.

    CubeOS is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

*/  
/* This is the low-level interface to the radio hardware. An application
program is not supposed to see this. */

#ifndef _RDIO_H
#define _RDIO_H

/*! \file rdio.h
\ingroup RSM
*/

#include <cubeos.h>
#include <mc68681.h>


extern struct iobuf rdioin, rdioout;

char TTY_rdioget(void);
int TTY_rdioput(char byte);
void RSM_rdio_enable_rx();
void RSM_rdio_disable_rx();

/*!
\brief swiches the transmitter on
\ingroup RSM
*/
static inline void setRTXSEL() 
{
#ifdef DUART_BASE
if (DUART_BASE) {
	writebyte(DUART_OPRSET,0x2); /*TXSEL = OP1 */
	}
#endif
}

/*!
\brief swiches the receiver on
\ingroup RSM
*/
static inline void setRRXSEL()
{
#ifdef DUART_BASE
if (DUART_BASE) {
	writebyte(DUART_OPRSET,0x1); /*RXSEL = OP0 */
	}
#endif
}

/*!
\brief swiches the transmitter off
\ingroup RSM
*/
static inline void clearRTXSEL()
{
#ifdef DUART_BASE
if (DUART_BASE) {
	writebyte(DUART_OPRRST,0x2);
	}
#endif
}

/*!
\brief swiches the receiver off
\ingroup RSM
*/
static inline void clearRRXSEL()
{ 
#ifdef DUART_BASE
if (DUART_BASE) {
	writebyte(DUART_OPRRST,0x1); 
	}
#endif
}

/*!
\brief returns the carrier status of the receiver
\ingroup RSM
*/
static inline char getRCD()
{
#ifdef DUART_BASE
if (DUART_BASE) {
return  readshortpos(DUART_IP,0x1,0x0); /* IP0 = CD */
	} else {return 0;}
#else
return 0;
#endif

}

#endif

