
#define ACCESS_STATIC_MOTOR
#define USE_RCJBASE
//#define USE_RC99BASE
//#define USE_RGBASE_ONE
#include "motor.h"
#include "config_motor.h"

/* 
\brief writes the motor config into motor[]
\param p is the proportional gain factor as float
\param i is the integrativel gain factor as float
\param d is the differential gain factor as float
\param p2s is the base-dependent pulse-to-speed parameter
*/
int config_motor(float p,float i, float d,float leaky_q,int p2s)
{
MOTOR_set_config(MLEFT,    /* which motor */
                 LEFT_PWM, /* PWM of motor */
		 LEFT_QD1, /* QD1 of motor */
		 LEFT_QD2, /* QD2 of motor */
                 LEFT_TYPE_D0, /* First Fastbin Type*/
		 LEFT_ID_D0,   /* First Fastbin ID */
		 LEFT_TYPE_D1, /* Second Fastbin Type*/
		 LEFT_ID_D1,   /* Second Fastbin ID */
                 p,i,d,leaky_q,10000,p2s);

MOTOR_set_config(MRIGHT,
                 RIGHT_PWM,RIGHT_QD1,RIGHT_QD2,
                 RIGHT_TYPE_D0,RIGHT_ID_D0,RIGHT_TYPE_D1,RIGHT_ID_D1,
                 p,i,d,leaky_q,10000,p2s);
return(0);
}

