#ifndef _CONFIG_DRIVE_H
#define _CONFIG_DRIVE_H

#include <config.h>

/* 
\brief lists all known types of drives in the driveset.
*/
enum drive_types {
	DR_DEFAULT,
	DR_GUARD_V0,
	DR_GUARD_V1,
	DR_GUARD_V2,
	DR_RCUP_FASTFORWARD,
	DR_RCUP_FORWARD,
	DR_RCUP_DEFENDER,
	DR_RCJ,
	NUMBER_OF_BASES
};
 
/*!
\brief this keeps all information about one specific drive in the driveset
*/
typedef struct drive_s {
	float gear_ratio; /*!< this is the gear ratio between the internal
		motor shaft and the wheel */ 
	float wheel_radius; /*!< the wheel radius in mm */ 
	float wheel_dist; /*!< the distance between the wheels in mm */ 
	float enc_res; /*!< encoder resolution in pulses per internal motor shaft
		revolution (motor round) */

	int angle_malpha; /*!< minimal remaining angular distance
		over which the base is still turning with maximal angular velocity. */
	int angle_stop; /*!< Neighborhood of the target angle at which the
		base rotation is stopped, thus the maximal angular resolution. Angular
		differences below angle_stop will not be compensated.*/ 
	int length_apspeed; /*!< maximal translational target approach
		speed. Is in effect if the base is closer to the target than
		length_approach and is used to scale the speed linearly to zero.*/ 
	int length_break; /*!< minimal remaining distance to target where breaking starts. */
	int length_approach; /*!< minimal remaining distance to target where the translation vector switches from break into approach. */
	int length_stop; /*!< Neighborhood of the target at which the
		base translation is stopped, thus the maximal translational resolution. Distance
		differences below length_stop will not be compensated.*/ 

	int pid_p2s; //!< p2s value for the motor configuration 
	float pid_P; //!< proportional gain for motor configuration
	float pid_I; //!< integrative gain for motor configuration
	float pid_D; //!< differential gain for motor configuration
	float pid_leaky_q; //!< q-value for leaky integration; if q==-1 then regular integartion is use
	int pwm_basefreq; //!< PWM base frequency for motor configuration
}drive_t;

/* 
\brief driveset table
*/ 
drive_t DRIVE[NUMBER_OF_BASES];


int config_drives();
int init_drive(int drive);
int ask_type_drive();

#endif

