#include <stdio.h>
#include <math.h>
#include <limits.h>
#include <cubeos.h>
#include <tpu.h>
#include <tpud.h>
#include <sincos.h>
#include <fastbin.h>
#include "fixpoint.h"
#include "motor.h"
#include "drive.h"
#include "recorder.h"
#include "config_drive.h"



//int myrecord[1000][2];
//int myrecorddone=1;
//int myi=0;


int isrcount;
char inisr;
int isrdebug_wait = 1000;
char isrdebug;

void * DRIVEWrapper();


/********* important GLOBAL variables *********/

int dr_drive;

int dr_mode = DRMODE_OFF;

int dr_pulses_left;
int dr_pulses_right;

long long dr_h_long;

long long dr_angl_const = 0LL;
long long dr_dist_const = 0LL;

long long delta_prec_x, delta_prec_y;
long long delta_prec_beta = 0LL;
long long delta_prec_d = 0LL;
long long dr_prec_orientation = 0LL;
long long dr_prec_pos_x = 0LL;
long long dr_prec_pos_y = 0LL;

int dr_orientation = 0;
int dr_pos_x = 0;
int dr_pos_y = 0;

int dr_recal_x_flag = 0;    
int dr_recal_y_flag = 0;    
int dr_recal_alpha_flag = 0;    
int dr_new_x;
int dr_new_y;
int dr_new_alpha;


/* rest for control only */
int dr_leftspeed = 0;
int dr_rightspeed = 0;
int dr_leftspeed_now = 0;
int dr_rightspeed_now = 0;

int dr_x_target, dr_y_target;

int dr_angle_mspeed, dr_angle_malpha, dr_angle_stop;
int dr_length_mspeed, dr_length_break, dr_length_stop;
int dr_length_apspeed, dr_length_approach;

int dr_tran_scale, dr_rot_scale;
int dr_inhibit_alpha;
int dr_vector_done, dr_angledone;
int dr_v_alpha, dr_v_dir;
long long dr_v_l;
                              
int dr_vector_start = 0;
int dr_vector_running = 0;
int dr_vector_aborted = 0;
int dr_vector_completed = 0;

int dr_safe_decay;
int dr_safe_decay_now;
int dr_safe_ldecrease;
int dr_safe_rdecrease;
int dr_safe_downtime;

int dr_delta_t = 0;
int ticks_last;


/* the following ones are for service-functions (get speed etc.)*/

int dr_enc_res;

float dr_gear_ratio;
float dr_wheel_radius;


/**********************************************/

void DRIVE_init_isr () {


	inisr=0;
	isrdebug=0;

	if(!TRI_check_sincos()) TRI_init_sincos();
	if(!TRI_check_atan()) TRI_init_atan();
	if(!TRI_check_sqrt()) TRI_init_sqrt();

	dr_mode = DRMODE_OFF;

#ifdef CONTROL_PWM
        TPU_makepwm_TCR1 (CONTROL_PWM);
        TPU_setpwmperiod (CONTROL_PWM, TCR1FREQ/DR_ISRFREQ); /* to cacalute the isr-freq */
        TPU_setpwmhigh (CONTROL_PWM, 10); 
        TPU_setisr (CONTROL_PWM, (void *)DRIVEWrapper);
        setCIER (CONTROL_PWM, 0x1);     /* Now, _DRIVE_int will be called */
	setHSRR (CONTROL_PWM, 2);
#else
#error No suitable ISR Control TP Channel found. Please check Makefile and motor.h
#endif

}


void _DRIVE_int () {
	long long prec_h=0LL;

	int traspeed = 0;
	int rotspeed = 0;

	short dalph_sign; 
	int delta_alpha;
	int v_l_mm;	

	int h_alpha, h_dx, h_dy;
	char dummy;

/*******************************************************************************************/
	//if (inisr) printf("INISR!\n"); 
	inisr=1;
	dummy = getCISR (CONTROL_PWM);
	clearCISR (CONTROL_PWM);
	isrcount++;

	dr_delta_t = _time_ticks-ticks_last;
//	record.ticks= dr_delta_t;
	ticks_last=_time_ticks;
//	REC_this(&record);

/*******************************************************************************************/
/* small state-machine to check the status of the VECTOR commands */

	if(dr_vector_start == 1) {
		dr_vector_start = 0;
		if(dr_vector_running == 1) {
			dr_vector_aborted++;
		}
		dr_vector_running = 1;
	}


/*******************************************************************************************/
/* transform encoder pulses to normalised and scaled speed in [0,...,10000] */


	dr_pulses_left = _MOTOR_encoder(MLEFT);
	dr_pulses_right = _MOTOR_encoder(MRIGHT);

//if((myi==999)||(myrecorddone)) {
//myi=0;
//myrecorddone = 1; 
//return;
//}
//myrecord[myi][0]=dr_pulses_left;
//myrecord[myi][1]=lspeed;
//myi++;
	
/*******************************************************************************************/
/* completely recalibrate the positions if forced from the outside with DRIVE_recal */

if(dr_recal_x_flag == 1) {
	dr_prec_pos_x = (long long)dr_new_x * (long long)C_FPOINT_SQ;
	dr_recal_x_flag =0;
}
if(dr_recal_y_flag == 1) {
	dr_prec_pos_y = (long long)dr_new_y * (long long)C_FPOINT_SQ;
	dr_recal_y_flag =0;
}
if(dr_recal_alpha_flag == 1) {
	dr_prec_orientation = (long long)dr_new_alpha * (long long)C_FPOINT_SQ;
	dr_recal_alpha_flag =0;
}


/*******************************************************************************************/
/* calculate vector and new position based on encoder pulses */

/* update rotation */
	delta_prec_beta = (dr_angl_const * (dr_pulses_right - dr_pulses_left));
	dr_prec_orientation += delta_prec_beta;

	while(dr_prec_orientation<0LL) 
		dr_prec_orientation += 36000LL*(long long)C_FPOINT_SQ;
	while(dr_prec_orientation>= 36000LL*(long long)C_FPOINT_SQ) 
		dr_prec_orientation -= 36000LL*(long long)C_FPOINT_SQ;

	dr_orientation = (int)(dr_prec_orientation/(long long)C_FPOINT_SQ);

	record.rspeed = (int)(delta_prec_beta/(long long)C_FPOINT); // scaled by 10000
	record.ori = dr_orientation;

/* update distance traveled */
	delta_prec_d = (dr_pulses_left + dr_pulses_right) * dr_dist_const;
	delta_prec_x = (TRI_cos(dr_orientation) * delta_prec_d)/ C_FPOINT;
	delta_prec_y = (TRI_sin(dr_orientation) * delta_prec_d)/ C_FPOINT;

//record.dspeed=(int)(delta_prec_d/(long long)C_FPOINT); // scaled by 10000

/* update position */
	dr_prec_pos_x += delta_prec_x;
	dr_prec_pos_y += delta_prec_y;
	dr_pos_x = (int)(dr_prec_pos_x/(long long)C_FPOINT_SQ);
	dr_pos_y = (int)(dr_prec_pos_y/(long long)C_FPOINT_SQ);

	//record.posx=dr_pos_x;
	//record.posy=dr_pos_y;

/*******************************************************************************************/
/* debug output */

	if (!(isrcount % isrdebug_wait) && (isrdebug)) { 
//		printf ("\n");
//		printf ("dr_pulses_left = %d\n", dr_pulses_left);
//		printf ("dr_pulses_right = %d\n", dr_pulses_right);
//		printf ("dr_real_SPleft = %d\n", dr_real_SPleft);
//		printf ("dr_real_SPright = %d\n", dr_real_SPright);
//		printf ("beta = %d\n", beta);
//		printf("dr_oldleft = %d\n",dr_oldleft);
//		printf("dr_oldright = %d\n",dr_oldright);
		printf("dr_prec_orientation = %qd%d\n",dr_prec_orientation);
		printf("delta_prec_beta = %qd%d\n",delta_prec_beta);
		printf("delta_prec_d = %qd%d\n",delta_prec_d);
		printf("delta_prec_x = %qd%d\n",delta_prec_x);
		printf("delta_prec_y = %qd%d\n",delta_prec_y);
		printf("x (in mm) = %d\n",dr_pos_x);
		printf("y (in mm) = %d\n",dr_pos_y);
		printf("alpha (in cdeg) = %d\n",dr_orientation);
//		printf("seconds = %d\n",_time_seconds);
//		printf("ticks = %d\n",_time_ticks);
//		printf ("dr_v_l = %d\n", dr_v_l);
//		printf ("dr_v_dir = %d\n", dr_v_dir);
		printf ("\n");
	}



/************************************************************************************************/
/* motion-level */

	// handling of the different modes
	switch(dr_mode){
	/****************************************************************************************/
	/* OFF-mode: no motors for testing deadreckoning	*/
	case DRMODE_OFF:
		inisr=0;
		// eventually we also want to record here.
		return;

	/****************************************************************************************/
	/* SPEED-mode: direct speed->PWM control */
	case DRMODE_SPEED:

		MOTOR_pid_speed(MLEFT,dr_leftspeed);
		MOTOR_pid_speed(MRIGHT,dr_rightspeed);
		break;

	/****************************************************************************************/
	/****************************************************************************************/
	/* SAFE SPEED-mode: linearly decrease to zero if no new speed command arrives in time */
	case DRMODE_SAFE_SPEED:

		if(dr_safe_decay_now <=0) { 
			dr_safe_decay_now = 0;
			if(abs(dr_leftspeed)>dr_safe_ldecrease) {
				dr_leftspeed += -dr_safe_ldecrease;
			} else {
				dr_leftspeed = 0;
			}
			if(abs(dr_rightspeed)>dr_safe_rdecrease) {
				dr_rightspeed += -dr_safe_rdecrease;
			} else {
				dr_rightspeed = 0;
			}
		} else {
			dr_safe_decay_now += -dr_safe_decay;
		}

		MOTOR_pid_speed(MLEFT,dr_leftspeed);
		MOTOR_pid_speed(MRIGHT,dr_rightspeed);

		break;

	/****************************************************************************************/
	/* GOTO-mode: goes to a location */
	case DRMODE_GOTO:
		//compute where to go to
		h_dx = dr_x_target - dr_pos_x;
		h_dy = dr_y_target - dr_pos_y;

		// get the distance
		v_l_mm = TRI_vector_length(h_dx, h_dy); 
		
		// get orientation right
		delta_alpha = TRI_vector_angle(h_dx,h_dy) - dr_orientation;
                if (delta_alpha > 18000) {
                        delta_alpha = -(36000 - delta_alpha);
                }
                if (delta_alpha < -18000) {
                        delta_alpha = 36000 + delta_alpha;
                }

		// damp the turning
			if(v_l_mm<40) delta_alpha = 0;
			if(v_l_mm<120) delta_alpha = (delta_alpha*v_l_mm)/120;
			//delta_alpha = delta_alpha/10;

		// calculate how strongly the straight mmovement is inhibited
                if ((abs (delta_alpha)<dr_inhibit_alpha)) {
			dr_h_long = ((long long)C_FPOINT*abs(delta_alpha))/(long long)dr_inhibit_alpha;
                        dr_angledone = C_FPOINT - (int)dr_h_long;
		}

// compensate angle 
		rotspeed = 0;

                dalph_sign = ((delta_alpha >= 0) ? 1 : -1);
                delta_alpha = abs (delta_alpha);
 
                delta_alpha = ((delta_alpha > dr_angle_malpha) ? dr_angle_malpha : delta_alpha);
                delta_alpha = (delta_alpha * C_FPOINT) / dr_angle_malpha;
		/* delta_alpha now in [0,...,10000] */
 
                rotspeed = (C_FPOINT*delta_alpha)/C_FPOINT;
 
// compensate the length of the vector                 
		if(dr_angledone>0) {
		// default speed
			traspeed = C_FPOINT;

		// start breaking when getting near the target
			if(v_l_mm < dr_length_break) {
				prec_h = (long long) C_FPOINT_SQ * (dr_length_break - v_l_mm);
				prec_h = prec_h * (long long) (C_FPOINT-dr_length_apspeed);
				prec_h = prec_h / (long long) (dr_length_break-dr_length_approach);
				prec_h = ((long long) C_FPOINT_SQ * C_FPOINT) - prec_h;
				prec_h = prec_h / (long long) C_FPOINT_SQ;

				traspeed = dr_v_dir * (int) prec_h;
			}

		// slowly approaching target in the end-phase
			if(v_l_mm < dr_length_approach) {
				prec_h = (long long) C_FPOINT_SQ * (dr_length_approach - v_l_mm);
				prec_h = prec_h * (long long) dr_length_apspeed;
				prec_h = prec_h / (long long) dr_length_approach;
				prec_h = ((long long) C_FPOINT_SQ * dr_length_apspeed) - prec_h;
				prec_h = prec_h / (long long) C_FPOINT_SQ;

				traspeed = dr_v_dir * (int) prec_h;
			}

		// within the stop-radius of the desired target => stop 
                        if (v_l_mm < dr_length_stop) {
				if(dr_vector_done==0) {
					dr_vector_completed++; 
					dr_vector_running = 0;
				}

				traspeed = 0;
				rotspeed = 0;
                                dr_vector_done = 1;
                        }

		}

		traspeed = (dr_angledone*traspeed)/C_FPOINT; 
		traspeed = (dr_tran_scale*traspeed)/C_FPOINT; 
		
		rotspeed = ((C_FPOINT-dr_angledone)*rotspeed)/C_FPOINT;
		rotspeed = (dr_rot_scale*rotspeed)/C_FPOINT; 

		MOTOR_pid_speed(MLEFT,traspeed - dalph_sign * rotspeed);
		MOTOR_pid_speed(MRIGHT,traspeed + dalph_sign * rotspeed);

	break;

	/****************************************************************************************/
	/* VECTOR-mode: turn an angle while already going the length */
        case DRMODE_VECTOR:

// get orientation right
                delta_alpha = dr_v_alpha - dr_orientation; 
 
                if (delta_alpha > 18000) {
                        delta_alpha = -(36000 - delta_alpha);
                }
                if (delta_alpha < -18000) {
                        delta_alpha = 36000 + delta_alpha;
                }

		// calculate how strongly the straight mmovement is inhibited
                if ((abs (delta_alpha)<dr_inhibit_alpha)) {
			dr_h_long = ((long long)C_FPOINT*abs(delta_alpha))/(long long)dr_inhibit_alpha;
                        dr_angledone = C_FPOINT - (int)dr_h_long;
		}

// compensate angle 
		rotspeed = 0;

                dalph_sign = ((delta_alpha >= 0) ? 1 : -1);
                delta_alpha = abs (delta_alpha);
 
                delta_alpha = ((delta_alpha > dr_angle_malpha) ? dr_angle_malpha : delta_alpha);
                delta_alpha = (delta_alpha * C_FPOINT) / dr_angle_malpha;
		/* delta_alpha now in [0,...,10000] */
 
                rotspeed = (C_FPOINT*delta_alpha)/C_FPOINT;
 
// compensate the length of the vector                 
		if(dr_angledone>0) {
		// default speed
			traspeed = dr_v_dir * C_FPOINT;

		// the (remaining) distance dr_v_l is decreased and converted in v_l_mm into mm
                        dr_v_l -= (long long)dr_v_dir * delta_prec_d;
			v_l_mm = (int)(dr_v_l / (long long)C_FPOINT_SQ);

		// start breaking when getting near the target
			if(v_l_mm < dr_length_break) {
				prec_h = (long long) C_FPOINT_SQ * (dr_length_break - v_l_mm);
				prec_h = prec_h * (long long) (C_FPOINT-dr_length_apspeed);
				prec_h = prec_h / (long long) (dr_length_break-dr_length_approach);
				prec_h = ((long long) C_FPOINT_SQ * C_FPOINT) - prec_h;
				prec_h = prec_h / (long long) C_FPOINT_SQ;

				traspeed = dr_v_dir * (int) prec_h;
			}

		// slowly approaching target in the end-phase
			if(v_l_mm < dr_length_approach) {
				prec_h = (long long) C_FPOINT_SQ * (dr_length_approach - v_l_mm);
				prec_h = prec_h * (long long) dr_length_apspeed;
				prec_h = prec_h / (long long) dr_length_approach;
				prec_h = ((long long) C_FPOINT_SQ * dr_length_apspeed) - prec_h;
				prec_h = prec_h / (long long) C_FPOINT_SQ;

				traspeed = dr_v_dir * (int) prec_h;
			}

		// within the stop-radius of the desired target => stop 
                        if (v_l_mm < dr_length_stop) {
				if(dr_vector_done==0) {
					dr_vector_completed++; 
					dr_vector_running = 0;
				}

				traspeed = 0;
				rotspeed = 0;
                                dr_vector_done = 1;
                        }

		}

		traspeed = (dr_angledone*traspeed)/C_FPOINT; 
		traspeed = (dr_tran_scale*traspeed)/C_FPOINT; 
		
		rotspeed = ((C_FPOINT-dr_angledone)*rotspeed)/C_FPOINT;
		rotspeed = (dr_rot_scale*rotspeed)/C_FPOINT; 

		MOTOR_pid_speed(MLEFT,traspeed - dalph_sign * rotspeed);
		MOTOR_pid_speed(MRIGHT,traspeed + dalph_sign * rotspeed);

		break;

	/****************************************************************************************/
	default:
		inisr=0;
		return;
	}
	record.speedl=MOTOR[MLEFT].normspeed;
	record.speedr=MOTOR[MRIGHT].normspeed;
	//record.tspeedl=lspeed;
	//record.tspeedr=rspeed;
	// record data
	REC_this(&record);

	inisr=0;

}


/************************************************************************************************/
/* motor-level */

/*! the goto command: move the robot to location (x,y) (in mm) */
void DRIVE_goto(int x, int y) {
	dr_mode = DRMODE_GOTO;

	dr_x_target = x;
	dr_y_target = y;

	dr_inhibit_alpha = 1500; 
 
        dr_vector_done = 0;
        dr_angledone = 0;

	dr_vector_start = 1;
}

/*! the vector command: moves angle alpha then distance l; 
abs_flag specifies whether the angle refers to
absolute (=1) or relative (=0) orientation */
void DRIVE_vector (int alpha, int l, int abs_flag) {
        dr_mode = DRMODE_VECTOR;

	dr_inhibit_alpha = dr_angle_stop;
 
        dr_vector_done = 0;
        dr_angledone = 0;

	dr_vector_start = 1;
 
        if (abs_flag) {
                dr_v_alpha = alpha;
        } else {
                dr_v_alpha = dr_orientation + alpha;
        }
        while (dr_v_alpha < 0)
                dr_v_alpha += 36000;
        while (dr_v_alpha >= 36000)
                dr_v_alpha -= 36000;   
        dr_v_l = (long long)l * (long long)C_FPOINT_SQ; /* holds remaining length of the vector */
        dr_v_dir = ((dr_v_l >= 0LL) ? 1 : -1);
        dr_v_l = ((dr_v_l >= 0LL) ? dr_v_l : (dr_v_l*-1LL) );
}             


void DRIVE_fast_vector (int alpha, int l, int abs_flag, int inhibit_alpha)
{
        dr_mode = DRMODE_VECTOR;
 
        dr_vector_done = 0;
        dr_angledone = 0;

	dr_vector_start = 1;

	dr_inhibit_alpha = inhibit_alpha;
 
        if (abs_flag) {
                dr_v_alpha = alpha;
        } else {
                dr_v_alpha = dr_orientation + alpha;
        }
        while (dr_v_alpha < 0)
                dr_v_alpha += 36000;
        while (dr_v_alpha >= 36000)
                dr_v_alpha -= 36000;   
        dr_v_l = (long long)l * (long long)C_FPOINT_SQ; /* holds remaining length of the vector */
        dr_v_dir = ((dr_v_l >= 0LL) ? 1 : -1);
        dr_v_l = ((dr_v_l >= 0LL) ? dr_v_l : (dr_v_l*-1LL) );
}             

void DRIVE_shutdown() {
	if (dr_mode != DRMODE_OFF) {
		DRIVE_pid_speed(0,0);
		KERN_ssleep(1); 
		_MOTOR_setPW(MLEFT,0);
		_MOTOR_setPW(MRIGHT,0);
		DRIVE_test_dr(); 
	}
}


void DRIVE_test_dr() {
	dr_mode = DRMODE_OFF;
}

/*! PID speed controller for the left and the right wheel */
void DRIVE_pid_speed(int left, int right) {
	dr_mode = DRMODE_SPEED;
	dr_leftspeed=left;
	dr_rightspeed=right;
}

/*! Safe PID speed controller for the wheels which 
  [1] ckecks if the command is not refreshed with `rep_freq' Hz 
  [2] if not, speed is linearly regulated in `downtime' seconds to zero  
These two parameter are set via "DRIVE_set_safespeed". The command 
is for safe operation of speed control over unreliable communication links. */
void DRIVE_safe_pid_speed(int left, int right) {
	dr_safe_decay_now = 10000;
	dr_mode = DRMODE_SAFE_SPEED;

	dr_safe_ldecrease = left/(dr_safe_downtime*DR_ISRFREQ);
	if((dr_safe_ldecrease == 0)&&(left!=0)) dr_safe_ldecrease = left;
	dr_safe_rdecrease = right/(dr_safe_downtime*DR_ISRFREQ);
	if((dr_safe_rdecrease == 0)&&(right!=0)) dr_safe_rdecrease = right;

	dr_leftspeed=left;
	dr_rightspeed=right;
}

/*! sets the minimum command frequency of the safe speed controller and
the time to go down to zero speed */
void DRIVE_set_safespeed(int rep_freq, int downtime) {
	dr_safe_decay = (10000/DR_ISRFREQ)*rep_freq;
	dr_safe_downtime = downtime;
}


/*! scales the translation speed of the base */
void DRIVE_set_translation_scale(float scale) {
	dr_tran_scale = (int)(scale * C_FPOINT);
}
/*! scales the rotation speed of the base */
void DRIVE_set_rotation_scale(float scale) {
	dr_rot_scale = (int)(scale * C_FPOINT);
}

/*! sets the parameters of the PID-controller for both wheels;
a leaky_q of -1.0 leads to normal integration, 
otherwise leaky_q should be within ]0.0,1.0[ */
void DRIVE_set_pid(float P, float I, float D,float leaky_q) {
	MOTOR_set_pid(MLEFT,P,I,D,leaky_q);
	MOTOR_set_pid(MRIGHT,P,I,D,leaky_q);
}

/*! returns the rotational speed of the left motor in rotations/sec (as int) */
int DRIVE_get_leftmotor_speed() {
	long long h;

	h = MOTOR_get_qdec(MLEFT) * DR_ISRFREQ;
	h = h / dr_enc_res;
	return((int)h);
}

/*! returns the rotational speed of the right motor in rotations/sec (as int) */
int DRIVE_get_rightmotor_speed() {
	long long h;

	h = MOTOR_get_qdec(MRIGHT) * DR_ISRFREQ;
	h = h / dr_enc_res;
	return((int)h);
}

/*! returns the rotation speed of the left wheel in m/sec (as float) */
float DRIVE_get_leftwheel_speed() {
	float h;

	h = (float) DRIVE_get_leftmotor_speed() / dr_gear_ratio;
	h = h * 2.0 * 3.14159265359 * dr_wheel_radius;
	return(h);
}

/*! returns the rotation speed of the right wheel in m/sec (as float) */
float DRIVE_get_rightwheel_speed() {
	float h;

	h = (float) DRIVE_get_rightmotor_speed() / dr_gear_ratio;
	h = h * 2.0 * 3.14159265359 * dr_wheel_radius;
	return(h);
}

/*! returns the translation speed of the base in m/sec (as float) */
float DRIVE_get_translation_speed() {
double h;
	h = (double) delta_prec_d * (double) DR_ISRFREQ;
	h = h / ( (double)C_FPOINT_SQ * 1000.0);
	return((float)h);
}

/*! returns the rotational speed of the base in cdeg/sec (as float) */
float DRIVE_get_rotation_speed() {
double h;
	h = (double) delta_prec_beta * (double) DR_ISRFREQ;
	h = h / ( (double)C_FPOINT_SQ * 100.0);
	return((float)h);
}

/*! returns the number of vector commands which have been completed since the last check */
inline int DRIVE_check_vector_completed() {
	int h;

	disable();
	h = dr_vector_completed;
	dr_vector_completed = 0;
	enable();
	return(h);	
}

/*! returns the number of vector commands which have been aborted since the last check */
inline int DRIVE_check_vector_aborted() {
	int h;

	disable();
	h = dr_vector_aborted;
	dr_vector_aborted = 0;
	enable();
	return(h);	
}

/*! returns the x-coordinate of the base (in mm) */
inline int DRIVE_robx() {
	return(dr_pos_x);
}

/*! returns the y-coordinate of the base (in mm) */
inline int DRIVE_roby() {
	return(dr_pos_y);
}

/*! returns the orientation of the base (in centideg) */
inline int DRIVE_robalpha() {
	return(dr_orientation);
}

int _DRIVE_get_delta_t() {
	return(dr_delta_t);
}

/* can be used to re-calibrate the x-coordinate of the base */
inline void DRIVE_recal_x(int new_x) {
	dr_recal_x_flag = 1;	
	dr_new_x = new_x; 
}
/* can be used to re-calibrate the y-coordinate of the base */
inline void DRIVE_recal_y(int new_y) {
	dr_recal_y_flag = 1;	
	dr_new_y = new_y; 
}
/* can be used to re-calibrate the orientation of the base */
inline void DRIVE_recal_alpha(int new_alpha) {
	dr_recal_alpha_flag = 1;	
	dr_new_alpha = new_alpha; 
}



void DRIVE_playback()
{
int i;
struct driverec * rec;

if (dr_mode != DRMODE_OFF)
{
printf("stopping base...\n");
DRIVE_pid_speed(0,0);
KERN_ssleep(1); // give some time for the base to stop completely */
_MOTOR_setPW(MLEFT,0);
_MOTOR_setPW(MRIGHT,0);
DRIVE_test_dr(); // now we're in OFF mode 
printf("base stopped\n");
}
printf("recorder status is %d\n",REC_status());
REC_rewind_play();
printf("playback of recorded data, %d records \n",REC_get_rcount());
printf("n \tx \ty \to \tvr \tvt \tlt \trt \tlc \trc \tdt\n");
for(i=0;i<REC_get_rcount();i++) {
	rec=REC_next();
	if (rec) {
		printf("%d \t%d \t%d \t%d \t%d \t%d \t%d \t%d \t%d \t%d \t%d\n",
		       REC_get_rpcount()-1,
		       rec->posx,rec->posy,rec->ori,
		       rec->rspeed,rec->dspeed,
		       rec->tspeedl,rec->tspeedr,
		       rec->speedl,rec->speedr,
		       rec->ticks);
	} 
}
printf("finished\n");
printf("recorder status is %d\n",REC_status());
REC_rewind_rec();
printf("recorder status is %d\n",REC_status());
}
