#ifndef _DRIVE_H
#define _DRIVE_H


#define DRMODE_OFF		0	 /* switch the motors off to test deadreckoning */ 	
#define DRMODE_SPEED		1  
#define DRMODE_SAFE_SPEED	2  
#define DRMODE_VECTOR		3  
#define DRMODE_GOTO		4


#define DR_ISRFREQ	200	// frequency of the control-isr
//#define DR_ISRFREQ	125	// frequency of the control-isr

/********************************************************************************/

void	DRIVE_init_isr ();
void	_DRIVE_int();
int	_DRIVE_get_delta_t();

void	DRIVE_goto (int x, int y);
void	DRIVE_vector (int alpha, int l, int abs_flag);
void	DRIVE_fast_vector (int alpha, int l, int abs_flag, int inhibit_alpha);
inline int	DRIVE_check_vector_completed();
inline int	DRIVE_check_vector_aborted();

void	DRIVE_pid_speed(int leftspeed, int rightspeed);
void	DRIVE_safe_pid_speed(int leftspeed, int rightspeed);
void	DRIVE_shutdown();

void	DRIVE_set_safespeed(int rep_freq, int downtime);
void	DRIVE_set_translation_scale(float scale);
void	DRIVE_set_rotation_scale(float scale);
void	DRIVE_set_pid(float P, float I, float D, float leaky_q);
void	DRIVE_test_dr();
void	DRIVE_playback();

inline int	DRIVE_robx();
inline int	DRIVE_roby();
inline int	DRIVE_robalpha();

void	DRIVE_recal_x(int new_x);
void	DRIVE_recal_y(int new_y);
void	DRIVE_recal_alpha(int new_alpha);

float	DRIVE_get_translation_speed();
float	DRIVE_get_rotation_speed();
int	DRIVE_get_leftmotor_speed();
int	DRIVE_get_rightmotor_speed();

#endif

