#ifndef _FIXPOINT_H
#define _FIXPOINT_H

/********************************************************************************/
// setting the resolution of the FIXPOINT ARITHMETIC for the controller
// 10000 is nice because: 
// [1] +- 10000^2 = +- 10^8 is still within +- int-max (ca. +- 2x10^9) 
// [2] 10000 = 100 * 100 (useful for sqrt)
// [3] +- 10000^2 can be used for double precision in a long long with
//     +- 10000^2^2 = +- 10^16 is still with +- 2^63 = ca. 9x10^18

#define C_FPOINT	10000	   //!< scale factor for single-precision fixpoint arithmetics
#define C_FPOINT_SQ	100000000  //!< scale factor for double-precision fixpoint arithmetics

#endif

