# 1 "motor.c"
# 1 "/projects/cubeos/src_0490/kernel/cubeos.h" 1
 













  


# 1 "/projects/cubeos/src_0490/config/config.h" 1
 













  



# 1 "/projects/cubeos/src_0490/config/asm_config.h" 1
 













  


# 19 "/projects/cubeos/src_0490/config/config.h" 2






struct config_struct {
	unsigned int  eprom_base;
	unsigned int  cpuram_base;
	unsigned int  duart_base;
	unsigned char  ptimer_vn;
	unsigned int  sci_base;
	unsigned char  sciqsm_vn;
	unsigned int  tpu_base;
	unsigned char  tpu_vn;
	unsigned int  i2ca_base;
	unsigned int  i2cb_base;
	unsigned char  i2ca_vn;
	unsigned char  i2cb_vn;
	unsigned int  fastbin_base;
	unsigned int  rcjfb_base;
	unsigned int  rcj_base;
	unsigned int  rg_base;
	unsigned char  i2ca_initcs;
	unsigned char  i2cb_initcs;
};

# 58 "/projects/cubeos/src_0490/config/config.h"


# 1 "/projects/cubeos/src_0490/config/cube1_config.h" 1
 













  













 
 



# 60 "/projects/cubeos/src_0490/config/config.h" 2


# 87 "/projects/cubeos/src_0490/config/config.h"






# 18 "/projects/cubeos/src_0490/kernel/cubeos.h" 2

# 1 "/projects/cubeos/src_0490/hardware/mc68332.h" 1
 













  
 



























































# 19 "/projects/cubeos/src_0490/kernel/cubeos.h" 2

# 1 "/projects/cubeos/src_0490/kernel/sys_var.h" 1
 













  



 



extern int _KERN_sys_error;
extern unsigned short _KERN_sys_errorcode;
extern unsigned char TTY_Blocking_Serial_Out;
extern unsigned long _time_seconds;
extern unsigned short _time_ticks;
extern unsigned short _KERN_quantum_count;
extern unsigned short _KERN_context_srsave;
extern int __MYPID;
extern int _KERN_disablecount;
extern unsigned short KERN_srsave;
void KERN_sysvarinit();

 






# 20 "/projects/cubeos/src_0490/kernel/cubeos.h" 2

# 1 "/projects/cubeos/src_0490/kernel/schedule.h" 1
 













  



 




# 1 "/projects/cubeos/src_0490/kernel/context.h" 1
 













  
 
 


 

























typedef struct regs *regptr;

 



typedef struct regs {
	long regs[19 ];
} reglist;

 








void KERN_contextsw(regptr oldarea,regptr newarea);



# 24 "/projects/cubeos/src_0490/kernel/schedule.h" 2

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 1 3
 

 


































 









# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/reent.h" 1 3
 

 









# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/_ansi.h" 1 3
 

 











# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 1 3



 
 
# 14 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 3


# 25 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 3


 








# 44 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/config.h" 3













































 
















typedef int __int32_t;
typedef unsigned int __uint32_t;








# 15 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/_ansi.h" 2 3


 
 

























# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/_ansi.h" 3


 








# 13 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/reent.h" 2 3

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 1 3
 


















 
# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/machine/time.h" 1 3










# 21 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 2 3









# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 1 3






 


# 19 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3



 


 





 


# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 





 


















 





 

 

# 131 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 


































typedef long unsigned int size_t;






















 




 

# 271 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


# 283 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 

# 317 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3




 





















# 30 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 2 3


 
# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/machine/types.h" 1 3









# 33 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 2 3



typedef unsigned long  clock_t;




typedef long  time_t;



struct tm
{
  int	tm_sec;
  int	tm_min;
  int	tm_hour;
  int	tm_mday;
  int	tm_mon;
  int	tm_year;
  int	tm_wday;
  int	tm_yday;
  int	tm_isdst;
};

clock_t	    clock       (void)  ;
double	    difftime    (time_t _time2, time_t _time1)  ;
time_t	    mktime      (struct tm *_timeptr)  ;
time_t	    time        (time_t *_timer)  ;

char	  *  asctime     (const struct tm *_tblock)  ;
char	  *  ctime       (const time_t *_time)  ;
struct tm *  gmtime      (const time_t *_timer)  ;
struct tm *  localtime   (const time_t *_timer)  ;

size_t	    strftime    (char *_s, size_t _maxsize, const char *_fmt, const struct tm *_t)  ;

char	  *  asctime_r   	(const struct tm *, char *)  ;
char	  *  ctime_r   	(const time_t *, char *)  ;
struct tm *  gmtime_r   	(const time_t *, struct tm *)  ;
struct tm *  localtime_r   	(const time_t *, struct tm *)  ;

# 84 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/time.h" 3







# 14 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/reent.h" 2 3














typedef __uint32_t __ULong;


struct _glue 
{
  struct _glue *_next;
  int _niobs;
  struct __sFILE *_iobs;
};

struct _Bigint 
{
  struct _Bigint *_next;
  int _k, _maxwds, _sign, _wds;
  __ULong _x[1];
};

 





struct _atexit {
	struct	_atexit *_next;			 
	int	_ind;				 
	void	(*_fns[32 ])(void);	 
};

 






struct __sbuf {
	unsigned char *_base;
	int	_size;
};

 




typedef long _fpos_t;		 
				 

 
























struct __sFILE {
  unsigned char *_p;	 
  int	_r;		 
  int	_w;		 
  short	_flags;		 
  short	_file;		 
  struct __sbuf _bf;	 
  int	_lbfsize;	 

   
  void * 	_cookie;	 

  int	 (*_read)   (void *  _cookie, char *_buf, int _n)  ;
  int	 (*_write)   (void *  _cookie, const char *_buf, int _n)  ;
  _fpos_t  (*_seek)   (void *  _cookie, _fpos_t _offset, int _whence)  ;
  int	 (*_close)   (void *  _cookie)  ;

   
  struct __sbuf _ub;	 
  unsigned char *_up;	 
  int	_ur;		 

   
  unsigned char _ubuf[3];	 
  unsigned char _nbuf[1];	 

   
  struct __sbuf _lb;	 

   
  int	_blksize;	 
  int	_offset;	 

  struct _reent *_data;
};

 







struct _reent
{
   
  int _errno;

   


  struct __sFILE *_stdin, *_stdout, *_stderr;

  int  _inc;			 
  char _emergency[25];
 
  int _current_category;	 
  const  char *_current_locale;

  int __sdidinit;		 

  void  (*__cleanup)   (struct _reent *)  ;

   
  struct _Bigint *_result;
  int _result_k;
  struct _Bigint *_p5s;
  struct _Bigint **_freelist;

   
  int _cvtlen;			 
  char *_cvtbuf;

  union
    {
      struct
        {
          unsigned int _rand_next;
          char * _strtok_last;
          char _asctime_buf[26];
          struct tm _localtime_buf;
          int _gamma_signgam;
        } _reent;
   

 
      struct
        {

          unsigned char * _nextf[30 ];
          unsigned int _nmalloc[30 ];
        } _unused;
    } _new;

   
  struct _atexit *_atexit;	 
  struct _atexit _atexit0;	 

   
  void (**(_sig_func))(int);

   


  struct _glue __sglue;			 
  struct __sFILE __sf[3];		 
};






 








extern struct _reent *_impure_ptr  ;

void _reclaim_reent  (struct _reent *)  ;

 









# 48 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 2 3

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/sys/_types.h" 1 3
 

 








typedef long _off_t;
typedef long _ssize_t;


# 49 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 2 3




# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 1 3






 


# 19 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3



 


 





 


# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 





 


















 





 

 

# 131 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 


# 188 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3





 




 

# 271 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


# 283 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 

# 317 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3




 





















# 53 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/reent.h" 2 3


 
struct stat;
struct tms;
struct timeval;
struct timezone;

 

extern int _close_r  (struct _reent *, int)  ;
extern int _execve_r  (struct _reent *, char *, char **, char **)  ;
extern int _fcntl_r  (struct _reent *, int, int, int)  ;
extern int _fork_r  (struct _reent *)  ;
extern int _fstat_r  (struct _reent *, int, struct stat *)  ;
extern int _getpid_r  (struct _reent *)  ;
extern int _kill_r  (struct _reent *, int, int)  ;
extern int _link_r  (struct _reent *, const char *, const char *)  ;
extern _off_t _lseek_r  (struct _reent *, int, _off_t, int)  ;
extern int _open_r  (struct _reent *, const char *, int, int)  ;
extern _ssize_t _read_r  (struct _reent *, int, void *, size_t)  ;
extern void *_sbrk_r  (struct _reent *, size_t)  ;
extern int _stat_r  (struct _reent *, const char *, struct stat *)  ;
extern unsigned long  _times_r  (struct _reent *, struct tms *)  ;
extern int _unlink_r  (struct _reent *, const char *)  ;
extern int _wait_r  (struct _reent *, int *)  ;
extern _ssize_t _write_r  (struct _reent *, int, const void *, size_t)  ;

 
extern int _gettimeofday_r  (struct _reent *, struct timeval *tp, struct timezone *tzp)  ;





# 25 "/projects/cubeos/src_0490/kernel/schedule.h" 2

# 1 "/projects/cubeos/src_0490/kernel/list.h" 1
 













  
 




 







typedef struct list_s list;
typedef struct entry_s entry;

 


struct entry_s {
list * list;   
entry * prev;  
entry * next;  
void * data;   
int len;       
} ;

 


struct list_s
{
entry * head;  
entry * tail;  
int entries;   
int type;      
};

entry *LIST_head(list *l);
entry *LIST_tail(list *l);
int LIST_entries(list *l);
void LIST_init(list * l);
void LIST_insert_after(entry * e,entry *x);
void LIST_insert_before(entry * e,entry *x);
void LIST_insert_head(list *l,entry *e);
void LIST_insert_tail(list *l,entry *e);
void LIST_delete(entry *e);
void LIST_makeentry(entry *e);


# 26 "/projects/cubeos/src_0490/kernel/schedule.h" 2

 










 




struct process {
	reglist regs;	 
	void *stack;	 
	char state;      
	char irq;	 
	int signal;	 
	int mask;	 
	int ppid;	 
	struct _reent reent;  
	int message;	 
	struct sem_t * sem;   
	unsigned int time_delta;  

	int prio;	 
	entry me;        
	int pid;	 
	int next; 
};
extern struct process _KERN_ptable[16 ];  
 
extern list _KERN_delta;			     
extern list _KERN_prio[16 +1];
int KERN_schedinit();
int KERN_delta_handler();
int KERN_create(void * function);
void KERN_schedule(void);
int getpid();
 
 
int KERN_suspend(int i);
int wakeup(int i);

# 21 "/projects/cubeos/src_0490/kernel/cubeos.h" 2

# 1 "/projects/cubeos/src_0490/kernel/taskconst.h" 1
 













  




 








# 22 "/projects/cubeos/src_0490/kernel/cubeos.h" 2

 



 









 









# 68 "/projects/cubeos/src_0490/kernel/cubeos.h"

static inline void disable()
{
	asm("ori.w #0x0700,%sr");   
}
static inline void enable()
{
	asm("move.w #0x2000,%sr"); 
}








 






typedef int sem_t;  
















 
 
 
 
 
 
 
 










 












 










 




static inline void init_LED()
{
*(unsigned char *)( 0xfffa00  + 0x11  ) =  0x0  ;
*(unsigned char *)( 0xfffa00  + 0x15  ) =  0x8  ;
*(unsigned char *)( 0xfffa00  + 0x17  ) =  0xf7  ;
}
 
static inline void LED_ON()
{
*(unsigned char *)( 0xfffa00  + 0x11  ) =  0x8  ;
}

 
static inline void LED_OFF()
{
*(unsigned char *)( 0xfffa00  + 0x11  ) =  0x0  ;
}


# 1 "motor.c" 2

# 1 "/projects/cubeos/src_0490/hardware/tpu.h" 1
 













  
 




































































# 2 "motor.c" 2

# 1 "/projects/cubeos/src_0490/drivers/tpu/tpud.h" 1
 













  







int TPU_init();
int TPU_makepwm(unsigned char nr);
int TPU_initchannel(unsigned char nr);
int TPU_setpwmperiod(unsigned char nr, unsigned short period);
int TPU_setpwmdc(unsigned char nr, unsigned char hightime);
int TPU_makepac(unsigned char nr);
int TPU_makeqd(unsigned char ch1,unsigned char ch2);
unsigned short TPU_getpac(unsigned char nr);
short TPU_getqd(unsigned char nr);
short TPU_readqd(unsigned char nr);
int TPU_setisr(unsigned char ch, void (*isr) (void));
int TPU_clearisr(unsigned char ch, void (*isr) (void));
int TPU_makedio(unsigned char nr);
int TPU_setdio(unsigned char nr, unsigned char v);




# 3 "motor.c" 2

# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/string.h" 1 3
 















# 1 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 1 3






 


# 19 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3



 


 





 


# 61 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 





 


















 





 

 

# 131 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 


# 188 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3





 




 

# 271 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


# 283 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3


 

 

# 317 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/include/stddef.h" 3




 





















# 17 "/opt/egcs/crossgcc/lib/gcc-lib/m68k-coff/2.95.2/../../../../m68k-coff/include/string.h" 2 3






void *  	  memchr   (const void * , int, size_t)  ;
int 	  memcmp   (const void * , const void * , size_t)  ;
void *  	  memcpy   (void * , const void * , size_t)  ;
void * 	  memmove   (void * , const void * , size_t)  ;
void * 	  memset   (void * , int, size_t)  ;
char 	*  strcat   (char *, const char *)  ;
char 	*  strchr   (const char *, int)  ;
int	  strcmp   (const char *, const char *)  ;
int	  strcoll   (const char *, const char *)  ;
char 	*  strcpy   (char *, const char *)  ;
size_t	  strcspn   (const char *, const char *)  ;
char 	*  strerror   (int)  ;
size_t	  strlen   (const char *)  ;
char 	*  strncat   (char *, const char *, size_t)  ;
int	  strncmp   (const char *, const char *, size_t)  ;
char 	*  strncpy   (char *, const char *, size_t)  ;
char 	*  strpbrk   (const char *, const char *)  ;
char 	*  strrchr   (const char *, int)  ;
size_t	  strspn   (const char *, const char *)  ;
char 	*  strstr   (const char *, const char *)  ;


char 	*  strtok   (char *, const char *)  ;


size_t	  strxfrm   (char *, const char *, size_t)  ;


char 	*  strtok_r   (char *, const char *, char **)  ;

int	  bcmp   (const char *, const char *, size_t)  ;
void	  bcopy   (const char *, char *, size_t)  ;
void	  bzero   (char *, size_t)  ;
int	  ffs   (int)  ;
char 	*  index   (const char *, int)  ;
void * 	  memccpy   (void * , const void * , int, size_t)  ;
char 	*  rindex   (const char *, int)  ;
int	  strcasecmp   (const char *, const char *)  ;
char 	*  strdup   (const char *)  ;
int	  strncasecmp   (const char *, const char *, size_t)  ;
char 	*  strsep   (char **, const char *)  ;
char	*  strlwr   (char *)  ;
char	*  strupr   (char *)  ;





 



















# 4 "motor.c" 2

# 1 "motor.h" 1



# 1 "/projects/cubeos/src_0490/drivers/fastbin/fastbin.h" 1
 













  

















int FBIN_init();
int FBIN_make(int nr,char type,char id);
int FBIN_set(int nr,char v);


# 4 "motor.h" 2



 


typedef struct motor_s {
	int tcrfreq;	 
	unsigned char pwmch;	 
	int pwmper;      
	unsigned char qd1ch;	 
	unsigned char qd2ch;	 
	short qdval;	 
	char f0type;	 
	char f0id;	 
	char f0ch;	 
	char f1type;	 
	char f1id;	 
	char f1ch;	 
	int p2s;	 
	int speedscale;   
	int normspeed;	 
	int PW;		 
	int p;		 
	int i;		 
	int d;		 
        int leaky_q;	 
	int old_pw;	 
	int old_err;	 
	long long acc_err;	 
} motor_t;

extern motor_t MOTOR[3];	 






 


































 
 
# 217 "motor.h"






































void MOTOR_set_pid(int motor,float p, float i, float d, float leaky_q);
void MOTOR_set_speedscale(int motor,float scale);
void MOTOR_pid_speed(int motor, int speed);

void _MOTOR_setPW(int motor, int newPW);
int _MOTOR_encoder(int motor);
short _MOTOR_get_qdec(int motor);

void MOTOR_set_directionbits(int motor);
void MOTOR_set_frequency(int motor,int pulse_frequency);
void MOTOR_set_tpchannels(int motor,int pulse_frequency);
void MOTOR_init(int motor,int pulse_frequency);
int MOTOR_set_config(int motor,
		 unsigned char pwmch,unsigned char qd1ch,unsigned char qd2ch,
		 char f0type, char f0id,char f1type,char f1id,
		 float p,float i,float d,float leaky_q,int speedscale,int p2s);





# 5 "motor.c" 2

# 1 "fixpoint.h" 1



 
 
 
 
 
 
 






# 6 "motor.c" 2


motor_t MOTOR[3]; 

motor_t emptymotor={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};  

 







void MOTOR_set_directionbits(int motor) {
	FBIN_make(MOTOR[motor].f0ch,MOTOR[motor].f0type,MOTOR[motor].f0id);
	FBIN_make(MOTOR[motor].f1ch,MOTOR[motor].f1type,MOTOR[motor].f1id);
}


 









void MOTOR_set_frequency(int motor,int pulse_frequency) {
	MOTOR[motor].pwmper = MOTOR[motor].tcrfreq / pulse_frequency;
        *(unsigned short *)( (0xfffe00  +  0x100 )  +( MOTOR[motor].pwmch *16)+(  2 <<1) ) =    abs (MOTOR[motor].PW) * MOTOR[motor].pwmper / 10000    ;
	TPU_setpwmperiod (MOTOR[motor].pwmch, (unsigned short)MOTOR[motor].pwmper);
	*(unsigned short *)(  (0xfffe00  +  0x18 )  +((1-( MOTOR[motor].pwmch /8))<<1)  ) =  ((*(unsigned short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( MOTOR[motor].pwmch /8))<<1)  )) 	&(~(( 0x3 )<<( ( MOTOR[motor].pwmch &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( MOTOR[motor].pwmch &0x7)<<1 ))    ;	 
}

 








void MOTOR_set_tpchannels(int motor,int pulse_frequency) {
	int period;

	period = 1000000  / pulse_frequency;
	MOTOR[motor].pwmper=period;
	TPU_makepwm_TCR1 (MOTOR[motor].pwmch);
	TPU_setpwmperiod (MOTOR[motor].pwmch, (unsigned short)period);
	TPU_makeqd (MOTOR[motor].qd1ch,MOTOR[motor].qd2ch);
	*(unsigned short *)(  (0xfffe00  +  0x18 )  +((1-( MOTOR[motor].pwmch /8))<<1)  ) =  ((*(unsigned short *)(void *)(  (0xfffe00  +  0x18 )  +((1-( MOTOR[motor].pwmch /8))<<1)  )) 	&(~(( 0x3 )<<( ( MOTOR[motor].pwmch &0x7)<<1 )))) |((( 0x3 )&   2  )<<( ( MOTOR[motor].pwmch &0x7)<<1 ))    ;	 
}

 








void MOTOR_init(int motor,int pulse_frequency)
{
MOTOR_set_tpchannels(motor,pulse_frequency);
MOTOR_set_directionbits(motor);
}

 










int _MOTOR_encoder(int motor) {
	MOTOR[motor].qdval=TPU_getqd (MOTOR[motor].qd2ch);
        MOTOR[motor].normspeed = ((((10000  * MOTOR[motor].qdval)/MOTOR[motor].p2s)  
				   * 10000 )/MOTOR[motor].speedscale);  
	return MOTOR[motor].qdval;
}

 




short _MOTOR_get_qdec(int motor) {
	return(MOTOR[motor].qdval);
}

 






void _MOTOR_setPW(int motor, int newPW){

	MOTOR[motor].PW= newPW;

        if (newPW < 0) {
                FBIN_set (MOTOR[motor].f0ch, 0);
                FBIN_set (MOTOR[motor].f1ch, 1);
        } else {
                FBIN_set (MOTOR[motor].f0ch, 1);
                FBIN_set (MOTOR[motor].f1ch, 0);
        }

        *(unsigned short *)( (0xfffe00  +  0x100 )  +( MOTOR[motor].pwmch *16)+(  2 <<1) ) =    abs (newPW) * MOTOR[motor].pwmper / 10000    ;
}


 









void MOTOR_set_pid(int motor, float P, float I, float D, float leaky_q) {

 
	MOTOR[motor].p = (int)(P * 10000 );
	MOTOR[motor].i = (int)(I * 10000 );
	MOTOR[motor].d = (int)(D * 10000 );
	MOTOR[motor].leaky_q = (leaky_q==-1.0)? -1 : (int)(leaky_q * 10000 );
 
}

 









void MOTOR_set_speedscale(int motor, float scale) {
 
	MOTOR[motor].speedscale = (int)(scale * 10000 );
 
}

 


















int MOTOR_set_config(int motor,
		 unsigned char pwmch,unsigned char qd1ch,unsigned char qd2ch,
		 char f0type, char f0id,char f1type,char f1id,
		 float p,float i,float d, float leaky_q,int speedscale,int p2s)
{

 

if ((motor<0)||(motor>2)) return(-1);


bcopy((void *)&emptymotor,(void *)&MOTOR[motor],sizeof(emptymotor));

MOTOR[motor].pwmch=pwmch;
MOTOR[motor].qd1ch=qd1ch;
MOTOR[motor].qd2ch=qd2ch;
MOTOR[motor].f0type=f0type;
MOTOR[motor].f0id=f0id;
MOTOR[motor].f0ch=motor*2;
MOTOR[motor].f1type=f1type;
MOTOR[motor].f1id=f1id;
MOTOR[motor].f1ch=motor*2+1;
MOTOR[motor].p=(int)(p * 10000 );
MOTOR[motor].i=(int)(i * 10000 );
MOTOR[motor].d=(int)(d * 10000 );
MOTOR[motor].leaky_q=(leaky_q==-1.0)? -1 : (int)(leaky_q * 10000 );
MOTOR[motor].speedscale=speedscale;
MOTOR[motor].p2s=p2s;

 


















return(0);
}


 










void MOTOR_pid_speed(int motor, int speed)
{
	int PW;
	int error_SPEED;
	int dif_error_SPEED;

 

	error_SPEED  = speed - MOTOR[motor].normspeed;
	dif_error_SPEED  = error_SPEED - MOTOR[motor].old_err;
	MOTOR[motor].old_err = error_SPEED;
	if(MOTOR[motor].leaky_q == -1) {
		MOTOR[motor].acc_err += (long long) error_SPEED;
	} else {
		MOTOR[motor].acc_err = (long long) ((
			(10000 -MOTOR[motor].leaky_q) * MOTOR[motor].acc_err * (long long) 10000 
			+ MOTOR[motor].leaky_q * error_SPEED) / 10000 ); 
	}

 
	PW      = MOTOR[motor].old_pw   + (MOTOR[motor].p * error_SPEED)/ 10000 
                              + (MOTOR[motor].i * (int)MOTOR[motor].acc_err)/ 10000 
                              + (MOTOR[motor].d * dif_error_SPEED)/ 10000 ;

 
	if (PW<-10000) PW=-10000;
	if (PW>10000) PW=10000;

 
	_MOTOR_setPW(motor,PW);

 
	MOTOR[motor].old_pw = PW;

}

