#include <stdio.h>
#include <malloc.h>
#include <stddef.h>
#include <string.h>

#include <recorder.h>

void * _REC_memblock=NULL;
int _REC_rcount=0;
int _REC_rsize=0;
int _REC_rnum=0;
int _REC_rpcount;

/*! 
\brief initalizes the recorder
\param records is the numer of records the recorder should allocate space for
\param recordlength is the size of one record

init_recorder tries to allocate the necessary memory to record the requested
ammount of records of length recordlength. It also tries to free any old 
data in case there is still something allocated.
*/
int REC_init_recorder(int records,int recordlength)
{

if (_REC_memblock) {
printf("there seems to be already an allocation, trying to free...\n");
free(_REC_memblock);
}

_REC_memblock = calloc(records,recordlength);

if (_REC_memblock==0){
	printf("calloc(%d,%d) failed...\n",records,recordlength);
	return(REC_FAIL);
}

printf("recorder allocated %d records of size %d\n",records,recordlength);
_REC_rcount=0;_REC_rpcount=0;_REC_rsize=recordlength;_REC_rnum=records;
return(REC_OK);
}

/*! 
\brief resets the recorder to start recording from the beginning of the memory pool
*/
int REC_rewind_rec()
{
if ((_REC_rsize==0)||(_REC_memblock==0)){
	printf("recorder not ready\n");
	return(REC_FAIL);
}
_REC_rcount=0;
return(REC_OK);
}

/*! 
\brief resets the recorder to start playback from the beginning of the memory pool

Prints an error message and returns REC_FAIL (-1) on failure, REC_OK (0) on success.
*/
int REC_rewind_play()
{
if ((_REC_rsize==0)||(_REC_memblock==0)){
	printf("recorder not ready\n");
	return(REC_FAIL);
}
_REC_rpcount=0;
return(REC_OK);
}
/*!
\brief records one record
\param record is a pointer to one record of size recordsize defined in init_recorder

This function records one data record.
If there is something wrong with the recorder, it returns REC_FAIL (-1), if there is
no space left, it returns REC_FULL (1), if everything's ok, it returns REC_OK(0).
\internal there is a commented out printf in this function, to make it safe to
call this function from an ISR even if the recorder is not propperly initialized,
it is commented out.
*/
int REC_this(void * record)
{
if ((_REC_rsize==0)||(_REC_memblock==0)){
//	printf("recorder not ready\n");
	return(REC_FAIL);
}
if (_REC_rcount==_REC_rnum)
	return(REC_FULL); // recorder full 

bcopy(record,_REC_memblock+_REC_rcount*_REC_rsize,_REC_rsize);
_REC_rcount++;
return (REC_OK);
}

/*!
\brief plays back recorded data

This function plays back recorded data. If there is still a record, it returns 
a pointer to the record. If not, it returns a null pointer.
*/
void * REC_next()
{
if (_REC_rpcount<_REC_rcount) {
	return(_REC_memblock+(_REC_rpcount++)*_REC_rsize);
} else return (NULL);
}

/*!
\brief returns if the recorder is ready, whatever this means...
*/
int REC_status()
{

if (_REC_memblock==0 ){
	return(REC_FAIL); // we consider this to be not ready 
}

if (_REC_rcount==0) {
	return(REC_OK); // the recorder is ready to record
}
if (_REC_rcount==_REC_rpcount) {
	return(REC_END); // the recorder is at the end of playback
}
if (_REC_rcount==_REC_rnum)	{
	return(REC_FULL); // the recorder is full
}
return(REC_UNKNOWN); // the recorder is somewhere in the middle of playback
}

