#include <stdio.h>
#include <cubeos.h>
#include <i2cd.h>
#include <digital.h>
#include <analog.h>
#include "rgsens.h"


/*!
\brief roboguard sensor interface initialisation
*/
int init_sensors()
{
int i,j,k;
printf("init I2C\n");
fflush(stdout);
I2C_init(I2CA, I2CA_BASE);
printf("init analog\n");
fflush(stdout);
I2C_init_analog();
printf("init digital\n");
fflush(stdout);
I2C_init_digital();

printf("done");

for (k=0;k<10;k++){

        for(j=1;j<256;j<<=1) {
                SetDisplay(j);
                for (i = 1; i < 10000; i++);
	}
        for(j=256;j>1;j>>=1) {
                SetDisplay(j);
                for (i = 1; i < 10000; i++);
	}
}
SetDisplay(0);
}

/*!
\brief read roboguard sense bits (charge etc.)
*/
unsigned char ReadSenseBits()
{
return I2C_ReadBinIn(1);
}
/*!
\brief sets roboguard display output
*/
void SetDisplay(unsigned char c)
{
I2C_WriteBinOut(0,0xff-c);
}
