#ifndef _SINCOS_H
#define _SINCOS_H

#define SINCOS_MAX_ANGLE 36000
#define SINCOS_RES 50
#define ATAN_RES 100 
#define SQRT_RES 100

/* macros */
#define	MIN(A,B)	(A<B?(A):(B)) //!< determines the minimum of A and B
#define	MAX(A,B)	(A>B?(A):(B)) //!< determines the maximum of A and B
#define SIGN(A)		(A>=0?1:-1)   //!< determines the sign of A


void TRI_init_sincos ();
void TRI_init_atan ();
void TRI_init_sqrt ();

int TRI_sin (int x);
int TRI_cos (int x);
int TRI_atan (int x);
int TRI_sqrt (int x);

int TRI_vector_angle(int dx, int dy);
int TRI_vector_lentgh(int dx, int dy);

int TRI_check_sincos();
int TRI_check_atan();
int TRI_check_sqrt();

#endif


