#include <stdio.h>
#include <ptimer.h>
#include <iobuf.h>
#include <ttyio.h>
#include <schedule.h>
#include <sys/time.h>
#include <limits.h>
#include <softreset.h>
#include <i2cd.h>
#include <analog.h>
#include <digital.h>
#include <readcmd.h>


void help()
{

printf("\n");
printf("CubeOS analog test \n");
printf("----------------------------- \n\n");
printf("l : list all analog devices    \n");
printf("r <chip> <ch> : read chip ch   \n");
printf("a <chip> : read all chip   \n");
printf("c <chip> : continous read  \n");
printf("q         : softreset         \n\n");
printf("?         : show this         \n\n");
}


int main()
{

	char c;
	int p1,p2;
	int n;
	int i;
	TTY_conecho_on();
	printf("init i2c\n");fflush(stdout);
	I2C_init(I2CA, I2CA_BASE);
	printf("init analog\n");fflush(stdout);
	I2C_init_analog();
	printf("init digital\n");fflush(stdout);
	I2C_init_digital();

	help();
while (1){

	printf("\n");

        n = sscanf(readcmd("l/r/a/c/b/q/?: "),"%c %d %d",&c,&p1,&p2);
        printf("\n");

	if ((n==1) && (c=='q')) KERN_softreset();
	if ((n==1) && (c=='?')) help();
	if ((n==1) && (c=='l') )
	    {
		for(i=0;i<_I2C_adnum;i++)
			if (_I2C_ad_data[i].active){
				printf("analog device %d at adress 0x%x \n",
				       i,_I2C_ad_data[i].address);
				printf("Channel 0: %d\n",I2C_ReadAnalogIn(i,0));
				printf("Channel 1: %d\n",I2C_ReadAnalogIn(i,1));
				printf("Channel 2: %d\n",I2C_ReadAnalogIn(i,2));
				printf("Channel 3: %d\n",I2C_ReadAnalogIn(i,3));
			}

	    }
	if ((n==3) && (c=='r'))
	    {
		if ((p1>=0) && (p1<_I2C_adnum) && (p2>=0) && (p2<=3)){
			printf(" Chip %d Channel %d : %d\n",p1,p2,I2C_ReadAnalogIn(p1,p2));
		} else {	
			printf("ERROR: no such a/d\n");
		}
	    }

	if ((n==2) && (c=='b'))
	    {
		if ((p1>=0) && (p1<_I2C_binnum)){
			printf(" Chip %d:\n",p1);
			printf("   Channel 0: %d\n",I2C_ReadBinIn(p1));
			I2C_messagestatus (&_I2C_digital_m);
		} else {	
			printf("ERROR: no such bin\n");
		}
	    }
	if ((n==2) && (c=='a'))
	    {
		if ((p1>=0) && (p1<_I2C_adnum)){
			printf(" Chip %d:\n",p1);
			printf("   Channel 0: %d\n",I2C_ReadAnalogIn(p1,0));
			I2C_messagestatus (&_I2C_analog_m);
			printf("   Channel 1: %d\n",I2C_ReadAnalogIn(p1,1));
			I2C_messagestatus (&_I2C_analog_m);
			printf("   Channel 2: %d\n",I2C_ReadAnalogIn(p1,2));
			I2C_messagestatus (&_I2C_analog_m);
			printf("   Channel 3: %d\n",I2C_ReadAnalogIn(p1,3));
			I2C_messagestatus (&_I2C_analog_m);
		} else {	
			printf("ERROR: no such a/d\n");
		}
	    }
	if ((n==2) && (c=='c'))
	    {
		if ((p1>=0) && (p1<_I2C_adnum)){
			while(1){
			printf(" Chip %d:",p1);
			printf("Channel 0: %4d ",I2C_ReadAnalogIn(p1,0));
			printf("Channel 1: %4d ",I2C_ReadAnalogIn(p1,1));
			printf("Channel 2: %4d ",I2C_ReadAnalogIn(p1,2));
			printf("Channel 3: %4d\n",I2C_ReadAnalogIn(p1,3));
			for(i=0;i<250000;i++);
			}
		} else {	
			printf("ERROR: no such a/d\n");
		}
	    }

	}
	return (0);
}
