#include <stdio.h>
#include <ptimer.h>
#include <conio.h>
#include <schedule.h>
#include <sys/time.h>
#include <limits.h>
#include <icontrol.h>
#include <readcmd.h>
#include <basics.h>
#include <communic.h>
#include <potarea.h>


extern int data_buf[3];


int
main (int argc, char *argv[]) {
	int 	errorflag;
	short	pacount;


	pacount = 0;

/************************************************************************/

        printf("\n\n\n\n");
        printf("*********************************\n");
	printf("\nRoboGuard DemoBase V1.1\n");
        printf("\n");
        printf("*********************************\n");

        printf("\n");
        printf("\n");

	icontrol_set_basetype(IC_GUARD);
	conecho_on();

/* MAKE SURE THAT THE BASE-TYPE IS PROPERLY SET BEFORE INIT !!! */
/* MAKE SURE THAT DEAD_RECKONING IS PROPERLY SET BEFORE INIT !!! */

        printf("\nInit controller...\n");
	errorflag = init_icontrol(1);
	if(errorflag == -1) return(-1);
        printf("\n...done!\n\n");

/* init the potential area calculations (sets the activ/used pot.areas) */
	//init_potarea_calc();




/************************************************************************/
/* MAIN LOOP */

while(1){
	/* ready to go... */
	printf("rob: x %d, y %d, alpha %d\n",ic_robx(),ic_roby(),ic_robalpha());
	printf("%hd",pacount);
	pacount++;
	printf("@\n");

	/* get a new line */
	errorflag = getdataline();

//printf("line ok: %d \n",okflag);


	/* the packet contained commands and one command is for you */
	if(!errorflag) {

//isrdebug = 1;
		
		switch(data_buf[0]) {
		case COM_RVECT:
			icontrol_vector(data_buf[1], data_buf[2], 0);
		break;

		case COM_AVECT:
			icontrol_vector(data_buf[1], data_buf[2], 1);
		break;

		case COM_SPEED:
			icontrol_speed(data_buf[1], data_buf[2]);
		break;

		default:
			break;
		}
		
	}
}
	return (0);
}
