#include <stdio.h>
#include <ptimer.h>
#include <iobuf.h>
#include <ttyio.h>
#include <schedule.h>
#include <sys/time.h>
#include <limits.h>
#include <readcmd.h>
#include <motor.h>
#include <tpud.h>
#include <fastbin.h>
#include <softreset.h>
#include <RobLib.h>

#define RAMPDELAY 30000
#define MAXSPEED 30
int globalclock;
int starttime;

int checkkey()
{
char c;
while (TTY_tty[_TTY_contty].inq->cnt)
	{
	c=TTY_inchar();
	if (c=='e') return 1;
	}
if (_time_seconds>=(globalclock+10)) {
	globalclock=_time_seconds;
	printf("Runtime: %d:%2d\n",(globalclock-starttime)/60,(globalclock-starttime)%60);
	}
return 0; 
}

int setmotor(short left, short right)
{
_MOTOR_setPW(MLEFT,left);
_MOTOR_setPW(MRIGHT,right);
}


void dumpconfig()
{
printf("motor configuration dump\n");
printf("MLEFT: \n");
printf("tcrfreq = %d\t",MOTOR[MLEFT].tcrfreq);
printf("pwmch   = %d\t",MOTOR[MLEFT].pwmch);
printf("pwmper   = %d\n",MOTOR[MLEFT].pwmper);
printf("qd1ch    = %d\t",MOTOR[MLEFT].qd1ch);
printf("qd2ch    = %d\t",MOTOR[MLEFT].qd2ch);
printf("qdval    = %d\n",MOTOR[MLEFT].qdval);
printf("f0type   = %d\t",MOTOR[MLEFT].f0type);
printf("f0id     = %d\t",MOTOR[MLEFT].f0id);
printf("f0ch     = %d\n",MOTOR[MLEFT].f0ch);
printf("f1type   = %d\t",MOTOR[MLEFT].f1type);
printf("f1id     = %d\t",MOTOR[MLEFT].f1id);
printf("f1ch     = %d\n",MOTOR[MLEFT].f1ch);
printf("p2s      = %d\t",MOTOR[MLEFT].p2s);
printf("speedsc. = %d\t",MOTOR[MLEFT].speedscale);
printf("normspeed= %d\n",MOTOR[MLEFT].normspeed);
printf("PW       = %d\n",MOTOR[MLEFT].PW);
printf("p        = %d\t",MOTOR[MLEFT].p);
printf("i        = %d\t",MOTOR[MLEFT].i);
printf("d        = %d\n",MOTOR[MLEFT].d);
printf("leaky_q  = %d\n",MOTOR[MLEFT].leaky_q);
printf("MRIGHT: \n");
printf("tcrfreq = %d\t",MOTOR[MRIGHT].tcrfreq);
printf("pwmch   = %d\t",MOTOR[MRIGHT].pwmch);
printf("pwmper   = %d\n",MOTOR[MRIGHT].pwmper);
printf("qd1ch    = %d\t",MOTOR[MRIGHT].qd1ch);
printf("qd2ch    = %d\t",MOTOR[MRIGHT].qd2ch);
printf("qdval    = %d\n",MOTOR[MRIGHT].qdval);
printf("f0type   = %d\t",MOTOR[MRIGHT].f0type);
printf("f0id     = %d\t",MOTOR[MRIGHT].f0id);
printf("f0ch     = %d\n",MOTOR[MRIGHT].f0ch);
printf("f1type   = %d\t",MOTOR[MRIGHT].f1type);
printf("f1id     = %d\t",MOTOR[MRIGHT].f1id);
printf("f1ch     = %d\n",MOTOR[MRIGHT].f1ch);
printf("p2s      = %d\t",MOTOR[MRIGHT].p2s);
printf("speedsc. = %d\t",MOTOR[MRIGHT].speedscale);
printf("normspeed= %d\n",MOTOR[MRIGHT].normspeed);
printf("PW       = %d\n",MOTOR[MRIGHT].PW);
printf("p        = %d\t",MOTOR[MRIGHT].p);
printf("i        = %d\t",MOTOR[MRIGHT].i);
printf("d        = %d\n",MOTOR[MRIGHT].d);
printf("leaky_q  = %d\n",MOTOR[MRIGHT].leaky_q);
}

void motortest()
{
int nowspeed;
int i;
int exit=0;
globalclock=_time_seconds;
starttime=globalclock;

printf("Entering automated motor & battery test\n");

printf("Press 'e' to exit");

setmotor(0,0);
while (!exit){
/* this drives up a ramp */
printf("right\n");
for(nowspeed=0;nowspeed<MAXSPEED;nowspeed++)
{
 exit=checkkey();
 if (exit) {
	setmotor(0,0);
	return;
 }
 setmotor(nowspeed*100,-nowspeed*100);
 KERN_usleep(RAMPDELAY);
}
/* this drives down the ramp */
printf("stop\n");
for(nowspeed=MAXSPEED;nowspeed>0;nowspeed--)
{
/* this drives up a ramp */
 exit=checkkey();
 if (exit) {
	setmotor(0,0);
	return;
 }
 setmotor(nowspeed*100,-nowspeed*100);
 KERN_usleep(RAMPDELAY);
}
printf("left\n");
for(nowspeed=0;nowspeed<MAXSPEED;nowspeed++)
{
/* this drives up a ramp */
 exit=checkkey();
 if (exit) {
	setmotor(0,0);
	return;
 }
 setmotor(-nowspeed*100,nowspeed*100);
 KERN_usleep(RAMPDELAY);
}
printf("stop\n");
for(nowspeed=MAXSPEED;nowspeed>0;nowspeed--)
{
/* this drives up a ramp */
 exit=checkkey();
 if (exit) {
	setmotor(0,0);
	return;
 }
 setmotor(-nowspeed*100,nowspeed*100);
 KERN_usleep(RAMPDELAY);
}

}
 setmotor(0,0);

}

void help()
{

printf("\n");
printf("CubeOS interactive motor test \n");
printf("----------------------------- \n\n");
printf("l <value> : Set left motor    \n");
printf("r <value> : Set right motor   \n");
printf("b <value> : Set both motors   \n");
printf("            [-10000 - 10000]  \n\n");
printf("f <value> : Set PWM frequency \n");
printf("            [in Hz]           \n\n");
printf("s         : stop motors       \n\n");
printf("t         : run automated     \n");
printf("            test pattern      \n\n");
printf("c         : dump motor config \n\n");
printf("q         : softreset         \n\n");
printf("?         : show this         \n\n");
}


int main()
{

	int frequency,left,right;
	char c;
	int p;
	int n;
	TTY_conecho_on();
	RCJ_init();


	frequency = 100; // in Hz
	left = 0;
	right=0;
        config_motor(0.0,0.0,0.0,-1.0,1);
        MOTOR_init(MLEFT,frequency);
        MOTOR_init(MRIGHT,frequency);

	MOTOR[MLEFT].p2s=1;
	MOTOR[MRIGHT].p2s=1;
	MOTOR[MLEFT].tcrfreq=1;
	MOTOR[MRIGHT].tcrfreq=1;
	MOTOR[MLEFT].speedscale=1;
	MOTOR[MRIGHT].speedscale=1;

	setmotor(MLEFT,0);
	setmotor(MRIGHT,0);


	help();
while (1){

	printf("\n");
	printf("frequency = %d\n",frequency);
	printf("left = %d\n",left);
	printf("right = %d\n",right);
	printf("leftenc = %d\n",_MOTOR_encoder(MLEFT));
	printf("rightenc = %d\n",_MOTOR_encoder(MRIGHT));

        n = sscanf(readcmd("l/r/b/f/s/t/q/?: "),"%c %d",&c,&p);
        printf("\n");

	if ((n==1) && (c=='q')) KERN_softreset();
//	if ((n==1) && (c=='t')) motortest();
	if ((n==1) && (c=='s')) setmotor(0,0);
	if ((n==1) && (c=='?')) help();
	if ((n==1) && (c=='c')) dumpconfig();
	if ((n==2) && (c=='l') )
	    {
		if ((p<=10000) && (p>=-10000))
		    {
			left = p;
			setmotor(left,right);
			printf("setting left to %d\n",left);
		    } else
		{
			printf("ERROR: can't set left to %d\n",p);
		}
	    }
	if ((n==2) && (c=='r'))
	    {
		if ((p<=10000) && (p>=-10000))
		    {
			right = p;
			setmotor(left,right);
			printf("setting right to %d\n",right);
		    } 
		else
		{	
			printf("ERROR: can't set right to %d\n",p);
		}
	    }

	if ((n==2) && (c=='b'))
	    {
		if ((p<=10000) && (p>=-10000))
		    {
			right = p;
			left = p;
			setmotor(left,right);
			printf("setting both to %d\n",right);
		    } 
		else
		{	
			printf("ERROR: can't set right to %d\n",p);
		}
	    }

	if ((n==2) && (c=='f'))
	    {
		if ((p<=TCR1FREQ/2) && (p>=5))
		    {
			frequency = p;
			MOTOR_set_frequency(MLEFT,frequency);
			MOTOR_set_frequency(MRIGHT,frequency);
			printf("setting frequency to %d\n",frequency);
		    }
		else
		{
			printf("ERROR: can't set frequency to %d\n",p);
		}
	    }

	}
	return (0);
}
