#include <stdio.h>
#include <readcmd.h>
#include <ttyio.h>

char commandbuf[MAXCLEN];


char *readcmd(char *prompt)
{
  char *iptr;			/* points to the location of the next insert */
  char c;
  char done;
  char processed;
  if (prompt)
    LIBC_outstring(prompt);
  done = 0;

  TTY_conecho_off();

  iptr = commandbuf;

  while (!done) {
    processed = 0;
    c = TTY_inchar();
    if (c == CRin) {
      done = 1;
      processed = 1;
    }

    if (c == BSin) {
      /* Backspace */
      if (iptr > commandbuf) {
	iptr--;
	LIBC_outstring(BSout);
	processed = 1;
      }
    }

    if (c >= 0x20 && c <= 0x7E) {
      /* usual char */
      if ((iptr - commandbuf) < MAXCLEN) {
	(*iptr++) = c;
	TTY_outchar(c);
	processed = 1;
      }
    }

    /* default */
    if (processed == 0) {
      LIBC_outstring(BELLout);
    }
  }

  (*iptr) = 0;			/* End of String */

  TTY_conecho_on();
  fflush(stdin);
  fflush(stdout);
  return (commandbuf);
}

