#include <stdio.h>
#include <communic.h>

/************************************************************************/
/* GLOBAL VARIABLES                                                     */

int data_buf[5];

/************************************************************************/



/*!
\brief gets one host data line

The function uses an internal buffer to store the last dataset parsed. It
is partially overwritten when calling, so use the return code to distinguish
valid from invalid data. The function returns 0 on success, -1 on failure.
*/
int getdataline() {
	char 	line[SAFELINE];
	char 	c;
	short	count;
	int	nrread;


	count = 0;
	c = TTY_inchar();

	do {
		line[count] = c;
		count++;
		c = TTY_inchar();
	} while((c != '\r') && (c != '\n') && (count < SAFELINE));

	if((count == SAFELINE)||(count<=1))
		return(-1);

	line[count] = 0;	

	nrread = sscanf(line, "%d %d %d %d %d", 
		&data_buf[0],&data_buf[1],&data_buf[2],&data_buf[3],&data_buf[4]); 	
	printf("\n");
	if(nrread != 5)
		return(-1);
		
	return(0);
}


