#include <stdio.h>
#include <cubeos.h>
#include <ptimer.h>
#include <ttyio.h>
#include <schedule.h>
#include <sys/time.h>
#include <limits.h>
#include <i2cd.h>
#include <analog.h>
#include <digital.h>

#include <RobLib.h>

#include "communic.h"


extern int data_buf[3];


//extern int myrecord[1000][2];
//extern int myrecorddone;


int global_cmd_nr;
int global_vec_nr;
int global_cmd_code;

int output_thread_id;

void output_thread() {
	int h;

	while(1){
		h = DRIVE_check_vector_completed();
		if(h!=0) {
			printf("#%d %d\n",global_cmd_code,global_vec_nr);
			KERN_suspend(output_thread_id);
		}
	}
}


int
main (int argc, char *argv[]) {
	int 	errorflag;
	int	pacount;
	int 	i;
	int	air[5];

	int joy_x, joy_y, joy_r, joy_s;
	int command;

//	float P, I, D;
	int left_speed, right_speed;
	int old_left_speed, old_right_speed;
	int max_speed, now_max_speed;


	pacount = 0;
//	TTY_setcontty(2);

	TTY_Blocking_Serial_Out=0;

/************************************************************************/

        printf("\n\n\n\n");
        printf("*********************************\n");
	printf("\nRoboGuard DemoBase V5.29\n");
        printf("\n");
        printf("*********************************\n");

        printf("\n");
        printf("\n");

	TTY_conecho_on();

/***************************************************************************/

	printf("\n********** Init I2C...\n");
	I2C_init(I2CA,I2CA_BASE);
	printf("\ndigital\n");
	I2C_init_digital();
	printf("\nanalog\n");
	I2C_init_analog();
	
        printf("\n********** Init Controller...\n");
        printf("preparing lookup tables:\n");
        printf("sin and cos\n");
        TRI_init_sincos ();
        printf("atan\n");
        TRI_init_atan ();
        printf("sqrt\n");
        TRI_init_sqrt ();       
	printf("OK\n");

	printf("preparing recorder:\n");
	REC_init_recorder(1000,sizeof(record));
	printf("OK\n");

	printf("preparing drive:\n");
	config_drives();
	init_drive(DR_RCJ);
	printf("OK\n");

	printf("preparing interrupt service routine (ISR) for control:\n");
	DRIVE_init_isr();
	printf("OK\n");

	printf("********** Controller ready!\n\n");


/************************************************************************/
/* start thread for COMMAND NOTIFICATION */
	output_thread_id = KERN_create(output_thread);
	KERN_suspend(output_thread_id);


/************************************************************************/
/* MAIN LOOP */


//DRIVE_set_scale(0.2);
//while(1) {
//sscanf(readcmd("P: "),"%f",&P);
//printf("\n");
//sscanf(readcmd("I: "),"%f",&I);
//printf("\n");
//scanf(readcmd("D: "),"%f",&D);
//printf("\n");
//
//DRIVE_set_pid(P,I,D);
//myrecorddone = 0;
//DRIVE_pid_speed(10000, 10000);
//while(!myrecorddone) { printf("."); }
//printf("\n"); 
//for(i=0;i<1000;i++) {
//printf("%d %d %d\n", i, myrecord[i][0], myrecord[i][1]);
//}
//myrecorddone = 0;
//DRIVE_pid_speed(0, 0);
//while(!myrecorddone) { printf("."); }
//}

	max_speed = 10000;
	left_speed = 0;
	right_speed = 0;
	old_left_speed = 0;
	old_right_speed = 0;

	DRIVE_set_translation_scale(0.20);
	DRIVE_set_rotation_scale(0.15);

	/* speed commands with 1 Hz minimum or breaking linearly over 2 sec */
	DRIVE_set_safespeed(1,2); 


while(1){
	/* ready to go... */

	printf("@%d\n",pacount);
	global_cmd_nr = pacount;
	pacount++;

	/* get a new line */
	errorflag = getdataline();
	if(!errorflag) {
	
	command = data_buf[0];
	switch(command) {

		case CMD_STATUS:
		printf("rob: x %d, y %d, alpha %d\n",DRIVE_robx(),DRIVE_roby(),DRIVE_robalpha());
		printf("#%d %d\n",CMD_STATUS,global_cmd_nr);
		break;


		case CMD_STAT_SPEED:
		printf("speed: translation %4.2f (m/sec) , rotation %5.2f (deg/sec) \n", 
			DRIVE_get_translation_speed(), DRIVE_get_rotation_speed() );
		printf("#%d %d\n",CMD_STAT_SPEED,global_cmd_nr);
		break;


		case CMD_STAT_AIR:
		air[0] = I2C_ReadAnalogIn(0,0); // leftmost sensor
		air[1] = I2C_ReadAnalogIn(0,1);
		printf("Ball sens: ");
		for(i=0;i<=1;i++) printf("%d ",air[i]);
		printf("\n");
		printf("#%d %d\n",CMD_STAT_AIR,global_cmd_nr);
		printf("Binary Sensor %d\n",I2C_ReadBinIn(8));

		break;
		

		case CMD_JOYSTICK:
		joy_x = data_buf[1];
		joy_y = data_buf[2];
		joy_r = data_buf[3];
		joy_s = data_buf[4];

		old_left_speed = left_speed;
		old_right_speed = right_speed;

		now_max_speed = (joy_s*max_speed)/10000;

		if(joy_r != 0) {
			now_max_speed = (2000*max_speed)/10000;

			left_speed = (joy_r * now_max_speed)/10000;
			right_speed = (-joy_r * now_max_speed)/10000;
	
		} else {
			if(joy_x != 0) {
				now_max_speed = (now_max_speed * (100000-abs(joy_x)*5))/100000;
			}
	
			left_speed = (joy_y * now_max_speed)/10000;
			right_speed = (joy_y * now_max_speed)/10000;
	
			if(joy_x < 0) {
				left_speed = ((10000+joy_x)*left_speed)/10000;
			} else {
				right_speed = ((10000-joy_x)*right_speed)/10000;
			}
		}

		left_speed = old_left_speed+((left_speed-old_left_speed)*40)/100;
		right_speed = old_right_speed+((right_speed-old_right_speed)*40)/100;

		DRIVE_safe_pid_speed(left_speed, right_speed);
		//DRIVE_pid_speed(left_speed, right_speed);
		printf("#%d %d\n",CMD_JOYSTICK,global_cmd_nr);
		break;

		case CMD_SPEED:	
		DRIVE_pid_speed(data_buf[1], data_buf[2]);
//while(1) {
//	printf("%d \n", (int)_MOTOR_get_qdec(MLEFT));
//	KERN_ssleep(1);
//}
		printf("#%d %d\n",CMD_SPEED,global_cmd_nr);
		break;

		case CMD_RVECT:	
		global_vec_nr = global_cmd_nr;
		global_cmd_code=CMD_RVECT;
		KERN_wakeup(output_thread_id);
		DRIVE_vector(data_buf[1]*100, data_buf[2]*10,0);
		break;

		case CMD_AVECT:	
		global_vec_nr = global_cmd_nr;
		global_cmd_code=CMD_AVECT;
		KERN_wakeup(output_thread_id);
		DRIVE_vector(data_buf[1]*100, data_buf[2]*10,1);
		break;

		case CMD_PWM:	
// FOR DEBUGGING ONLY!!! THIS COMMAND CAN BE DANGEROUS!!!
		_MOTOR_setPW(MLEFT,data_buf[1]);
		_MOTOR_setPW(MRIGHT,data_buf[2]);

//while(1) {
//	printf("%d ", (int)_MOTOR_get_qdec(MLEFT));
//	printf("%d \n", _DRIVE_get_delta_t());
//	KERN_usleep(200000);
//}
//		printf("#%d %d\n",CMD_PWM,global_cmd_nr);
//
//		break;

		case CMD_OFF:	
// this command needs 1 sec to bring the base to a controlled
// standstill before the motors are completely disactivated 
		DRIVE_shutdown(); 
		printf("#%d %d\n",CMD_OFF,global_cmd_nr);
		break;
		case CMD_PLAY:	
// This command stops a moving base and switches into OFF mode. 
// Don't use it if the base might roll away...
		DRIVE_playback();
		printf("#%d %d\n",CMD_OFF,global_cmd_nr);
		break;

	}
	
	}
}
	return (0);
}
