#ifndef LOADJPG_H
#define LOADJPG_H


#include <stdio.h>
extern "C" {
#include <jpeglib.h>
}
#include<stdlib.h>
#include <string.h>
#include <GL/gl.h>
#include <GL/glu.h>

/*
	filename - string to file
	height   - will be set to the height of the pic
	width   - will be set to the width of the pic
	components   - will be set to the number of components (color channels) of the pic

	returns a pointer to allocated memory holding the picture data
*/
unsigned char * LoadJPG( char filename[], int & height, int & width, int & components);

/*
	saves a buffer to disk as a rgb jpg image
*/
void SaveJPG(char filename[], int height, int width, int components, int quality, unsigned char* data);

/*
	takes the filename of a jpg picture and puts it as the current texture
*/
void LoadJPGTexture(char filename[]);

/*
	take a screenshot with a certain quality
*/
void TakeJPGScreenshot(char filename[], int quality);

#endif //LOADJPG_H
