#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>

GdkGC *mygc =NULL;
GdkColor black;
GdkColor white;
GdkColor green;
GdkColor lime_green;
GdkColor yellow;
GdkColor red;

gboolean draw_crosshairs(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
  static int buttons = 0;
  static int x,y;
  static Display *d;
  int w, xx, xy, dummy, b;
  if (!d)
    d = GDK_WINDOW_XDISPLAY(widget->window);

  XQueryPointer(d,DefaultRootWindow(d),&w,&w,&xx,&xy,&dummy,&dummy,&b);

  if (gdk_events_pending())
    return TRUE;
  if ((x==0)&&(y==0)) {
    gdk_window_clear(widget->window);

  }
  gdk_gc_set_foreground(mygc,&black);
  gdk_draw_rectangle(widget->window,mygc,1,0,y-10,gdk_screen_width(),20);
  gdk_draw_rectangle(widget->window,mygc,1,x-10,0,20,gdk_screen_height());


  if (b&256) {
      gdk_gc_set_foreground(mygc,&white);
  } else {
      gdk_gc_set_foreground(mygc,&green);
  }
  gdk_draw_rectangle(widget->window,mygc,1,0,0,20,gdk_screen_height()/10);

  if (b&512) {
      gdk_gc_set_foreground(mygc,&white);
  } else {
      gdk_gc_set_foreground(mygc,&yellow);
  }
  gdk_draw_rectangle(widget->window,mygc,1,20,0,20,gdk_screen_height()/10);

  if (b&1024) {
      gdk_gc_set_foreground(mygc,&white);
  } else {
      gdk_gc_set_foreground(mygc,&red);
  }
  gdk_draw_rectangle(widget->window,mygc,1,40,0,20,gdk_screen_height()/10);


  x=event->x;
  y=event->y;
  gdk_gc_set_foreground(mygc,&white);
  gdk_draw_rectangle(widget->window,mygc,1,0,y-10,gdk_screen_width(),20);
  gdk_draw_rectangle(widget->window,mygc,1,x-10,0,20,gdk_screen_height());
  usleep(50000);
  return TRUE;
}

int main(int argc, char **argv)
{
  GdkColormap *cmap;
  int events;
  GtkWidget *win;
  GtkWidget *darea;
  gtk_init(&argc, &argv);
  win=gtk_window_new(GTK_WINDOW_POPUP);
  darea=gtk_drawing_area_new();
  gtk_container_add(GTK_CONTAINER(win),darea);
  gtk_widget_realize(darea);
  mygc=gdk_gc_new(darea->window);
  events=(int)gdk_window_get_events(darea->window);
  gtk_signal_connect(GTK_OBJECT(darea),"button_press_event",
      GTK_SIGNAL_FUNC(draw_crosshairs),NULL);
  gtk_signal_connect(GTK_OBJECT(darea),"button_release_event",
      GTK_SIGNAL_FUNC(draw_crosshairs),NULL);
  gtk_signal_connect(GTK_OBJECT(darea),"motion_notify_event",
      GTK_SIGNAL_FUNC(draw_crosshairs),NULL);
  cmap=gdk_window_get_colormap(darea->window);

  gdk_color_parse("black",&black);
  gdk_color_parse("white",&white);
  gdk_color_parse("green",&green);
  gdk_color_parse("lime green",&lime_green);
  gdk_color_parse("yellow",&yellow);
  gdk_color_parse("red",&red);

  gdk_color_alloc(cmap,&black);
  gdk_color_alloc(cmap,&white);
  gdk_color_alloc(cmap,&green);
  gdk_color_alloc(cmap,&lime_green);
  gdk_color_alloc(cmap,&yellow);
  gdk_color_alloc(cmap,&red);

  gdk_window_set_background(darea->window,&black);
  gdk_window_set_events(darea->window,
      (GdkEventMask )(events|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_POINTER_MOTION_MASK));
  gtk_widget_show_all(win);
  gtk_widget_set_usize(darea,gdk_screen_width(),gdk_screen_height());
  gtk_main();
}
