#ifndef PIC_OUT_H
#define PIC_OUT_H

struct out_funcs {
  char *prefix;
  /* intialisize the output device */
  int (*init) (char *);
  /* send all buffered data, set mclr and vcc line to
     the state requested  */
  void (*out_sync) ();
  /* turn buffering on */
  void (*out_freeze) ();
  /*  request a state of the vcc line */
  void (*power) ();
  /* request a state of the mclr line, 0=Vpp, 1=0V */ 
  void (*reset) ();
  /* read a number of bits */
  int (*in_bits) (int);
  /* requests a number of bits, which can be later read with in_bits */
  void (*in_bits_request)(int);
  /* write a number of bits out */
  void (*out_bits) (unsigned short,int);
  /* sleep usecs */
  void (*sleepu)(int);
  /* set clk state */
  void (*out_clk)(int);
  /* set data state */
  void (*out_data)(int);
  /* get data state */
  int (*in_data)(int);
};
#endif
