; Trials of Programming - Chapter 1: 
; How to make an on-off switch with an PIC12F508 
; including a status-LED and a sleep-mode  
; Rdiger Leibrandt 2006 rleibrandt@wearlab.de

	list    p=PIC12F508, r=dec
	include p12f508.inc

; Pin/Port-Usage:
; GP0 = Power-On Button / PG-DATA
; GP1 = Power-Off Button / PG-CLOCK
; GP2 = FDC6330-control: High=on, Low=off ( my expectation at least )
; GP3 = MCLR - Not utilized
; GP4 = Optional 1-wire communication with the DS2780 PIO-Pin
; GP5 = POWER-Status-LED: High=on, Low=off ( for sure! )

; Configuration ( Expected, at least ) / Power-On standard-settings
        __CONFIG 0x3ff,0xa ; 0x3ff adress of the config-word; 0xa is our config, that is: 00110
	movlw 64 ; write decimal encoded 8-bit binary in register W
	OPTION; load W register into Option-Register

; Internal Oscillator 			=	On / Internal Osc.
; SLEEP-Mode 				=	On / Enabled
; Wake-up on GP0 Status-change 		= 	On / Enabled
; Wake-up on GP1 Status-change		=	On / Enabled
; Wake-up on GP3 Status-change		=	Off / Disabled
; Pullups				=	Off / Disabled
;
;
	movlw 1|2|8|16 ; write decimal-encoded 8-bit binary in register W
	TRIS GPIO; Load register W as GPIO-direction-config 0=output, 1=input, bit0=gp0, bit1=gp1

; TRIS set-up
; GP0					=	Input
; GP1					=	Input
; GP2					=	Output
; bsf <register-gp2>; set GP2 high (Power On)
; bsf <register-gp5>; set GP5 high (Led On)
; bcf <register-gp1>; Clear GP1-Register
; goto Run ; enter regular work mode
; GP3					=	Not Used
; GP4					=	Input
; GP5					=	Output
;
; System Set-Up:
; Set the inital status of the device:
; Identify Power-On-Reset or SLEEP-Reset

	btfsc STATUS, 7; Check if we woke up from Sleep, if so, we execute the next line, else we may have to configure some things 
	goto Run; Execute normal duty-cycle

; Or, in case of Power-On-Reset:

	bsf GPIO, 2; Set GP2-Registerbit: FDC6330 on
	bsf GPIO, 5; Set GP5-Registerbit: LED on
	bcf GPIO, 0; Clear GP0-Register
	bcf GPIO, 1; Clear GP1-Register
	goto Run; Execute Run
;
Run;
	btfsc GPIO, 0; Read GP1, if set ( pressed ), execute next line, else skip it and proceed 
	goto Powerdown; if GP1 was pressed, execute Powerdown
	btfsc GPIO, 1; Read GP0, if set ( pressed ), execute next line, else skip it and restart
	goto Powerup; if GP0 was pressed, we have a Powerup being called
	movf GPIO, 0; Read register, else the bitpattern in the GPIO differs from that in the W register and we have a wake-up immideatly after issuing sleep.
	sleep; Whatever state we last entered - we keep it and go sleeping, so unless we have a "button pressed" event, nothing will change, compensating the waking up from a button-release.
	goto Run;
;
Powerup; Go online
	bsf GPIO, 2; Set GP2-Registerbit: FDC6330 on
	bsf GPIO, 5; Set GP5-Registerbit: LED on
	movf GPIO, 0; Read register, else the bitpattern in the GPIO differs from that in the W register and we have a wake-up immideatly after issuing sleep
	sleep; go sleeping, wait for next event
	goto Run;
;
Powerdown; Switching off
	bcf GPIO, 2; Clear GP2-Registerbit: FDC6330 off
	bcf GPIO, 5; Clear GP5-Registerbit: LED off
	movf GPIO, 0; Read register, else the bitpattern in the GPIO differs from that in the W register and we have a wake-up immideatly after issuing sleep
	sleep; go sleeping, wait for next event
	goto Run;
	end;
