

        list    p=PIC16F88, r=dec
        ;, r=dec ;, s=off       ;radix = decimal
					
include p16f88.inc
; Scipio software, reads the tilt sensor, three buttons and the
; rfid scanner
; can be used with gpasm

; Configuration words
; 2007: CP=1, CCPMX=0 DEBUG=1, WRT=00 CPD=0 LVP=0 BOREN=0
; MCRLE=0 PWRTEN=0 WDTEN=0 FOSC=100
; 2007=0010 1000 0001 0000
; 2008: IESO=0 FCMEM=0
; for hi speed oscilator:
; FOSC=010
; 2007:0010 1000 0000 0010
; tilt sensor at RA3 and RA4
#ifdef CRYSTAL_OSC
 __CONFIG     _CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_ALL & _CPD_ON & _LVP_OFF & _BODEN_OFF & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC
 __CONFIG     _CONFIG2, _IESO_OFF & _FCMEN_OFF
#else
 __CONFIG     _CONFIG1, _CP_OFF & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_ALL & _CPD_ON & _LVP_OFF & _BODEN_OFF & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO
 __CONFIG     _CONFIG2, _IESO_OFF & _FCMEN_OFF

#endif
#define MAJORVER 2
#define MINORVER 3


		
#ifdef UNUSED
#define SENSCLK1  PORTABUF,6
#define SENSCLK2  PORTABUF,7
#endif
; analog inputs are ra3 and ra4
ANALOGMASK  equ 1|2|4
; tilt sensor input used at the moment
ADINPUT1 equ 0
ADINPUT2 equ 1
ADINPUT3 equ 2
; aux analog input
AUXADINPUT equ 3
; PORT B inputmask
PORTBINPUT equ 1|2|4|16|32|128  ; RB0,RB1,RB4,RB5,RB7
; PORT A inputmask
PORTAINPUT equ 1|2|4|8       ; RA0-RA4
; buttons
#define BUTTON1  PORTBREADBUF,1
#define BUTTON2  PORTBREADBUF,0
#define BUTTON3  PORTBREADBUF,4
#define ROWRECEIVED  RS232AVAIL,2
#define RECEIVEINT   RS232AVAIL,3	
#define NOTFIRSTTIME    RS232AVAIL,4
#define RECEIVEPIC   RS232AVAIL,5
#define RECEIVEPICDATA RS232
#define DESTCLK  PORTB,0
#define DESTDATA PORTB,1
#define DESTPOWER PORTA,1
#define MCLRCTL  PORTB,6
#define MCLRBOOST PORTA,0
#define ONEWIRE PORTA,3
#define ONEWIRET TRISA,3
; registers
DELAY1    equ 21h
DELAY2    equ 22h
PORTABUF  equ 23h
BUTTONBUF equ 24h
PORTAREADBUF equ 25h
PORTBREADBUF equ 26h
SENSX  equ 27h
SENSY  equ 28h
SENSZ  equ 29h

RS232STATE equ 2ah
RS232AVAIL equ 2bh
RS232READTEMP equ 2ch
RS232READ equ 2dh
SENSSTATE equ 2eh
STATECOUNTER equ 2fh
	
TXSTATECOUNTER equ 32h
TXDATATMP equ 33h
GLOBSTATE equ 34h
SOUNDFREQ equ 35h
SOUNDDUR  equ 36h
SOUNDCNT  equ 37h
DELAY3    equ 38h
SOUNDBIT  equ 3

CRC16A    equ 3ah
CRC16B    equ 3bh
CRCCPY    equ 3ch
CRCCPY2   equ 3dh
RCCPY     equ 3eh
CRC16ASAVE equ 3fh
CRC16BSAVE equ 40h
TXMASK     equ 41h             
RXSTATE    equ 42h
#define PROTORX 1
#define SOUNDRX 2
#define ONOFFRX 3
#define SOUNDFREQRX 4
#define SOUNDDURRX 5
PROTOTOGGLEBIT   equ 43h
SOUNDCHANGEREG  equ 44h

; SOUNDxxxFREQ gives a divisor for the frequency
; SOUNDxxxDUR is the duration

SOUNDRFIDFREQ   equ 45h
SOUNDRFIDDUR    equ 46h
SOUNDCONNFREQ    equ 47h
SOUNDCONNDUR     equ 48h
SOUNDDISCONNFREQ equ 49h
SOUNDDISCONNDUR  equ 4ah
SOUNDBUTTONFREQ  equ 4bh
SOUNDBUTTONDUR   equ 4ch		
SOUNDATTENFREQ equ 51h
SOUNDATTENDUR equ 52h

PROGRS232      equ 70h
PROGRS232DATA  equ 71h
; auxillary analog input
AUXINREG         equ 4dh
PDBYTE           equ 4eh
IOBYTE           equ 4fh
DSCOUNT          equ 50h

#define RS232BIT PORTB,7
#define RFIDONOFF PORTA,4

; bits to configure which inputs should be set
#define SENDXBIT TXMASK,0
#define SENDYBIT TXMASK,1
#define SENDZBIT TXMASK,6
#define SENDBBIT TXMASK,2
#define SENDRFIDBIT TXMASK,3
#define SENDAUXBIT TXMASK,5       
; send type (head) byte ?
#define SENDHEADBIT TXMASK,4
#ifdef CRYSTAL_OSC
#define FOSC 14745600
#else
#define FOSC  8000000
#endif
; calculate value for the baud rate generator
#define SPBRGVAL -1+FOSC/16/
; #define SPBRGVAL(b) ((FOSC)/16/(b)-1)

; clear the bit, which enables the power supply
; of the rfid sensor (not used at the moment)
turnrfidoff macro
  bsf RFIDONOFF
  endm

	
; set the power supply bit
turnrfidon macro
  bcf RFIDONOFF
  endm

flushrs232 macro
    btfsc PIR1,RCIF
    movf RCREG,0
    endm				    
  

toggle9v macro
  movlw 1
  xorwf PORTA,1
  endm

; skip if additional rs232 (for the rfid) input is in low state
skiprs232low macro
  btfsc RS232BIT
  endm

; skip if additional rs232 (for the rfid) input is in low state
skiprs232high macro
  btfss RS232BIT
  endm

; copy a single bit from rs232 to bit zero of reg2
copyrs232bit macro reg2,bit2   ; 4 cycles
  skiprs232low
  bsf reg2,bit2
  skiprs232high
  bcf reg2,bit2
  endm

writeout macro
  movf PORTABUF,0
  movwf PORTA
  endm

comparebyte macro reg,value	; 3 cycles
  movf reg,0
  sublw value
  btfsc STATUS,Z
  endm

comparebyteneg macro reg,value	; 3 cycles
  movf reg,0
  sublw value
  btfss STATUS,Z
  endm
; w*4+4	
waitcycles macro cycles
  if (cycles > 9) 
    movlw (cycles-(4+1))/4
    call mdelay
    waitcycles cycles-4*((cycles-(4+1))/4)-5
  else
  if (cycles > 0) 
    nop
    waitcycles cycles-1
  endif
  endif
  endm

waitus macro us
  waitcycles (us*1000)/(1000000/(FOSC/4000))
  endm

; copy the bit from reg1 to bit2 in reg2 and invert it (used for buttons)
copyinvbut macro reg1,bit1,reg2,bit2 ; 4 cycles
  btfss reg1,bit1
  bsf reg2,bit2
  btfsc reg1,bit1
  bcf reg2,bit2
  endm

; one wire macros

OW_HIZ MACRO
  ;Force the DQ line into a high impedance state.
  BSF STATUS,RP0 ; Select Bank 1 of data memory
  BSF ONEWIRET   ; Make DQ pin High Z
  BCF STATUS,RP0 ; Select Bank 0 of data memory
  ENDM

OW_LO MACRO
  ;Force the DQ line to a logic low.
  BCF ONEWIRE     ; Clear the DQ bit
  BSF STATUS,RP0  ; Select Bank 1 of data memory
  BCF ONEWIRET    ; Make DQ pin an output
  BCF STATUS,RP0  ; Select Bank 0 of data memory
  ENDM
  
	movlw 70h        ; (8 Mhz clock)
	bsf STATUS,RP0
	bcf STATUS,RP1
        ; enable pullups on port b
	bcf OPTION_REG,7      ; bank 1
        ; select oscilator as internat clock source 
        bcf OPTION_REG,5
#ifdef CRYSTAL_OSC
	movwf OSCCON      ; bank 1
#endif
        bcf STATUS,RP0
	movlw 4h
	movwf PORTA
	bsf STATUS,RP0
        movlw PORTBINPUT
	movwf TRISB       ; bank 1
	movlw PORTAINPUT 
	movwf TRISA       ; bank 1
        bcf STATUS,RP0
	bcf STATUS,RP1
	movlw 4h
	movwf PORTA
	goto hwinit


; start the ad wandler
;startad  movlw 81h+8*ADINPUT ; select FOSC/8, 5 cycles
;         movwf ADCON0
;	 bsf ADCON0,2
;	 return 

get_txbyte 
	; movlw 7
	 movf TXSTATECOUNTER,0
	; andwf TXSTATECOUNTER,0
;	return
	addwf PCL,1
	DT "\rAT\r",0
;	DT "AT+BTKEY=0000\r",0
;	DT "AT+BTSEC,1,1\r",0
	DT "AT+BTNAME=\"Scipio\"\r",0
	DT "AT+BTMODE,3\r",0
	DT "AT+BTSCAN,3,0\r",0
	DT "AT+UARTCONFIG,38400,n,1\r",0
	DT "ATZ\r",0
	DT "ATZ\r",0,0
	
get_waitbyte movf RS232STATE,0
	addwf PCL,1
	retlw 'O'
	retlw 'K'
	retlw '\r'
	retlw 0

	;; 86 cycles from here
rxtxloop 
         movlw 3 
         movwf STATECOUNTER
         movlw 7   
         andwf GLOBSTATE,0
	 incf GLOBSTATE,1
	 addwf PCL,1
	 ; according to GLOBSTATE, one of the following is called
	 goto handletx ; check for rfid data, send type byte
	               ; if no rfid data is available, a
		       ; type byte for the sensor data is send
	 goto handsens ; handle clock lines for the tilt sensor
	 goto dotx     ; send a data byte (if available)
	 goto checkrow  ; check for received data from the usart
	 goto checktx  ; check for rfid data
	 goto handsens ; handle clock lines for the tilt sensor
	 goto dotx     ; send a data byte (if available)
	 goto checkrow  ; check for received data from the usart


txstatesys movf TXSTATECOUNTER,0  ; 4+12=16 cycles
           addwf PCL,1
	   goto sendx
	   goto sendy
	   goto sendz
	   goto sendbutton
	   goto sendauxin


; produces 3 bytes 100 times per second
; -> 300 bytes per second
; -> 2400 bits per second
; transition system for the tilt sensor
handlesens  
            movf SENSSTATE,0      ; 13 cycles
            addwf PCL,1
	    goto adsens1    ; read first axis, set ad for second 
	                    ; store result from fourth quadrant
	    goto sensmiddle ; start ad converter
	    goto adsens2    ; read second axis, set ad for third
	    goto sensmiddle ; start ad converter
	    goto adsens3    ; read third axis, set ad for aux input
	    goto sensmiddle ; start ad converter
	    goto adauxin    ; read aux input and set ad for first
	    goto sensmiddle ; start ad converter



; check for bank overruns here!
; readrs232 checks for input on the rs232 line
; 4 (movf, addwf,goto)+6 (called state handler) +2 (return)=12 cycles
; it is a little state transition system
; If one byte is read, bit 0 of RS232AVAIL is set
; The byte can then be read from RS232READ
readrs232  movf RS232STATE,0
           addwf  PCL,1
	   goto waitstartbit
	   goto ignorebit
	 ;  goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getbit
	   goto ignorebit
	   goto getstopbit

crc16nibbletableh  addwf PCL,1  ; 3 cycles
           DT     00h,10h,21h,31h,42h,52h,63h,73h,84h,94h,0a5h,0b5h,0c6h,0d6h,0e7h,0f7h
crc16nibbletablel  addwf PCL,1
           DT     00h,81h,02h,83h,04h,85h,06h,87h,08h,89h,0ah,8bh,0ch,8dh,0eh,8fh 
	;; 63 cycles
rowstatesys  movf RXSTATE,0
	     addwf  PCL,1
	;; 61 cycles
	     goto baserx
	     goto receivedproto
	     goto receivedsound
	     goto checkonoff
             goto soundfreqreceived
	     goto sounddurreceived

hwinit	call reinit_promi
; enable serial port
	movlw 90h ; enable serial port and continuus receive
	bcf STATUS,RP0
	bcf STATUS,RP1
	movwf RCSTA       ; bank 0
	; bit 2 and 5 in trisb
	movlw 24h ; enable, high speed
	bsf STATUS,RP0
	movwf TXSTA       ; bank 1
	movlw SPBRGVAL 38400          ; 38400 baud rate (8Mhz clock)
	movwf SPBRG       ; bank 1
; enable A/D
        movlw ANALOGMASK
	movwf ANSEL  ; bank 1
        movlw 0
        movwf ADCON1 ; bank 1
	bcf STATUS,RP0
; clear some registers  

        clrf RS232STATE
	clrf RS232AVAIL
	clrf RS232READTEMP
        clrf PORTABUF
	writeout
	clrf BUTTONBUF
	movlw 1h
	movwf STATECOUNTER
	clrf TXSTATECOUNTER
	clrf SENSSTATE
	clrf GLOBSTATE
        clrf CRC16A
	clrf CRC16B
	;; sound config
	movlw 127
	movwf SOUNDRFIDDUR
	movwf SOUNDCONNDUR
	movwf SOUNDDISCONNDUR
	movwf SOUNDBUTTONDUR
	movwf SOUNDATTENDUR
	movlw 20
	movwf SOUNDCONNFREQ
	movlw 15 
	movwf SOUNDATTENFREQ
	movlw 3
	movwf SOUNDDISCONNFREQ
	movlw 6
	movwf SOUNDRFIDFREQ
	movlw 3
	movwf SOUNDBUTTONFREQ
        movlw 0
	movwf TXMASK
	movlw 9h
	clrf RXSTATE
	movwf SOUNDFREQ
	movwf SOUNDCNT
	movlw 127
	movwf SOUNDDUR
	bsf STATUS,RP0
	bsf PIE1,RCIE	; bank 1
	bcf STATUS,RP0
	bcf RCSTA,4
	bsf RCSTA,4	
	; go to the global transition system
        ;call init_bttxloop
#ifdef CRYSTAL_OSC
        movlw 80h
        movwf TMR0
#endif
        goto globalloop

reinit_promi  

	movlw 90h ; enable serial port and continuus receive
	movwf RCSTA       ; bank 0
	; bit 2 and 5 in trisb
	movlw 24h ; enable, high speed
	bsf STATUS,RP0
	movwf TXSTA       ; bank 1
	movlw SPBRGVAL 9600
	movwf SPBRG       ; bank 1
;	bsf PIE1,RCIE		
	bcf STATUS,RP0   
	bcf RCSTA,4
	bsf RCSTA,4	
        clrf TXSTATECOUNTER
        movlw 'A'
       ; movwf TXREG
	call waitok





init_bttxloop    

        call get_txbyte

        incf TXSTATECOUNTER,1
	addlw 0
	btfsc STATUS,Z
	goto atcmd_full
	movwf TXREG
	
        call get_txbyte
	addlw 0
	btfsc STATUS,Z
	bsf RCSTA,4
txfinishwait     btfss PIR1,TXIF
        goto txfinishwait
	goto init_bttxloop
atcmd_full   
	call get_txbyte
	addlw 0
	btfsc STATUS,Z
	return
	bsf RCSTA,4
	call waitok
	btfss RS232AVAIL,0
	return

	goto init_bttxloop



		
waitok  clrf RS232AVAIL
	clrf RS232STATE
	clrf DELAY1
	clrf DELAY2
	movlw 10
	movwf DELAY3
	; comf DELAY3,1
       
loop3   movlw 255
	movwf DELAY1
loop1   movlw 255
	movwf DELAY2
loop2   btfss PIR1,RCIF
	goto norx
	movf RCREG,0
	movwf RS232READTEMP
	; movlw 'O'

	call get_waitbyte
	subwf RS232READTEMP,0
	btfss STATUS,Z
	goto not_same
	;bsf RS232AVAIL,0
	;return
	incf RS232STATE,1
	call get_waitbyte
	addlw 0
	btfss STATUS,Z
	goto norx
	bsf RS232AVAIL,0
        return
not_same  clrf RS232STATE
       
norx	decfsz DELAY2,1            ; ((6*DELAY2+5)*DELAY1+5)*DELAY3
	goto loop2


	decfsz DELAY1,1
	goto loop1

	decfsz DELAY3,1
	goto loop3
        return




    ; mainloop
globalloop      ; has to be reachesd 19200 times per second
;      has to use 104 cycles
     ; can write every 5th turn to the usart
     ; read the additional rs232 port
#ifdef CRYSTAL_OSC
tmrwait btfss INTCON,TMR0IF
        goto tmrwait
        bcf INTCON,TMR0IF
        ; calculate timer runtime
        movlw 256-(FOSC/4/19200-5)
        movwf TMR0

#endif
     call readrs232 ; 14 cycles
	 ; 90 cycles from here
     decf STATECOUNTER,1
     btfsc STATUS,Z
     goto rxtxloop ; call it every 6400 times per second, every 3th run
     ; wait 104-14-3=87 cycles
     btfss STATECOUNTER,1
     goto soundtrans
       ; wait 85 cycles
     goto rxcheck 
       

      movlw 255
     ;movlw 0
globalloopdelay
     nop
     nop
     addlw 27                ; 28*3+3=87 cycles
     movwf DELAY1
globalloopdelayloop
     decfsz DELAY1,1
     goto globalloopdelayloop 
     goto globalloop          ; 2 cycles

     ; goto globalloopdelay will take W*3+5 cycles
     ; including movlw: W*3+6
     ; here is the transition system which handles
     ; the transmitting to the usart
     ; 104-13-4=86 cycles from here, called 6400 times per second
     ; 

; 86-8=78 cycles from here

handletx  
	  movlw 0
          btfsc SENDRFIDBIT
          addlw 1
          btfsc RS232AVAIL,0  ; check for rfid input
          addlw 2
          xorlw 3
          btfsc STATUS,Z
          goto txavail           
          bsf RS232AVAIL,1
          call txstatesys     ; send some sensor/button information
	  ; 78-16-9=53 cycles
	  nop
	  movlw 256-(28-(51-6)/3)
          goto globalloopdelay

handsens  call handlesens 
          ; 78-13-2=63 cycles from here
	  movlw 100h-(28-(63-6)/3)
          goto globalloopdelay

dotx      movf TXDATATMP,0
          btfsc RS232AVAIL,1
          movwf TXREG
	  bcf RS232AVAIL,1
	  ; 78-4=74 cycles from here
	  nop
	  nop
	  movlw  250      ;0x100-(28-(75-6)/3)
	  goto globalloopdelay
	;; 78 cycles from here
checkrow  btfsc ROWRECEIVED
          goto rowreceived 
       
          nop
          nop
          nop
          nop
	
          movlw 256-(28-(72-6)/3)
          goto globalloopdelay 

protocolreceived
	      movlw PROTORX
	      movwf RXSTATE
	
	         return
versmajorreceived
	      movlw MAJORVER
	      movwf TXREG
	      return
versminorreceived
	      movlw MINORVER
	      movwf TXREG
	      return
soundreceived    movlw SOUNDRX
	         movwf RXSTATE
	         return

invalidreceived2 nop
invalidreceived  nop
	         nop
	         return
sendxreceived    movlw 1
	         movwf PROTOTOGGLEBIT
	         return
sendyreceived    movlw 2
	         movwf PROTOTOGGLEBIT
	         return
sendzreceived    movlw 64
	         movwf PROTOTOGGLEBIT
	         return
sendbreceived    movlw 4
	         movwf PROTOTOGGLEBIT
	         return
sendrfidreceived movlw 8
	         movwf PROTOTOGGLEBIT
	         return
sendtypereceived movlw 16
	         movwf PROTOTOGGLEBIT
	         return
sendauxinreceived movlw 32
                 movwf PROTOTOGGLEBIT
		 return
	;; 75 cycles from here
rowreceived
          bcf ROWRECEIVED
	  nop
          comparebyte CRC16BSAVE,03bh 
          goto connectreceived
          comparebyte CRC16BSAVE,0d1h
          goto disconnectreceived
	;; 65 cycles
          goto rowstatesys

	;; 59 cycles

attenreceived movf SOUNDATTENFREQ,0
              movwf SOUNDFREQ
              movf SOUNDATTENDUR,0
              movwf SOUNDDUR
	      return

baserx     clrf RXSTATE
	  comparebyte CRC16BSAVE,04dh ; PROTOCOL
	  call protocolreceived
	  comparebyte CRC16BSAVE,0e8h ; SOUND
	  call soundreceived
	  comparebyte CRC16BSAVE,03fh ; VERSIONMAJOR
	  call versmajorreceived
	  comparebyte CRC16BSAVE,086h ; VERSIONMINOR
	  call versminorreceived
	  comparebyte CRC16BSAVE,0edh ; PROGEXT
	  goto progmode
	  comparebyte CRC16BSAVE,024h ; 1WIRE
	  goto onewiremode
	  comparebyte CRC16BSAVE,0fah ; ATTENTION
	  call attenreceived
	  movf RXSTATE,1
	  btfsc STATUS,Z
	  call invalidreceived
	;; 35 cycles -5 cycles
          nop
	  nop
	  movlw 256-(28-(27-6)/3)
	  goto globalloopdelay 

sendoff     comf PROTOTOGGLEBIT,0
	    andwf TXMASK,1
            clrf PROTOTOGGLEBIT
	    return

sendon      movf PROTOTOGGLEBIT,0
	    iorwf TXMASK,1
	    clrf PROTOTOGGLEBIT
	    return
	;; 59 cycles from here
checkonoff  
	    comparebyte CRC16BSAVE,035h
	    call sendoff
	    comparebyte CRC16BSAVE,0d4h
	    call sendon
	    clrf RXSTATE
	    movf PROTOTOGGLEBIT,1
	    btfsc STATUS,Z
	    call invalidreceived2
            btfsc SENDRFIDBIT
            turnrfidon
            btfss SENDRFIDBIT
            turnrfidoff
	;; 47 cycles -6 cycles
            nop
            nop
	  
	    movlw 256-(28-(39-6)/3)
	    goto globalloopdelay
	    
       ;; 59 cycles from here
receivedproto
	  clrf PROTOTOGGLEBIT
          comparebyte CRC16BSAVE,0e8h ; SENDX
          call sendxreceived
          comparebyte CRC16BSAVE,061h ; SENDY
          call sendyreceived
          comparebyte CRC16BSAVE,0fah ; SENDZ
          call sendzreceived
	  comparebyte CRC16BSAVE,033h ; SENDB
	  call sendbreceived
          comparebyte CRC16BSAVE,02ch ; SENDRFID
          call sendrfidreceived
          comparebyte CRC16BSAVE,0e4h ; SENDTYPE
	  call sendtypereceived
	  comparebyte CRC16BSAVE,038h ; SENDAUXIN
	  call sendauxinreceived
	;; 30 cycles
	  movlw ONOFFRX
	  movwf RXSTATE
	  movf PROTOTOGGLEBIT,1
	  btfsc STATUS,Z
	  call invalidreceived
	  movf PROTOTOGGLEBIT,1
	  btfsc STATUS,Z
	  clrf RXSTATE
	;; 22 cycles - 5 cycles 
       	bsf NOTFIRSTTIME
         nop
	 nop
          movlw 256-(28-(14-6)/3)
          goto globalloopdelay

rfidsoundreceived movlw SOUNDRFIDFREQ
	          movwf SOUNDCHANGEREG
	          return
connsoundreceived movlw SOUNDCONNFREQ
	          movwf SOUNDCHANGEREG
	          return
attensoundreceived movlw SOUNDATTENFREQ
                   movwf SOUNDCHANGEREG
		   return
disconnsoundreceived  movlw SOUNDDISCONNFREQ
	              movwf SOUNDCHANGEREG
	              return
buttonsoundreceived   movlw SOUNDBUTTONFREQ
	              movwf SOUNDCHANGEREG
	              return
	;; 59 cycles
receivedsound
	  clrf SOUNDCHANGEREG
	  comparebyte CRC16BSAVE,091h ; RFID
	  call rfidsoundreceived
	  comparebyte CRC16BSAVE,0c7h ; CONN
	  call connsoundreceived
	  comparebyte CRC16BSAVE,0bbh ; DISCONN
	  call disconnsoundreceived
	  comparebyte CRC16BSAVE,01dh ; BUTTON
	  call buttonsoundreceived
	  comparebyte CRC16BSAVE,0fah ; ATTENTION
	  call attensoundreceived
	;; 42 cycles
	  movlw SOUNDFREQRX
	  movwf RXSTATE
	  movf SOUNDCHANGEREG,1
	  btfsc STATUS,Z
	  call invalidreceived
	  btfsc STATUS,Z
	  clrf RXSTATE
	  btfss STATUS,Z
	  bsf  RECEIVEINT
	;; 33 cycles - 5 cycles
	  nop
	  movlw 256-(28-(27-6)/3)
	  goto globalloopdelay

	;; 59 cycles from here
soundfreqreceived  movf SOUNDCHANGEREG,0
	           movwf FSR
	           movf CRC16ASAVE,0
	           movwf INDF
	           incf SOUNDCHANGEREG,1
	           movlw SOUNDDURRX
	           movwf RXSTATE
	;; 52 cycles from here
	           movlw 256-(28-(36-6)/3)
	           goto globalloopdelay

	;; 59 cycles from here
sounddurreceived   movf SOUNDCHANGEREG,0
	           movwf FSR
	           movf CRC16ASAVE,0
	           movwf INDF
	           bcf RECEIVEINT
	           clrf RXSTATE
	;; 53 cycles
	           nop
	           nop
	           movlw 256-(28-(51-6)/3)
	           goto globalloopdelay
	
      ;; 69 cycles form here
connectreceived movf SOUNDCONNFREQ,0
                movwf SOUNDFREQ
                movf SOUNDCONNDUR,0
                movwf SOUNDDUR
                movf TXMASK,0
		btfss NOTFIRSTTIME
		movlw 01fh
		movwf TXMASK
		bsf NOTFIRSTTIME
        
                movlw 256-(28-(60-6)/3)
                goto globalloopdelay

        ;; 65 cycles from here
disconnectreceived 
	       movf SOUNDDISCONNFREQ,0
               movwf SOUNDFREQ
               movf SOUNDDISCONNDUR,0
               movwf SOUNDDUR
		
               
	       nop
               
               movlw 256-(28-(60-6)/3)
               goto globalloopdelay   
	
	
	
	
	
	
	
	


checktx   movlw 0
         btfsc SENDRFIDBIT
         addlw 1
         btfsc RS232AVAIL,0  ; check for rfid input
         addlw 2
         xorlw 3
         btfsc STATUS,Z
         goto txavail  
         ; 78-8=70 cycles from here
         nop

         movlw 256-(28-(69-6)/3)
         goto globalloopdelay


; 78-9=69 cycles from here
txavail   movlw 46h     
          btfsc SENDHEADBIT
	  movwf TXREG
	  movf RS232READ,0
	  movwf TXDATATMP
	  bcf RS232AVAIL,0
; 79-6=63 cycles from here
	  bsf RS232AVAIL,1
	  movf SOUNDRFIDDUR,0
	  movwf SOUNDDUR
	  movf SOUNDRFIDFREQ,0
	  movwf SOUNDFREQ
	  nop
	  
	  movlw 256-(28-(57-6)/3)
	  goto globalloopdelay



 ;; send x axis information (12 cycles)

sendx      incf TXSTATECOUNTER,1
           btfss SENDXBIT
           goto notsend
           movlw 41h
	   ;nop
	   ;nop
           btfss BUTTONBUF,4
	   addlw 1
           btfsc SENDHEADBIT	
	   movwf TXREG
           movf SENSX,0
	   movwf TXDATATMP
	   return

        ;; send y axis information (12 cycles)
sendy      incf TXSTATECOUNTER,1
           btfss SENDYBIT
           goto notsend
           movlw 43h             
	   ;nop
	   ;nop
           btfss BUTTONBUF,5
           addlw 1
           btfsc SENDHEADBIT
           movwf TXREG
           movf SENSY,0
           movwf TXDATATMP
           return
	
        ;; send button state (12 cycles)
sendbutton incf TXSTATECOUNTER,1
           btfss SENDBBIT
           goto notsend
           movlw 45h              ; 9 cycles
           nop
           btfsc SENDHEADBIT
           movwf TXREG
           btfsc PORTB,4
           bcf BUTTONBUF,0
           btfss PORTB,4
           bsf BUTTONBUF,0
           btfsc PORTB,0
           bcf BUTTONBUF,1
           btfss PORTB,0
           bsf BUTTONBUF,1
           btfss PORTB,1
           bsf BUTTONBUF,2
           btfsc PORTB,1
           bcf BUTTONBUF,2 
           movf BUTTONBUF,0
           andlw 7
           movwf TXDATATMP
           return
sendz      incf TXSTATECOUNTER,1
           btfss SENDZBIT
	   goto notsend
	   movlw 48h
           btfss BUTTONBUF,6
           addlw 1
	   btfsc SENDHEADBIT
	   movwf TXREG
	   movf SENSZ,0
	   movwf TXDATATMP
	   return


      ;; send auxillary analog input (12 cycles)
sendauxin  clrf TXSTATECOUNTER
           btfss SENDAUXBIT 
	   goto notsend
	   movlw 47h
	   nop
	   btfsc SENDHEADBIT
	   movwf TXREG
	   movf AUXINREG,0
	   nop
	   movwf TXDATATMP
	   return

notsend    nop
           nop
           nop
           nop
           nop
           bcf RS232AVAIL,1
           return
	   
s

; waitstartbit, ignorebit, getbit and getstopbit must
; have the same number of cpu cycles ( 6 cycles without return )
waitstartbit   skiprs232high            
               incf RS232STATE,1
	       ; DEBUG
	       ; movlw 4
	       ; xorwf PORTABUF,1
	       ;writeout
	       
	       nop
	       nop
	       nop
	       nop
               return

ignorebit      incf RS232STATE,1    
	       ; DEBUG 
	       ;movlw 2
	       ;xorwf PORTABUF,1
	       ;writeout
               nop
	       nop
	       nop
	       nop
	       nop
	       return
getbit   rrf RS232READTEMP,1            
         copyrs232bit RS232READTEMP,7
	 incf RS232STATE,1
         return
getstopbit skiprs232high
           goto getstopbit2
           movf RS232READTEMP,0         
           movwf RS232READ
	   bsf RS232AVAIL,0
	   clrf RS232STATE
	   return

getstopbit2 nop
            nop
	    nop
	    return
            
; each of this states takes 7 cycles (without return)
adsens1     movf ADRESH,0
            bcf BUTTONBUF,4
	    movwf SENSX
	    addwf SENSX,1
	    btfss STATUS,C
	    bsf BUTTONBUF,4
	    bsf STATUS,RP0
	    movf ADRESL,0    ; Bank 1
	    bcf STATUS,RP0
	    andlw 128 
	    btfss STATUS,Z
	    incf SENSX,1
	    movlw 81h+8*ADINPUT2
	    movwf ADCON0
	    incf SENSSTATE,1
	    return
	
adsens2     movf ADRESH,0
            bcf BUTTONBUF,5
	    movwf SENSY
	    addwf SENSY,1
	    btfss STATUS,C
	    bsf BUTTONBUF,5
	    bsf STATUS,RP0
	    movf ADRESL,0    ; Bank 1
	    bcf STATUS,RP0
	    andlw 128 
	    btfss STATUS,Z
	    incf SENSY,1
	    movlw 81h+8*ADINPUT3
	    movwf ADCON0
	    incf SENSSTATE,1
	    return

adsens3     movf ADRESH,0
	    bcf BUTTONBUF,6
	    movwf SENSZ
	    addwf SENSZ,1
	    btfss STATUS,C
	    bsf BUTTONBUF,6
	    bsf STATUS,RP0
	    movf ADRESL,0    ; Bank 1
	    bcf STATUS,RP0
	    andlw 128 
	    btfss STATUS,Z
	    incf SENSZ,1

	    movlw 81h+8*AUXADINPUT
	    movwf ADCON0
	    nop
	    nop
	    incf SENSSTATE,1
	    return

adauxin     movf ADRESH,0
	    movwf AUXINREG
	    movlw 81h+8*ADINPUT1
	    movwf ADCON0
	    nop
	    nop
	    incf SENSSTATE,1
	    return
	    
sensmiddle  bsf ADCON0,2 
	    nop
	    nop
	    nop
	    nop

            incf SENSSTATE,1	    
	    bcf SENSSTATE,3
	    return
            ;goto startad ; 2+5 cycles 



       ;; 83 cycles from here
rxcheck    btfsc PIR1,RCIF
          goto rxavail
         btfss RCSTA,1
          goto nooverflow        
         bcf RCSTA,4
         bsf RCSTA,4
        ; 83-6=77 cycles from here
         nop
         nop
         movlw 256-(28-(75-6)/3)
         goto globalloopdelay

        ;  81 cycles from here
rxavail   movf RCREG,0
          movwf RCCPY
         addlw 256-' '
         btfsc STATUS,Z
         goto endrecv1
         addlw 256+' '-10
         btfsc STATUS,Z
         goto endrecv2
         addlw 256+10-13
         btfsc STATUS,Z
         goto endrecv3
         movf RCCPY,0
         btfsc RECEIVEINT
	 goto receiveint
         call crc16byte        ;  63+2 cycles
         ;; 81-11-63-2=5 cycles
        
      
         nop
         goto globalloop
         
         
         movlw 256-(28-(3-6)/3)      ; =256-29=227
         
         goto globalloopdelay
       
       ;; 78 cycles from here
nooverflow 
          
          movlw 256-(28-(78-6)/3)
         goto globalloopdelay 
       
            ; 85 cycles from here

       ;; 75 cycles from here
endrecv1   nop
          nop
endrecv2   nop
           nop
endrecv3   movf CRC16A,0
          movwf CRC16ASAVE
          movf CRC16B,0
          movwf CRC16BSAVE
          bsf ROWRECEIVED
          clrf CRC16A
          clrf CRC16B
       ;; 63 cycles from here
           movlw 256-(28-(63-6)/4)
          goto globalloopdelay

	;; 66 cycles from here
receiveint  movf CRC16A,0
	    addwf CRC16A,1
	    movf CRC16A,0
	    addwf CRC16A,1
	    addwf CRC16A,1
	    addwf CRC16A,1
	    addwf CRC16A,1
	    movf RCCPY,0
	    addlw 256-'0'
	    addwf CRC16A,1 
	;; 56 cycles from here
	    nop
	    nop
	    movlw 256-(28-(54-6)/3)
	    goto globalloopdelay
	
            ; 85 cycles from here
soundtrans  call soundrt            
	    nop
	    ; 72 cycles from here
            movlw  256-(28-(72-6)/3)                  ; 14+1 cycles
            goto globalloopdelay
	   
soundrt     btfss SOUNDDUR,7           ; 12 cycles
            goto sound
	    
	    movf BUTTONBUF,0	; make noise when button pressed
	    andlw 7
	    btfsc STATUS,Z
	    goto nosound
	    movf SOUNDBUTTONFREQ,0
	    movwf SOUNDFREQ
	    movf SOUNDBUTTONDUR,0
	    movwf SOUNDDUR
            return	    

nosound     bsf PORTB,SOUNDBIT
	    nop
	    nop
	    return
	
sound       decfsz SOUNDCNT,1           
            goto soundnotoggle
            movlw (1<<SOUNDBIT)
	    xorwf PORTB,1
	    movf SOUNDFREQ,0
	    movwf SOUNDCNT
	    decf SOUNDDUR,1
            return                   ; 9 cycles
soundnotoggle  nop                    ; 6 cycles
               nop
	       nop
	       nop

             return

crc16nibble       xorwf CRC16B,0 ; 28 cycles
                  andlw 0fh
                  movwf CRCCPY2 ; 26 cycles
                  swapf CRC16B,1
                  movlw 0fh
                  andwf CRC16B,1
                  swapf CRC16A,1
                  movf CRC16A,0
                  andlw 0f0h
                  iorwf CRC16B,1
                  movlw 0fh
                  andwf CRC16A,1
                  movf CRCCPY2,0
                  call crc16nibbletableh ; 3+2=5 cycles
                  xorwf CRC16A,1
                  movf CRCCPY2,0
                  call crc16nibbletablel ; 3+2=5 cycles
                  xorwf CRC16B,1
                  return

crc16byte      
                movwf CRCCPY       ; 3+29+2+29=63 cycles
                swapf CRCCPY,1
                andlw 0fh
                call crc16nibble   ; 29 cycles
                movf CRCCPY,0
                andlw 0fh
                goto crc16nibble   ; 29 cycles
         
progmode        bsf STATUS,RP0
                bcf TRISA,0     ; bank 1
	        bcf TRISA,1
	        bcf TRISB,0
	        bcf TRISB,1
	        bcf TRISB,6
	        clrf ANSEL
		bcf STATUS,RP0
progmodeloop    btfsc PIR1,RCIF
                goto progrxavail1
                toggle9v
		goto progmodeloop
progrxavail1    movf RCREG,0
                movwf PROGRS232
		btfss PROGRS232,7
		goto progmodeloop
		btfsc PROGRS232,6
		bsf MCLRCTL
		btfss PROGRS232,6
		bcf MCLRCTL
		bsf STATUS,RP0
                btfsc PROGRS232,5
		bsf TRISB,1            ; bank 1
		btfss PROGRS232,5
		bcf TRISB,1            ; bank 1
		bcf STATUS,RP0
		btfsc PROGRS232,5
		goto progreadbyte
		btfsc PROGRS232,4
		goto progwritebyte
progsbyte
		btfsc PROGRS232,0
		bsf DESTDATA
		btfss PROGRS232,0
		bcf DESTDATA
		btfsc PROGRS232,1
		bsf DESTCLK
		btfss PROGRS232,1
		bcf DESTCLK
	        btfsc PROGRS232,2
	        bcf DESTPOWER
	        btfss PROGRS232,2
	        bsf DESTPOWER
		
		movlw 0
		btfss PROGRS232,5
		goto progmodeloop
		btfsc DESTDATA
		addlw 1
		movwf TXREG
		goto progmodeloop
progwritebyte   
progwritewait   btfsc PIR1,RCIF
                goto progwriteavail
		toggle9v
		goto progwritewait
progwriteavail  movf RCREG,0
		movwf PROGRS232DATA
                movlw 15 
                andwf PROGRS232,1
		btfsc STATUS,Z
		goto progmodeloop
progwriteloop   btfsc PROGRS232DATA,0
                bsf DESTDATA
		btfss PROGRS232DATA,0
		bcf DESTDATA
		bsf DESTCLK
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		bcf DESTCLK
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		bcf DESTDATA
		rrf PROGRS232DATA,1
		toggle9v
		decfsz PROGRS232,1
		goto progwriteloop
		goto progmodeloop

progreadbyte    btfss PROGRS232,4
                goto progsbyte
                movlw 15
                andwf PROGRS232,1
		btfsc STATUS,Z
		goto progmodeloop
		movf PROGRS232,0
		addlw (256-14)
		btfsc STATUS,Z
		goto 0
		clrf PROGRS232DATA
		clrf RS232READTEMP
		incf RS232READTEMP,1
		movlw 1
progreadloop    bsf DESTCLK
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		bcf DESTCLK
		movf PORTB,0
		movwf PORTBREADBUF
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		nop
		movf RS232READTEMP,0
		btfsc PORTBREADBUF,1
		iorwf PROGRS232DATA,1
		addwf RS232READTEMP,1
		toggle9v
		decfsz PROGRS232,1
		goto progreadloop
		movf PROGRS232DATA,0
		movwf TXREG
		goto progmodeloop
mdelay          movwf DELAY3       ;  DELAY3*4+2 , mit call: w*4+4
mdelayloop      nop                ; 3 + (DELAY3-1)*4+2=DELAY3*4+1
                decfsz DELAY3,1
                goto mdelayloop
                return
testcode        waitcycles 26
                waitcycles 27
                waitcycles 6
                waitcycles 25
ow_reset        OW_HIZ
                clrf PDBYTE
		OW_LO
		waitus 200
		flushrs232
		waitus 200
		flushrs232
		waitus 100
		flushrs232
		OW_HIZ
		waitus 70
		flushrs232
		btfss ONEWIRE
		incf PDBYTE,1
		waitus 200
		flushrs232
		waitus 230
		flushrs232
		retlw 0
dstxbyte        
                movwf IOBYTE
		movlw 8
		movwf DSCOUNT
dstxlp          OW_LO
                waitus 3
		RRF IOBYTE,F
		bsf STATUS,RP0
		btfsc STATUS,C
		bsf ONEWIRET
		bcf STATUS,RP0
		waitus 60
		flushrs232
		OW_HIZ
		waitus 2
		decfsz DSCOUNT,1
		goto dstxlp
		retlw 0
dsrxbyte        movlw 8
                movwf DSCOUNT
dsrxlp          OW_LO
                waitus 6
		OW_HIZ
		waitus 4
		movlw 0
		btfsc ONEWIRE
		addlw 1
		addlw 255
		rrf IOBYTE,1
		waitus 50
		flushrs232
		decfsz DSCOUNT,1
		goto dsrxlp
                retlw 0

onewirecheckconnect
                addlw 256-'C'
		btfsc STATUS,Z
		goto globalloop
onewiremode   
#if 0
                 OW_LO 
testloop
                ;goto globalloopdelay 
		waitus 168
		movlw (1<<3)
		xorwf PORTA,1
		goto testloop
#endif
                btfss PIR1,RCIF
                goto onewiremode
                movf RCREG,0
		movwf PROGRS232
                btfss PROGRS232,7
		goto onewirecheckconnect
		btfsc PROGRS232,5
		goto onewirereset
	        btfsc PROGRS232,4
		goto globalloopdelay
		btfsc PROGRS232,6
		goto onewireread
		btfss PROGRS232,6
		goto onewirewrite
		goto onewiremode
onewirereset    call ow_reset
                movf PDBYTE,0
		movwf TXREG
	        goto onewiremode	
onewireread     call dsrxbyte
	        movf IOBYTE,0
		movwf TXREG
		goto onewiremode
onewirewrite    btfss PIR1,RCIF
                goto onewirewrite
		movf RCREG,0
		call dstxbyte
		goto onewiremode
		
	 end 
