/********************************************************************** 
 *  picprog - Copyright (C) 2003-2006 - Andreas Kemnade
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *                  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 ************************************************************************/
#include <sys/io.h>
#include <sys/types.h>
#include <time.h>
#include <sys/time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "out.h"

#define INBUFSIZE 131072

#define PIC_IN 0
#define PIC_OUT 0
#define PIC_CLK 1
#define PIC_RST 2
#define PIC_POWER 3

#define TSET 1
#define THLD 1
#define TDLY 2
static unsigned short ioport=0x3bc;
unsigned char port_state=0;
static unsigned char *in_buf;
static int inbuf_readpos;
static int inbuf_writepos;
static int do_inv = 0;
static int inpic_is_tested;

#ifndef ALLOW_PARPORT
#define ALLOW_PARPORT 0x3bc
#endif

#define SET_BIT(bit,state) port_state=(state)?(port_state|(1<<(bit))):(port_state&~(1<<(bit)))


static void my_usleep(int us)
{
  struct timeval tv;
  struct timeval tv2;
  int udiff;
  us*=2;
  gettimeofday(&tv,NULL);
  gettimeofday(&tv,NULL);
  gettimeofday(&tv,NULL);
  do {
    gettimeofday(&tv2,NULL);
    udiff=tv2.tv_usec-tv.tv_usec;
    if (udiff<0)
      udiff+=1000000;
  } while(udiff<us);
}


static void out_sync()
{
  outb(port_state,ioport);
}

static void out_freeze()
{
}

static void clk_pic(int state)
{
  SET_BIT(PIC_CLK,state);
}

static void out_pic(int state)
{
  SET_BIT(PIC_OUT,state);
}

static void power_pic(int state)
{
  SET_BIT(PIC_POWER,state);
}

static void mclr_pic(int state)
{
  SET_BIT(PIC_RST,state);
}

static int  in_pic()  /* read paper out */
{
  if (do_inv)
    return 0!=(64&inb(ioport+1));
  else
    return 0==(64&inb(ioport+1));
}

static int pic_setup(char *arg)
{
  ioport=strtol(arg,NULL,0);
  if (ioport<0x100) {
    fprintf(stderr,"strange ioport\n");
    return 0;
  }
  if (getuid()&&(ioport!=0x3bc)) {
    fprintf(stderr,"ioport %x not allowed for suid usage\n",ioport);
    return 0;
  }
  if (ioperm(ioport,4,1)) {
    fprintf(stderr,"cannot get permissions on io space\n");
    return 0;
  }
  
  clk_pic(0);
  out_pic(0);
  in_buf=malloc(INBUFSIZE);

  return 1;
}

/* write bit */
static void clock_out(int bit) 
{
  out_pic(bit);
  clk_pic(1);
  out_sync();
  my_usleep(TSET);
  clk_pic(0);
  out_sync();
  my_usleep(THLD);
  out_pic(0);
  out_sync();
  if (!inpic_is_tested) {
    if (in_pic()) {
      do_inv=!do_inv;
    }
    inpic_is_tested=1;
  }
}

/* read bit */
static int clock_in() 
{
  int ret;
  out_pic(1);
  clk_pic(1);
  out_sync();
  my_usleep(TSET);
  clk_pic(0);
  out_sync();
  ret=in_pic();
  //printf("read: %d\n",ret);
  my_usleep(THLD);
  return ret;
}

static void out_bits(unsigned short word, int count)
{
  int i;
  for(i=0;i<count;i++) {
    clock_out(word & ( 1<<i));
  }
}

static int copy_bits(int count)
{
  int bytes=count/8;
  int ret;
  if ((inbuf_writepos-inbuf_readpos)<bytes) {
    return -1;
  }
  ret=in_buf[inbuf_readpos]&255;;
  inbuf_readpos++;
  if (bytes>1) {
    ret|=(in_buf[inbuf_readpos]*256);
    inbuf_readpos++;
  }
  return ret;
}

static void in_bits(int count)
{
  unsigned short ret;
  int i;
  ret=0;
  for(i=0;i<count;i++) {
    if (clock_in())
      ret|=(1<<i);
  }
  in_buf[inbuf_writepos]=ret&255;
  inbuf_writepos++;
  if (count>8) {
    in_buf[inbuf_writepos]=ret/256;
    inbuf_writepos++;
  }
  if ((inbuf_readpos>INBUFSIZE/2)&&(inbuf_writepos>INBUFSIZE/2)) {
    memmove(in_buf,in_buf+INBUFSIZE/2,INBUFSIZE/2);
    inbuf_readpos-=INBUFSIZE/2;
    inbuf_writepos-=INBUFSIZE/2;
  }
}





struct out_funcs par_out_funcs ={
  "parport",
  pic_setup,
  out_sync,
  out_freeze,
  power_pic,
  mclr_pic,
  copy_bits,
  in_bits,
  out_bits,
  my_usleep,
  clk_pic,
  out_pic,
  in_pic
};
