/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.SolarisParallel;
import com.sun.comm.SolarisSerial;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;

public class SolarisDriver
implements CommDriver {
    private boolean driverInitialized = false;

    private static String findPropFile(String string) {
        String string2 = System.getProperty("java.class.path");
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string2));
        streamTokenizer.whitespaceChars(File.pathSeparatorChar, File.pathSeparatorChar);
        streamTokenizer.wordChars(File.separatorChar, File.separatorChar);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.ordinaryChar(32);
        streamTokenizer.wordChars(32, 32);
        streamTokenizer.wordChars(95, 95);
        try {
            while (streamTokenizer.nextToken() != -1) {
                String string3;
                File file;
                int n = -1;
                if (streamTokenizer.ttype != -3 || (n = streamTokenizer.sval.indexOf("comm.jar")) == -1 || !(file = new File(string3 = new String(streamTokenizer.sval))).exists()) continue;
                String string4 = string3.substring(0, n);
                string4 = string4 != null ? String.valueOf(string4) + "." + File.separator + string : "." + File.separator + string;
                file = new File(string4);
                if (file.exists()) {
                    return new String(string4);
                }
                return null;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public CommPort getCommPort(String string, int n) {
        CommPort commPort = null;
        try {
            switch (n) {
                case 1: {
                    commPort = new SolarisSerial(string);
                    break;
                }
                case 2: {
                    commPort = new SolarisParallel(string);
                    break;
                }
                default: {
                    return commPort;
                }
            }
        }
        catch (IOException iOException) {}
        return commPort;
    }

    public void initialize() {
        Object object;
        String string = SolarisDriver.findPropFile("portmap.properties");
        if (!this.driverInitialized) {
            try {
                System.loadLibrary("SolarisSerialParallel");
            }
            catch (SecurityException securityException) {
                System.err.println("Security Exception SolarisSerial: " + securityException);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Error loading SolarisSerial: " + unsatisfiedLinkError);
            }
        }
        if (string == null) {
            string = new String("");
        } else if (string.length() < 1) {
            string = "";
        }
        Vector vector = new Vector();
        SolarisDriver.readRegistrySerial(vector, string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            CommPortIdentifier.addPortName((String)object, 1, this);
        }
        object = new Vector();
        SolarisDriver.readRegistryParallel((Vector)object);
        Enumeration enumeration2 = ((Vector)object).elements();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            CommPortIdentifier.addPortName(string2, 2, this);
        }
    }

    private static native int readRegistryParallel(Vector var0);

    private static native int readRegistrySerial(Vector var0, String var1);
}

