/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEvent;
import javax.comm.ParallelPortEventListener;
import javax.comm.UnsupportedCommOperationException;

class SolarisParallel
extends ParallelPort {
    private int port_mode = 1;
    private ParallelPortEventListener listener = null;
    private int rcv_timeout = 0;
    private int rcv_threshold = 0;
    private int framing_byte = -1;
    private int ibuffer_size = 1024;
    private int obuffer_size = 1024;
    private int deviceType = 0;
    public static final int LPT_MODE_ANY = 0;
    public static final int LPT_MODE_SPP = 1;
    public static final int LPT_MODE_PS2 = 2;
    public static final int LPT_MODE_EPP = 3;
    public static final int LPT_MODE_ECP = 4;
    private static final int STATUS_PaperOut = 1;
    private static final int STATUS_PrtBusy = 2;
    private static final int STATUS_PrtSelected = 4;
    private static final int STATUS_PrtTimedOut = 8;
    private static final int STATUS_PrtError = 16;
    private SPInputStream inputStream = null;
    private SPOutputStream outputStream = null;
    private int notificationMask = 0;
    private static final int NOTIFY_ERR = 1;
    private static final int NOTIFY_BUF = 2;
    private int port_fd = 0;

    static {
        System.loadLibrary("SolarisSerialParallel");
    }

    public SolarisParallel(String string) throws IOException {
        this.name = string;
        if (this.port_fd != 0) {
            return;
        }
        this.port_fd = this.openNativePort(string);
        if (this.port_fd < 0) {
            throw new IOException("port can not be opened.");
        }
    }

    public void addEventListener(ParallelPortEventListener parallelPortEventListener) throws TooManyListenersException {
        if (this.port_fd > 0) {
            if (this.listener != null) {
                throw new TooManyListenersException("only one listener is allowed");
            }
        } else {
            throw new IllegalStateException("This port is closed");
        }
        this.listener = parallelPortEventListener;
    }

    private native int available(int var1) throws IOException;

    public void close() {
        try {
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port is closed");
            }
            this.closeNativePort(this.port_fd);
            this.port_fd = 0;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        super.close();
    }

    private native void closeNativePort(int var1) throws IOException;

    public void disableReceiveFraming() {
        if (this.port_mode != 2) {
            throw new IllegalStateException("This port is not in bidirectional mode");
        }
        this.framing_byte = -1;
    }

    public void disableReceiveThreshold() {
        if (this.port_mode != 2) {
            throw new IllegalStateException("This port is not in bidirectional mode");
        }
        this.rcv_threshold = 0;
    }

    public void disableReceiveTimeout() {
        if (this.port_mode == 2) {
            this.rcv_timeout = 0;
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port is closed");
            }
        } else {
            throw new IllegalStateException("The port mode is not bidirectional");
        }
        this.setNativeTimeout(this.port_fd, this.rcv_timeout);
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        if (this.port_mode == 2) {
            this.framing_byte = -1;
            throw new UnsupportedCommOperationException("Receive framing is not supported in Solaris parallel port");
        }
        throw new IllegalStateException("This port is not in bidirectional mode");
    }

    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        if (this.port_mode == 2) {
            throw new UnsupportedCommOperationException("Receive threshold is not supported in Solaris parallel port");
        }
        throw new IllegalStateException("This port is not in bidirectional mode");
    }

    public void enableReceiveTimeout(int n) {
        if (this.port_mode == 2) {
            this.rcv_timeout = n;
            if (this.port_fd <= 0) {
                throw new IllegalStateException("This port is closed");
            }
        } else {
            throw new IllegalStateException("The port mode is not bidirectional");
        }
        this.setNativeTimeout(this.port_fd, this.rcv_timeout * 1000);
    }

    private int getDeviceType() {
        return this.deviceType;
    }

    public int getInputBufferSize() {
        return this.ibuffer_size;
    }

    public InputStream getInputStream() throws IOException {
        if (this.port_fd > 0) {
            if (this.port_mode == 2) {
                if (this.inputStream == null) {
                    this.inputStream = new SPInputStream();
                }
                return this.inputStream;
            }
            throw new IOException("This port is not in bidirectional mode");
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getMode() {
        return this.port_mode;
    }

    public int getOutputBufferFree() {
        return 512;
    }

    public int getOutputBufferSize() {
        return this.obuffer_size;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.port_fd > 0) {
            if (this.outputStream == null) {
                this.outputStream = new SPOutputStream(this);
            }
            return this.outputStream;
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getReceiveFramingByte() {
        return this.framing_byte;
    }

    public int getReceiveThreshold() {
        return this.rcv_threshold;
    }

    public int getReceiveTimeout() {
        return this.rcv_timeout;
    }

    private native boolean getStatusFlags(int var1, int var2);

    public boolean isPaperOut() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 1);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterBusy() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 2);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterError() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 16);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterSelected() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 4);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isPrinterTimedOut() {
        if (this.port_fd > 0) {
            return this.getStatusFlags(this.port_fd, 8);
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public boolean isReceiveThresholdEnabled() {
        return false;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcv_timeout > 0;
    }

    public void notifyOnBuffer(boolean bl) {
        this.notificationMask &= 0xFFFFFFFD;
        if (bl) {
            this.notificationMask |= 2;
        }
    }

    public void notifyOnError(boolean bl) {
        this.notificationMask &= 0xFFFFFFFE;
        if (bl) {
            this.notificationMask |= 1;
        }
    }

    private native int openNativePort(String var1);

    private void raiseEvent(int n, boolean bl, boolean bl2) {
        int n2 = 0;
        if (this.listener != null && (this.notificationMask & n) > 0) {
            switch (n) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            this.listener.parallelEvent(new ParallelPortEvent(this, n2, bl, bl2));
        }
    }

    private native int read(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native byte readByte(int var1) throws IOException;

    public void removeEventListener() {
        this.listener = null;
    }

    public void restart() {
    }

    private void setDeviceType(int n) {
        this.deviceType = n;
    }

    public void setInputBufferSize(int n) {
        this.ibuffer_size = n;
    }

    public int setMode(int n) throws UnsupportedCommOperationException {
        switch (n) {
            case 0: {
                this.port_mode = 1;
                break;
            }
            case 1: {
                this.port_mode = 1;
                break;
            }
            case 2: {
                this.port_mode = 2;
                break;
            }
            default: {
                throw new UnsupportedCommOperationException("mode not supported");
            }
        }
        return this.port_mode;
    }

    private native void setNativeTimeout(int var1, int var2);

    public void setOutputBufferSize(int n) {
        this.obuffer_size = n;
    }

    public void suspend() {
    }

    private native int write(int var1, byte[] var2, int var3, int var4) throws IOException;

    public class SPInputStream
    extends InputStream {
        private byte[] buf = null;
        private int pos = -1;
        private int high = 0;

        public int available() throws IOException {
            if (SolarisParallel.this.port_fd != 0) {
                return SolarisParallel.this.available(SolarisParallel.this.port_fd);
            }
            throw new IllegalStateException("This port is closed");
        }

        void printbuf(byte[] byArray) {
            String string = new String();
            int n = 0;
            while (n < byArray.length) {
                string = String.valueOf(string) + Integer.toHexString(byArray[n]) + " ";
                ++n;
            }
            System.out.println("\nhigh = " + this.high + "IN: " + string);
        }

        public int read() throws IOException {
            if (SolarisParallel.this.port_fd > 0) {
                return SolarisParallel.this.readByte(SolarisParallel.this.port_fd);
            }
            throw new IllegalStateException("This port is closed");
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2;
            int n4 = 0;
            if (byArray == null) {
                byArray = new byte[n2 + n];
            }
            if (n2 + n > byArray.length) {
                n3 = byArray.length - n;
            }
            try {
                if (SolarisParallel.this.port_fd <= 0) {
                    throw new IllegalStateException("Port Closed");
                }
                n4 = SolarisParallel.this.read(SolarisParallel.this.port_fd, byArray, n, n3);
                return n4;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw iOException;
            }
        }
    }

    public class SPOutputStream
    extends OutputStream {
        private SolarisParallel spPort;

        public SPOutputStream(SolarisParallel solarisParallel2) {
            this.spPort = solarisParallel2;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            if (SolarisParallel.this.port_fd > 0) {
                int n2 = SolarisParallel.this.write(SolarisParallel.this.port_fd, byArray, 0, 1);
                if (n2 != 1) {
                    throw new IOException("write to parallel port failed");
                }
            } else {
                throw new IllegalStateException("This port is closed");
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2;
            int n4 = 0;
            String string = new String(byArray);
            if (byArray != null) {
                if (n2 + n > byArray.length) {
                    n3 = byArray.length - n;
                }
                if (SolarisParallel.this.port_fd > 0) {
                    n4 = this.spPort.write(SolarisParallel.this.port_fd, byArray, n, n3);
                    if (n4 != n3) {
                        throw new IOException("write to parallel port failed");
                    }
                } else {
                    throw new IllegalStateException("Port Closed");
                }
            }
        }
    }
}

