/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortEnumerator;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    String name;
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    boolean owned;
    String owner;
    boolean inOpen;
    Vector listeners = null;
    private int portType;
    CommPortIdentifier next;
    private CommPort port;
    private CommDriver driver;
    private static CommDriver localDriver = null;
    static CommPortIdentifier masterIdList;
    static Object lock;
    static String propfilename;

    static {
        lock = new Object();
        String string = System.getProperty("javax.comm.properties");
        if (string != null) {
            System.err.println("Comm Drivers: " + string);
        }
        String string2 = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "javax.comm.properties";
        try {
            propfilename = new String(string2);
            CommPortIdentifier.loadDriver(string2);
        }
        catch (IOException iOException) {
            propfilename = CommPortIdentifier.findPropFile("javax.comm.properties");
            try {
                if (propfilename != null) {
                    CommPortIdentifier.loadDriver(propfilename);
                } else {
                    propfilename = new String(" ");
                    CommPortIdentifier.InitializeDriver("com.sun.comm.SolarisDriver");
                }
            }
            catch (IOException iOException2) {
                propfilename = new String(" ");
                System.err.println("Default SolarisDriver not found:" + iOException2);
            }
        }
    }

    CommPortIdentifier(String string, CommPort commPort, int n, CommDriver commDriver) {
        this.name = string;
        this.port = commPort;
        this.portType = n;
        this.next = null;
        this.driver = commDriver;
        this.owner = null;
        this.owned = false;
    }

    private static void InitializeDriver(String string) throws IOException {
        try {
            if (localDriver == null) {
                localDriver = (CommDriver)Class.forName(string).newInstance();
            }
            localDriver.initialize();
        }
        catch (Throwable throwable) {
            System.err.println("Caught " + throwable + " while loading driver " + string);
        }
    }

    private static void addPort(CommPort commPort, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(commPort.getName(), commPort, n, null);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
        }
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = new CommPortIdentifier(string, null, n, commDriver);
        CommPortIdentifier commPortIdentifier2 = masterIdList;
        CommPortIdentifier commPortIdentifier3 = null;
        Object object = lock;
        synchronized (object) {
            while (commPortIdentifier2 != null) {
                commPortIdentifier3 = commPortIdentifier2;
                commPortIdentifier2 = commPortIdentifier2.next;
            }
            if (commPortIdentifier3 != null) {
                commPortIdentifier3.next = commPortIdentifier;
            } else {
                masterIdList = commPortIdentifier;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1, 1);
        }
        if (!this.listeners.contains(commPortOwnershipListener)) {
            this.listeners.addElement(commPortOwnershipListener);
        }
    }

    private static String findPropFile(String string) {
        String string2 = System.getProperty("java.class.path");
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string2));
        streamTokenizer.whitespaceChars(File.pathSeparatorChar, File.pathSeparatorChar);
        streamTokenizer.wordChars(File.separatorChar, File.separatorChar);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.ordinaryChar(32);
        streamTokenizer.wordChars(32, 32);
        streamTokenizer.wordChars(95, 95);
        try {
            while (streamTokenizer.nextToken() != -1) {
                String string3;
                File file;
                int n = -1;
                if (streamTokenizer.ttype != -3 || (n = streamTokenizer.sval.indexOf("comm.jar")) == -1 || !(file = new File(string3 = new String(streamTokenizer.sval))).exists()) continue;
                String string4 = string3.substring(0, n);
                string4 = string4 != null ? String.valueOf(string4) + "." + File.separator + string : "." + File.separator + string;
                file = new File(string4);
                if (file.exists()) {
                    return new String(string4);
                }
                return null;
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    void fireOwnershipEvent(int n) {
        if (this.listeners != null) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                CommPortOwnershipListener commPortOwnershipListener = (CommPortOwnershipListener)enumeration.nextElement();
                commPortOwnershipListener.ownershipChange(n);
            }
        }
    }

    public String getCurrentOwner() {
        if (this.owned) {
            return this.owner;
        }
        return "Port currently not owned";
    }

    public String getName() {
        return this.name;
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = null;
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.name.equals(string)) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        CommPortIdentifier commPortIdentifier = null;
        Object object = lock;
        synchronized (object) {
            commPortIdentifier = masterIdList;
            while (commPortIdentifier != null) {
                if (commPortIdentifier.port == commPort) break;
                commPortIdentifier = commPortIdentifier.next;
            }
        }
        if (commPortIdentifier != null) {
            return commPortIdentifier;
        }
        throw new NoSuchPortException();
    }

    public static Enumeration getPortIdentifiers() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(propfilename);
        }
        masterIdList = null;
        try {
            CommPortIdentifier.InitializeDriver("com.sun.comm.SolarisDriver");
        }
        catch (IOException iOException) {}
        return new CommPortEnumerator();
    }

    public int getPortType() {
        return this.portType;
    }

    synchronized void internalClosePort() {
        this.owned = false;
        this.owner = null;
        this.port = null;
        this.notifyAll();
        if (!this.inOpen) {
            this.fireOwnershipEvent(2);
        }
    }

    public boolean isCurrentlyOwned() {
        return this.owned;
    }

    private static void loadDriver(String string) throws IOException {
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        String[] stringArray = CommPortIdentifier.parsePropsFile(bufferedInputStream);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].regionMatches(true, 0, "driver=", 0, 7)) {
                    String string2 = stringArray[n].substring(7);
                    string2.trim();
                    CommPortIdentifier.InitializeDriver(string2);
                }
                ++n;
            }
        }
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public synchronized CommPort open(String string, int n) throws PortInUseException {
        try {
            while (this.owned) {
                this.inOpen = true;
                this.fireOwnershipEvent(3);
                this.wait(n);
                if (!this.owned) continue;
                this.inOpen = false;
                throw new PortInUseException(this.getCurrentOwner());
            }
            this.inOpen = false;
        }
        catch (InterruptedException interruptedException) {
            this.inOpen = false;
            return null;
        }
        if (this.port == null) {
            this.port = this.driver.getCommPort(this.name, this.portType);
        }
        if (this.port == null) {
            throw new PortInUseException("another application, or cannot be accessed");
        }
        this.fireOwnershipEvent(1);
        this.owned = true;
        this.owner = string;
        return this.port;
    }

    private static String[] parsePropsFile(InputStream inputStream) {
        int n;
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            int n2;
            objectArray = new byte[4096];
            n = 0;
            boolean bl = false;
            block7: while ((n2 = inputStream.read()) != -1) {
                switch (n2) {
                    case 10: 
                    case 13: {
                        String string;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        bl = false;
                        break;
                    }
                    case 35: {
                        String string;
                        bl = true;
                        if (n > 0) {
                            string = new String((byte[])objectArray, 0, n);
                            vector.addElement(string);
                        }
                        n = 0;
                        break;
                    }
                    default: {
                        if (bl || n >= 4096) continue block7;
                        objectArray[n++] = (byte)n2;
                    }
                    case 9: 
                    case 32: 
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("Caught " + throwable + " parsing prop file.");
        }
        if (vector.size() > 0) {
            objectArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                objectArray[n] = (byte)((String)vector.elementAt(n));
                ++n;
            }
            return objectArray;
        }
        return null;
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (this.listeners != null) {
            this.listeners.removeElement(commPortOwnershipListener);
        }
    }
}

