/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Debug;
import org.gjt.mm.mysql.Field;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.SQLError;
import org.gjt.mm.mysql.Util;

public class MysqlIO {
    private Socket _Mysql_Conn;
    private BufferedInputStream _Mysql_Buf_Input;
    private BufferedOutputStream _Mysql_Buf_Output;
    private DataInputStream _Mysql_Input;
    private DataOutputStream _Mysql_Output;
    static int MAXBUF = 65535;
    static final int HEADER_LENGTH = 4;
    static final int COMP_HEADER_LENGTH = 3;
    private byte _packetSequence;
    private byte _protocol_V;
    private String _Server_V;
    private int _server_major_version;
    private int _server_minor_version;
    private int _server_sub_minor_version;
    private int _port = 3306;
    private String _Host;
    private Deflater _Deflater;
    private Inflater _Inflater;
    private Buffer _ReusablePacket = new Buffer(MAXBUF);
    SQLWarning _Warning;
    private static int CLIENT_LONG_PASSWORD = 1;
    private static int CLIENT_FOUND_ROWS = 2;
    private static int CLIENT_LONG_FLAG = 4;
    private static int CLIENT_CONNECT_WITH_DB = 8;
    private static int CLIENT_NO_SCHEMA = 16;
    private static int CLIENT_COMPRESS = 32;
    private static int CLIENT_ODBC = 64;
    private static int CLIENT_LOCAL_FILES = 128;
    private static int CLIENT_IGNORE_SPACE = 256;
    private boolean use_compression = false;

    MysqlIO(String Host, int port) throws IOException, SQLException {
        this._port = port;
        this._Host = Host;
        this._Mysql_Conn = new Socket(this._Host, this._port);
        this._Mysql_Buf_Input = new BufferedInputStream(this._Mysql_Conn.getInputStream());
        this._Mysql_Buf_Output = new BufferedOutputStream(this._Mysql_Conn.getOutputStream());
        this._Mysql_Input = new DataInputStream(this._Mysql_Buf_Input);
        this._Mysql_Output = new DataOutputStream(this._Mysql_Buf_Output);
    }

    void init(String User, String Password) throws SQLException {
        block25: {
            try {
                Buffer Buf = this.readPacket();
                this._protocol_V = Buf.readByte();
                if (this._protocol_V == -1) {
                    try {
                        this._Mysql_Conn.close();
                    }
                    catch (Exception exception) {}
                    throw new SQLException("Server configuration denies access to data source", "08001", 0);
                }
                this._Server_V = Buf.readString();
                int point = this._Server_V.indexOf(".");
                if (point != -1) {
                    try {
                        int n;
                        this._server_major_version = n = Integer.parseInt(this._Server_V.substring(0, point));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    String Remaining = this._Server_V.substring(point + 1, this._Server_V.length());
                    point = Remaining.indexOf(".");
                    if (point != -1) {
                        try {
                            int n;
                            this._server_minor_version = n = Integer.parseInt(Remaining.substring(0, point));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        Remaining = Remaining.substring(point + 1, Remaining.length());
                        int pos = 0;
                        while (pos < Remaining.length()) {
                            if (Remaining.charAt(pos) < '0' || Remaining.charAt(pos) > '9') break;
                            ++pos;
                        }
                        try {
                            int n;
                            this._server_sub_minor_version = n = Integer.parseInt(Remaining.substring(0, pos));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                long threadId = Buf.readLong();
                String Seed = Buf.readString();
                int clientParam = 0;
                if (Buf.pos < Buf.buf_length) {
                    int n = Buf.readInt();
                }
                clientParam = this._protocol_V > 9 ? 1 : (clientParam &= ~CLIENT_LONG_PASSWORD);
                int password_length = 16;
                int user_length = 0;
                if (User != null) {
                    user_length = User.length();
                }
                int pack_length = user_length + password_length + 6 + 4;
                Buffer Packet = new Buffer(pack_length);
                Packet.writeInt(clientParam);
                Packet.writeLongInt(pack_length);
                Packet.writeString(User);
                if (this._protocol_V > 9) {
                    Packet.writeString(Util.newCrypt(Password, Seed));
                } else {
                    Packet.writeString(Util.oldCrypt(Password, Seed));
                }
                this.send(Packet);
                Buffer B = this.readPacket();
                byte status = B.readByte();
                if (status == -1) {
                    String Message = "";
                    int errno = 2000;
                    if (this._protocol_V > 9) {
                        errno = B.readInt();
                        Message = B.readString();
                        this.clearReceive();
                        String XOpen = SQLError.mysqlToXOpen(errno);
                        if (XOpen.equals("S1000")) {
                            throw new SQLException("Communication failure during handshake. Is there a server running on " + this._Host + ":" + this._port + "?");
                        }
                        throw new SQLException(String.valueOf(SQLError.get(XOpen)) + ": " + Message, XOpen, errno);
                    }
                    Message = B.readString();
                    this.clearReceive();
                    if (Message.indexOf("Access denied") != -1) {
                        throw new SQLException(String.valueOf(SQLError.get("28000")) + ": " + Message, "28000", errno);
                    }
                    throw new SQLException(String.valueOf(SQLError.get("08001")) + ": " + Message, "08001", errno);
                }
                if (status == 0) {
                    if (this._server_major_version >= 3 && this._server_minor_version >= 22 && this._server_sub_minor_version >= 5) {
                        Packet.newReadLength();
                        Packet.newReadLength();
                    } else {
                        Packet.readLength();
                        Packet.readLength();
                    }
                    break block25;
                }
                throw new SQLException("Unknown Status code from server", "08007", status);
            }
            catch (IOException E) {
                E.printStackTrace();
                throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + E.getClass().getName(), "08S01", 0);
            }
        }
    }

    String getServerVersion() {
        return this._Server_V;
    }

    final Buffer sendCommand(int command, String ExtraData, Buffer QueryPacket) throws Exception {
        byte statusCode;
        Buffer Ret = null;
        try {
            Buffer Packet = null;
            if (QueryPacket == null) {
                int pack_length = 8 + ExtraData.length() + 2;
                Packet = new Buffer(pack_length);
                this._packetSequence = (byte)-1;
                Packet.clear();
                if (this.use_compression) {
                    Packet.pos += 3;
                }
                Packet.writeByte((byte)command);
                if (command == 2 || command == 5 || command == 6 || command == 3) {
                    Packet.writeStringNoNull(ExtraData);
                } else if (command == 12) {
                    long id = new Long(ExtraData);
                    Packet.writeLong(id);
                } else if (command == 7 && this._protocol_V > 9) {
                    Debug.msg(this, "Reload");
                }
            } else {
                this._packetSequence = (byte)-1;
                Packet = QueryPacket;
            }
            this.send(Packet);
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + Ex.getClass().getName(), "08S01", 0);
        }
        try {
            Ret = this.readPacket();
            statusCode = Ret.readByte();
        }
        catch (EOFException EOFE) {
            throw EOFE;
        }
        catch (Exception FallThru) {
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + FallThru.getClass().getName(), "08S01", 0);
        }
        try {
            SQLWarning NW;
            if (statusCode == -1) {
                String ErrorMessage;
                int errno = 2000;
                if (this._protocol_V > 9) {
                    errno = Ret.readInt();
                    ErrorMessage = Ret.readString();
                    this.clearReceive();
                    String XOpen = SQLError.mysqlToXOpen(errno);
                    throw new SQLException(String.valueOf(SQLError.get(XOpen)) + ": " + ErrorMessage, XOpen, errno);
                }
                ErrorMessage = Ret.readString();
                this.clearReceive();
                if (ErrorMessage.indexOf("Unknown column") != -1) {
                    throw new SQLException(String.valueOf(SQLError.get("S0022")) + ": " + ErrorMessage, "S0022", -1);
                }
                throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + ErrorMessage, "S1000", -1);
            }
            if (statusCode == 0) {
                if (command == 5 || command == 6) {
                    NW = new SQLWarning("Command=" + command + ": ");
                    if (this._Warning != null) {
                        NW.setNextException(this._Warning);
                    }
                    this._Warning = NW;
                }
            } else if (Ret.isLastDataPacket()) {
                NW = new SQLWarning("Command=" + command + ": ");
                if (this._Warning != null) {
                    NW.setNextException(this._Warning);
                }
                this._Warning = NW;
            }
            return Ret;
        }
        catch (IOException E) {
            throw new SQLException(String.valueOf(SQLError.get("08S01")) + ": " + E.getClass().getName(), "08S01", 0);
        }
    }

    final ResultSet sqlQueryDirect(Buffer QueryPacket, int max_rows) throws Exception {
        long updateCount = -1L;
        long updateID = -1L;
        this.clearAllReceive();
        Buffer Packet = this.sendCommand(3, null, QueryPacket);
        --Packet.pos;
        long columnCount = Packet.readLength();
        if (columnCount == 0L) {
            try {
                if (this._server_major_version >= 3 && this._server_minor_version >= 22 && this._server_sub_minor_version >= 5) {
                    updateCount = Packet.newReadLength();
                    updateID = Packet.newReadLength();
                } else {
                    updateCount = Packet.readLength();
                    updateID = Packet.readLength();
                }
            }
            catch (Exception E) {
                throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + E.getClass().getName(), "S1000", -1);
            }
            return new ResultSet(updateCount, updateID);
        }
        Field[] Fields = new Field[(int)columnCount];
        int i = 0;
        while ((long)i < columnCount) {
            Packet = this.readPacket();
            String TableName = Packet.readLenString();
            String ColName = Packet.readLenString();
            int colLength = Packet.readnBytes();
            int colType = Packet.readnBytes();
            Packet.readByte();
            short colFlag = (short)Buffer.ub(Packet.readByte());
            int colDecimals = Buffer.ub(Packet.readByte());
            Fields[i] = new Field(TableName, ColName, colLength, colType, colFlag, colDecimals);
            ++i;
        }
        Packet = this.readPacket();
        Vector<byte[][]> Rows = new Vector<byte[][]>();
        byte[][] Row = this.nextRow((int)columnCount);
        Rows.addElement(Row);
        int row_count = 1;
        while (Row != null && row_count < max_rows) {
            Row = this.nextRow((int)columnCount);
            if (Row == null) continue;
            Rows.addElement(Row);
            ++row_count;
        }
        return new ResultSet(Fields, Rows);
    }

    final ResultSet sqlQuery(String Query, int max_rows, String Encoding) throws Exception {
        int pack_length = 5 + Query.length() * 2 + 2;
        Buffer Packet = new Buffer(pack_length);
        Packet.writeByte((byte)3);
        if (Encoding != null) {
            Packet.writeStringNoNull(Query, Encoding);
        } else {
            Packet.writeStringNoNull(Query);
        }
        return this.sqlQueryDirect(Packet, max_rows);
    }

    final ResultSet sqlQuery(String Query, int max_rows) throws Exception {
        long updateCount = -1L;
        long updateID = -1L;
        this.clearAllReceive();
        Buffer Packet = this.sendCommand(3, Query, null);
        --Packet.pos;
        long columnCount = Packet.readLength();
        if (columnCount == 0L) {
            try {
                if (this._server_major_version >= 3 && this._server_minor_version >= 22 && this._server_sub_minor_version >= 5) {
                    updateCount = Packet.newReadLength();
                    updateID = Packet.newReadLength();
                } else {
                    updateCount = Packet.readLength();
                    updateID = Packet.readLength();
                }
            }
            catch (Exception E) {
                throw new SQLException(String.valueOf(SQLError.get("S1000")) + ": " + E.getClass().getName(), "S1000", -1);
            }
            return new ResultSet(updateCount, updateID);
        }
        Field[] Fields = new Field[(int)columnCount];
        int i = 0;
        while ((long)i < columnCount) {
            Packet = this.readPacket();
            String TableName = Packet.readLenString();
            String ColName = Packet.readLenString();
            int colLength = Packet.readnBytes();
            int colType = Packet.readnBytes();
            Packet.readByte();
            short colFlag = (short)Buffer.ub(Packet.readByte());
            int colDecimals = Buffer.ub(Packet.readByte());
            Fields[i] = new Field(TableName, ColName, colLength, colType, colFlag, colDecimals);
            ++i;
        }
        Packet = this.readPacket();
        Vector<byte[][]> Rows = new Vector<byte[][]>();
        byte[][] Row = this.nextRow((int)columnCount);
        Rows.addElement(Row);
        int row_count = 1;
        while (Row != null && row_count < max_rows) {
            Row = this.nextRow((int)columnCount);
            if (Row == null) continue;
            Rows.addElement(Row);
            ++row_count;
        }
        return new ResultSet(Fields, Rows);
    }

    private final byte[][] nextRow(int columnCount) throws Exception {
        Buffer Packet = this.reuseAndReadPacket(this._ReusablePacket);
        if (Packet.readByte() == -1) {
            int errno = 2000;
            if (this._protocol_V > 9) {
                errno = Packet.readInt();
                String ErrorMessage = Packet.readString();
                String XOpen = SQLError.mysqlToXOpen(errno);
                this.clearReceive();
                throw new SQLException(String.valueOf(SQLError.get(SQLError.get(XOpen))) + ": " + ErrorMessage, XOpen, errno);
            }
            String ErrorMessage = Packet.readString();
            this.clearReceive();
            throw new SQLException(ErrorMessage, SQLError.mysqlToXOpen(errno), errno);
        }
        --Packet.pos;
        int[] dataStart = new int[columnCount];
        byte[][] Row = new byte[columnCount][];
        if (!Packet.isLastDataPacket()) {
            int i = 0;
            while (i < columnCount) {
                int p;
                dataStart[i] = p = Packet.pos;
                Packet.pos = (int)Packet.readLength() + Packet.pos;
                ++i;
            }
            int i2 = 0;
            while (i2 < columnCount) {
                Packet.pos = dataStart[i2];
                Row[i2] = Packet.readLenByteArray();
                ++i2;
            }
            return Row;
        }
        return null;
    }

    final void quit() throws IOException {
        Buffer Packet = new Buffer(6);
        this._packetSequence = (byte)-1;
        Packet.writeByte((byte)1);
        this.send(Packet);
        this._Mysql_Conn.close();
    }

    final int getServerMajorVersion() {
        return this._server_major_version;
    }

    final int getServerMinorVersion() {
        return this._server_minor_version;
    }

    final int getServerSubMinorVersion() {
        return this._server_sub_minor_version;
    }

    private final Buffer readPacket() throws IOException {
        byte b0 = this._Mysql_Input.readByte();
        byte b1 = this._Mysql_Input.readByte();
        byte b2 = this._Mysql_Input.readByte();
        int packetLength = Buffer.ub(b0) + 256 * Buffer.ub(b1) + 65536 * Buffer.ub(b2);
        byte packetSeq = this._Mysql_Input.readByte();
        byte[] buffer = new byte[packetLength + 1];
        this._Mysql_Input.readFully(buffer, 0, packetLength);
        buffer[packetLength] = 0;
        return new Buffer(buffer);
    }

    private final Buffer reuseAndReadPacket(Buffer Reuse) throws IOException {
        byte b0 = this._Mysql_Input.readByte();
        byte b1 = this._Mysql_Input.readByte();
        byte b2 = this._Mysql_Input.readByte();
        int packetLength = Buffer.ub(b0) + 256 * Buffer.ub(b1) + 65536 * Buffer.ub(b2);
        byte packetSeq = this._Mysql_Input.readByte();
        Reuse.pos = 0;
        Reuse.send_length = 0;
        if (Reuse.buf.length < packetLength) {
            Reuse.buf = new byte[packetLength];
        }
        Reuse.buf_length = packetLength;
        this._Mysql_Input.readFully(Reuse.buf, 0, packetLength);
        Reuse.buf[packetLength] = 0;
        return Reuse;
    }

    private final void send(Buffer Packet) throws IOException {
        int l = Packet.pos;
        this._packetSequence = (byte)(this._packetSequence + 1);
        Packet.pos = 0;
        Packet.writeLongInt(l - 4);
        Packet.writeByte(this._packetSequence);
        this._Mysql_Output.write(Packet.buf, 0, l);
        this._Mysql_Output.flush();
        this._Mysql_Buf_Output.flush();
        int total_header_length = 4;
    }

    private final void clearReceive() throws IOException {
        int len = this._Mysql_Buf_Input.available();
        if (len > 0) {
            this._Mysql_Input.skipBytes(len);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void clearAllReceive() throws SQLException {
        try {
            int len = this._Mysql_Buf_Input.available();
            if (len > 0) {
                Buffer Packet = this.readPacket();
                if (Packet.buf[0] == -1) {
                    this.clearReceive();
                    return;
                }
                while (!Packet.isLastDataPacket()) {
                    Packet = this.readPacket();
                    if (Packet.buf[0] != -1) continue;
                }
            }
            this.clearReceive();
            return;
        }
        catch (IOException E) {
            throw new SQLException("Communication link failure: " + E.getClass().getName(), "08S01");
        }
    }

    static int getMaxBuf() {
        return MAXBUF;
    }
}

