/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.EscapeProcessor;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private String _Sql;
    private String[] _TemplateStrings;
    private String[] _ParameterStrings;
    private InputStream[] _ParameterStreams;
    private boolean[] _IsStream;
    private Connection _Conn;
    private boolean _do_concat = false;
    private boolean _has_limit_clause = false;
    private static NumberFormat _DoubleFormatter = NumberFormat.getNumberInstance(Locale.US);

    public PreparedStatement(Connection Conn, String Sql, String Catalog) throws SQLException {
        super(Conn, Catalog);
        if (Sql.indexOf("||") != -1) {
            this._do_concat = true;
        }
        this._has_limit_clause = Sql.toUpperCase().indexOf("LIMIT") != -1;
        Vector<String> V = new Vector<String>();
        boolean inQuotes = false;
        int lastParmEnd = 0;
        this._Sql = Sql;
        this._Conn = Conn;
        int i = 0;
        while (i < this._Sql.length()) {
            char c = this._Sql.charAt(i);
            if (c == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c == '?' && !inQuotes) {
                V.addElement(this._Sql.substring(lastParmEnd, i));
                lastParmEnd = i + 1;
            }
            ++i;
        }
        V.addElement(this._Sql.substring(lastParmEnd, this._Sql.length()));
        this._TemplateStrings = new String[V.size()];
        this._ParameterStrings = new String[V.size() - 1];
        this._ParameterStreams = new InputStream[V.size() - 1];
        this._IsStream = new boolean[V.size() - 1];
        this.clearParameters();
        i = 0;
        while (i < this._TemplateStrings.length) {
            this._TemplateStrings[i] = (String)V.elementAt(i);
            ++i;
        }
        int j = 0;
        while (j < this._ParameterStrings.length) {
            this._IsStream[j] = false;
            ++j;
        }
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        boolean do_escape_processing = this._escapeProcessing;
        this._escapeProcessing = false;
        Buffer Packet = new Buffer(MysqlIO.getMaxBuf());
        Packet.writeByte((byte)3);
        String Encoding = null;
        if (this._Conn.useUnicode()) {
            Encoding = this._Conn.getEncoding();
        }
        try {
            int i = 0;
            while (i < this._ParameterStrings.length) {
                if (this._ParameterStrings[i] == null && this._IsStream[i] && this._ParameterStreams[i] == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1), "07001");
                }
                if (Encoding != null) {
                    Packet.writeStringNoNull(this._TemplateStrings[i], Encoding);
                } else {
                    Packet.writeStringNoNull(this._TemplateStrings[i]);
                }
                if (this._IsStream[i]) {
                    Packet.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[i]));
                } else {
                    if (do_escape_processing) {
                        this._ParameterStrings[i] = this._Escaper.escapeSQL(this._ParameterStrings[i]);
                    }
                    if (Encoding != null) {
                        Packet.writeStringNoNull(this._ParameterStrings[i], Encoding);
                    } else {
                        Packet.writeStringNoNull(this._ParameterStrings[i]);
                    }
                }
                ++i;
            }
            if (Encoding != null) {
                Packet.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length], Encoding);
            } else {
                Packet.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + Encoding + "'");
        }
        if (this._Results != null) {
            this._Results.close();
        }
        Object i = this._Conn.getMutex();
        synchronized (i) {
            String OldCatalog = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                OldCatalog = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (this._has_limit_clause) {
                    this._Results = this._Conn.execSQL(null, this._max_rows, Packet);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + 50000000, -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    this._Results = this._Conn.execSQL(null, -1, Packet);
                    if (OldCatalog != null) {
                        this._Conn.setCatalog(OldCatalog);
                    }
                }
            } else {
                this._Results = this._Conn.execSQL(null, -1, Packet);
            }
            if (OldCatalog != null) {
                this._Conn.setCatalog(OldCatalog);
            }
        }
        this._last_insert_id = this._Results.getUpdateID();
        this._NextResults = this._Results;
        this._Results.setConnection(this._Conn);
        this._escapeProcessing = do_escape_processing;
        return this._Results;
    }

    public int executeUpdate() throws SQLException {
        boolean do_escape_processing = this._escapeProcessing;
        this._escapeProcessing = false;
        Buffer Packet = new Buffer(MysqlIO.getMaxBuf());
        Packet.writeByte((byte)3);
        String Encoding = null;
        if (this._Conn.useUnicode()) {
            Encoding = this._Conn.getEncoding();
        }
        try {
            int i = 0;
            while (i < this._ParameterStrings.length) {
                if (this._ParameterStrings[i] == null && this._IsStream[i] && this._ParameterStreams[i] == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1), "07001");
                }
                if (Encoding != null) {
                    Packet.writeStringNoNull(this._TemplateStrings[i], Encoding);
                } else {
                    Packet.writeStringNoNull(this._TemplateStrings[i]);
                }
                if (this._IsStream[i]) {
                    Packet.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[i]));
                } else {
                    if (do_escape_processing) {
                        this._ParameterStrings[i] = this._Escaper.escapeSQL(this._ParameterStrings[i]);
                    }
                    if (Encoding != null) {
                        Packet.writeStringNoNull(this._ParameterStrings[i], Encoding);
                    } else {
                        Packet.writeStringNoNull(this._ParameterStrings[i]);
                    }
                }
                ++i;
            }
            if (Encoding != null) {
                Packet.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length], Encoding);
            } else {
                Packet.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + Encoding + "'");
        }
        ResultSet RS = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                OldCatalog = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            RS = this._Conn.execSQL(null, -1, Packet);
            if (OldCatalog != null) {
                this._Conn.setCatalog(OldCatalog);
            }
        }
        if (RS.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this._update_count = RS.getUpdateCount();
        int truncated_update_count = 0;
        truncated_update_count = this._update_count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._update_count;
        this._last_insert_id = RS.getUpdateID();
        this._escapeProcessing = do_escape_processing;
        return truncated_update_count;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.set(parameterIndex, "null");
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.set(parameterIndex, x ? "'t'" : "'f'");
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.set(parameterIndex, new Integer(x).toString());
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.set(parameterIndex, new Integer(x).toString());
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.set(parameterIndex, new Integer(x).toString());
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.set(parameterIndex, new Long(x).toString());
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.set(parameterIndex, new Float(x).toString());
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.set(parameterIndex, _DoubleFormatter.format(x));
    }

    public void setBigDecimal(int parameterIndex, BigDecimal X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.set(parameterIndex, X.toString());
        }
    }

    public void setString(int parameterIndex, String X) throws SQLException {
        if (X == null) {
            this.set(parameterIndex, "null");
        } else {
            StringBuffer B = new StringBuffer();
            B.append('\'');
            int i = 0;
            while (i < X.length()) {
                char c = X.charAt(i);
                if (c == '\\' || c == '\'' || c == '\"') {
                    B.append('\\');
                }
                B.append(c);
                ++i;
            }
            B.append('\'');
            this.set(parameterIndex, B.toString());
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, -2);
        } else {
            ByteArrayInputStream BIn = new ByteArrayInputStream(x);
            this.setBinaryStream(parameterIndex, (InputStream)BIn, x.length);
        }
    }

    public void setDate(int parameterIndex, Date X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 91);
        } else {
            SimpleDateFormat DF = new SimpleDateFormat("''yyyy-MM-dd''");
            this.set(parameterIndex, DF.format(X));
        }
    }

    public void setTime(int parameterIndex, Time X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 92);
        } else {
            this.set(parameterIndex, "'" + X.toString() + "'");
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 93);
        } else {
            EscapeProcessor EP = new EscapeProcessor();
            String TimestampString = EP.escapeSQL("{ts '" + X.toString() + "'}");
            this.set(parameterIndex, TimestampString);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream X, int length) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, X, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream X, int length) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setBinaryStream(parameterIndex, X, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream X, int length) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, -2);
        } else {
            if (parameterIndex < 1 || parameterIndex > this._TemplateStrings.length) {
                throw new SQLException("Parameter index out of range (" + parameterIndex + " > " + this._TemplateStrings.length + ")", "S1009");
            }
            this._ParameterStreams[parameterIndex - 1] = X;
            this._IsStream[parameterIndex - 1] = true;
        }
    }

    public void clearParameters() throws SQLException {
        int i = 0;
        while (i < this._ParameterStrings.length) {
            this._ParameterStrings[i] = null;
            this._ParameterStreams[i] = null;
            this._IsStream[i] = false;
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(int parameterIndex, Object X, int targetSqlType, int scale) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 1111);
            return;
        }
        try {
            switch (targetSqlType) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    Number X_as_number;
                    if (X instanceof Boolean) {
                        X_as_number = (Boolean)X != false ? new Integer(1) : new Integer(0);
                    } else if (X instanceof String) {
                        switch (targetSqlType) {
                            case -6: 
                            case 4: 
                            case 5: {
                                X_as_number = Integer.valueOf((String)X);
                                break;
                            }
                            case -5: {
                                X_as_number = Long.valueOf((String)X);
                                break;
                            }
                            case 7: {
                                X_as_number = Float.valueOf((String)X);
                                break;
                            }
                            case 6: 
                            case 8: {
                                X_as_number = Double.valueOf((String)X);
                                break;
                            }
                            default: {
                                X_as_number = new BigDecimal((String)X);
                                break;
                            }
                        }
                    } else {
                        X_as_number = (Number)X;
                    }
                    switch (targetSqlType) {
                        case -6: 
                        case 4: 
                        case 5: {
                            this.setInt(parameterIndex, X_as_number.intValue());
                            return;
                        }
                        case -5: {
                            this.setLong(parameterIndex, X_as_number.longValue());
                            return;
                        }
                        case 7: {
                            this.setFloat(parameterIndex, X_as_number.floatValue());
                            return;
                        }
                        case 6: 
                        case 8: {
                            this.setDouble(parameterIndex, X_as_number.doubleValue());
                            return;
                        }
                        default: {
                            if (X_as_number instanceof BigDecimal) {
                                this.setBigDecimal(parameterIndex, (BigDecimal)X_as_number);
                                return;
                            }
                            if (X_as_number instanceof BigInteger) {
                                this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)X_as_number, scale));
                                return;
                            }
                            this.setBigDecimal(parameterIndex, new BigDecimal(X_as_number.doubleValue()));
                            return;
                        }
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    this.setString(parameterIndex, X.toString());
                    return;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (X instanceof String) {
                        this.setBytes(parameterIndex, ((String)X).getBytes());
                        return;
                    } else {
                        this.setBytes(parameterIndex, (byte[])X);
                    }
                    return;
                }
                case 91: 
                case 93: {
                    java.util.Date X_as_date;
                    if (X instanceof String) {
                        ParsePosition pp = new ParsePosition(0);
                        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)X, false));
                        X_as_date = ((DateFormat)sdf).parse((String)X, pp);
                    } else {
                        X_as_date = (java.util.Date)X;
                    }
                    switch (targetSqlType) {
                        case 91: {
                            if (X_as_date instanceof Date) {
                                this.setDate(parameterIndex, (Date)X_as_date);
                                return;
                            } else {
                                this.setDate(parameterIndex, new Date(X_as_date.getTime()));
                            }
                            return;
                        }
                        case 93: {
                            if (X_as_date instanceof Timestamp) {
                                this.setTimestamp(parameterIndex, (Timestamp)X_as_date);
                                return;
                            } else {
                                this.setTimestamp(parameterIndex, new Timestamp(X_as_date.getTime()));
                            }
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 92: {
                    if (X instanceof String) {
                        SimpleDateFormat sdf = new SimpleDateFormat(this.getDateTimePattern((String)X, true));
                        this.setTime(parameterIndex, new Time(sdf.parse((String)X).getTime()));
                        return;
                    } else {
                        this.setTime(parameterIndex, (Time)X);
                    }
                    return;
                }
                case 1111: {
                    try {
                        ByteArrayOutputStream BytesOut = new ByteArrayOutputStream();
                        ObjectOutputStream ObjectOut = new ObjectOutputStream(BytesOut);
                        ObjectOut.writeObject(X);
                        ObjectOut.flush();
                        ObjectOut.close();
                        BytesOut.flush();
                        ((OutputStream)BytesOut).close();
                        byte[] buf = BytesOut.toByteArray();
                        ByteArrayInputStream BytesIn = new ByteArrayInputStream(buf);
                        this.setBinaryStream(parameterIndex, (InputStream)BytesIn, -1);
                        return;
                    }
                    catch (Exception E) {
                        throw new SQLException("Invalid argument value: " + E.getClass().getName(), "S1009");
                    }
                }
                default: {
                    throw new SQLException("Unknown Types value", "S1000");
                }
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof SQLException)) throw new SQLException("Cannot convert " + X.getClass().toString() + " to SQL type requested", "S1000");
            throw (SQLException)ex;
        }
    }

    public void setObject(int parameterIndex, Object X, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, X, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object X) throws SQLException {
        if (X == null) {
            this.setNull(parameterIndex, 1111);
        } else if (X instanceof String) {
            this.setString(parameterIndex, (String)X);
        } else if (X instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)X);
        } else if (X instanceof Integer) {
            this.setInt(parameterIndex, (Integer)X);
        } else if (X instanceof Long) {
            this.setLong(parameterIndex, (Long)X);
        } else if (X instanceof Float) {
            this.setFloat(parameterIndex, ((Float)X).floatValue());
        } else if (X instanceof Double) {
            this.setDouble(parameterIndex, (Double)X);
        } else if (X instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])X);
        } else if (X instanceof Date) {
            this.setDate(parameterIndex, (Date)X);
        } else if (X instanceof Time) {
            this.setTime(parameterIndex, (Time)X);
        } else if (X instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)X);
        } else if (X instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)X);
        } else {
            try {
                ByteArrayOutputStream BytesOut = new ByteArrayOutputStream();
                ObjectOutputStream ObjectOut = new ObjectOutputStream(BytesOut);
                ObjectOut.writeObject(X);
                ObjectOut.flush();
                ObjectOut.close();
                BytesOut.flush();
                ((OutputStream)BytesOut).close();
                byte[] buf = BytesOut.toByteArray();
                ByteArrayInputStream BytesIn = new ByteArrayInputStream(buf);
                this.setBinaryStream(parameterIndex, (InputStream)BytesIn, -1);
            }
            catch (Exception E) {
                throw new SQLException("Invalid argument value: " + E.getClass().getName(), "S1009");
            }
        }
    }

    public boolean execute() throws SQLException {
        boolean do_escape_processing = this._escapeProcessing;
        this._escapeProcessing = false;
        Buffer Packet = new Buffer(MysqlIO.getMaxBuf());
        Packet.writeByte((byte)3);
        String Encoding = null;
        if (this._Conn.useUnicode()) {
            Encoding = this._Conn.getEncoding();
        }
        try {
            int i = 0;
            while (i < this._ParameterStrings.length) {
                if (this._ParameterStrings[i] == null && this._IsStream[i] && this._ParameterStreams[i] == null) {
                    throw new SQLException("No value specified for parameter " + (i + 1));
                }
                if (Encoding != null) {
                    Packet.writeStringNoNull(this._TemplateStrings[i], Encoding);
                } else {
                    Packet.writeStringNoNull(this._TemplateStrings[i]);
                }
                if (this._IsStream[i]) {
                    Packet.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[i]));
                } else {
                    if (do_escape_processing) {
                        this._ParameterStrings[i] = this._Escaper.escapeSQL(this._ParameterStrings[i]);
                    }
                    if (Encoding != null) {
                        Packet.writeStringNoNull(this._ParameterStrings[i], Encoding);
                    } else {
                        Packet.writeStringNoNull(this._ParameterStrings[i]);
                    }
                }
                ++i;
            }
            if (Encoding != null) {
                Packet.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length], Encoding);
            } else {
                Packet.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + Encoding + "'");
        }
        ResultSet RS = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String OldCatalog = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                OldCatalog = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (this._has_limit_clause) {
                    RS = this._Conn.execSQL(null, this._max_rows, Packet);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + 50000000, -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    RS = this._Conn.execSQL(null, -1, Packet);
                }
            } else {
                RS = this._Conn.execSQL(null, -1, Packet);
            }
            if (OldCatalog != null) {
                this._Conn.setCatalog(OldCatalog);
            }
        }
        this._last_insert_id = RS.getUpdateID();
        if (RS != null) {
            this._Results = RS;
        }
        this._escapeProcessing = do_escape_processing;
        RS.setConnection(this._Conn);
        return RS != null && RS.reallyResult();
    }

    public String toString() {
        String Encoding = null;
        if (this._Conn.useUnicode()) {
            Encoding = this._Conn.getEncoding();
        }
        StringBuffer SB = new StringBuffer();
        SB.append(super.toString());
        SB.append(": ");
        try {
            int i = 0;
            while (i < this._ParameterStrings.length) {
                if (Encoding != null) {
                    SB.append(new String(this._TemplateStrings[i].getBytes(), Encoding));
                } else {
                    SB.append(this._TemplateStrings[i]);
                }
                if (this._ParameterStrings[i] == null && this._IsStream[i] && this._ParameterStreams[i] == null) {
                    SB.append("** NOT SPECIFIED **");
                } else if (this._IsStream[i]) {
                    SB.append("** STREAM DATA **");
                } else {
                    if (this._escapeProcessing) {
                        try {
                            this._ParameterStrings[i] = this._Escaper.escapeSQL(this._ParameterStrings[i]);
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (Encoding != null) {
                        SB.append(new String(this._ParameterStrings[i].getBytes(), Encoding));
                    } else {
                        SB.append(this._ParameterStrings[i]);
                    }
                }
                ++i;
            }
            if (Encoding != null) {
                SB.append(new String(this._TemplateStrings[this._ParameterStrings.length].getBytes(), Encoding));
            } else {
                SB.append(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SB.append("\n\n** WARNING **\n\n Unsupported character encoding '");
            SB.append(Encoding);
            SB.append("'");
        }
        return SB.toString();
    }

    private final void set(int paramIndex, String S) throws SQLException {
        if (paramIndex < 1 || paramIndex > this._TemplateStrings.length) {
            throw new SQLException("Parameter index out of range (" + paramIndex + " > " + this._TemplateStrings.length + ").", "S1009");
        }
        this._ParameterStrings[paramIndex - 1] = S;
    }

    private final int readblock(InputStream i, byte[] b) throws SQLException {
        try {
            return i.read(b);
        }
        catch (Throwable E) {
            throw new SQLException("Error reading from InputStream " + E.getClass().getName(), "S1000");
        }
    }

    private final void escapeblock(byte[] buf, ByteArrayOutputStream BytesOut, int size) {
        boolean c = false;
        int i = 0;
        while (i < size) {
            byte b = buf[i];
            if (b == 0) {
                BytesOut.write(92);
                BytesOut.write(48);
            } else {
                if (b == 92 || b == 39 || b == 34) {
                    BytesOut.write(92);
                }
                BytesOut.write(b);
            }
            ++i;
        }
    }

    private final byte[] streamToBytes(InputStream In) throws SQLException {
        byte[] bi = new byte[131072];
        ByteArrayOutputStream BytesOut = new ByteArrayOutputStream();
        int bc = this.readblock(In, bi);
        BytesOut.write(39);
        while (bc > 0) {
            this.escapeblock(bi, BytesOut, bc);
            bc = this.readblock(In, bi);
        }
        BytesOut.write(39);
        return BytesOut.toByteArray();
    }

    private final char getSuccessor(char c, int n) {
        return (char)(c == 'y' && n == 2 ? 88 : (c == 'y' && n < 4 ? 121 : (c == 'y' ? 77 : (c == 'M' && n == 2 ? 89 : (c == 'M' && n < 3 ? 77 : (c == 'M' ? 100 : (c == 'd' && n < 2 ? 100 : (c == 'd' ? 104 : (c == 'h' && n < 2 ? 104 : (c == 'h' ? 109 : (c == 'm' && n < 2 ? 109 : (c == 'm' ? 115 : (c == 's' && n < 2 ? 115 : 87)))))))))))));
    }

    private final String getDateTimePattern(String dt, boolean toTime) throws Exception {
        Enumeration en;
        char c;
        int n;
        Object[] v;
        int z;
        StringReader reader = new StringReader(String.valueOf(dt) + " ");
        Vector<Object[]> vec = new Vector<Object[]>();
        Vector<Object[]> vec_removelist = new Vector<Object[]>();
        Object[] nv = new Object[]{new Character('y'), new StringBuffer(), new Integer(0)};
        vec.addElement(nv);
        if (toTime) {
            nv = new Object[]{new Character('h'), new StringBuffer(), new Integer(0)};
            vec.addElement(nv);
        }
        while ((z = reader.read()) != -1) {
            char separator = (char)z;
            int maxvecs = vec.size();
            int count = 0;
            while (count < maxvecs) {
                v = (Object[])vec.elementAt(count);
                n = (Integer)v[2];
                c = this.getSuccessor(((Character)v[0]).charValue(), n);
                if (!Character.isLetterOrDigit(separator)) {
                    if (c == ((Character)v[0]).charValue() && c != 'S') {
                        vec_removelist.addElement(v);
                    } else {
                        ((StringBuffer)v[1]).append(separator);
                        if (c == 'X' || c == 'Y') {
                            v[2] = new Integer(4);
                        }
                    }
                } else {
                    if (c == 'X') {
                        c = 'y';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v[1]).toString()).append('M');
                        nv[0] = new Character('M');
                        nv[2] = new Integer(1);
                        vec.addElement(nv);
                    } else if (c == 'Y') {
                        c = 'M';
                        nv = new Object[3];
                        nv[1] = new StringBuffer(((StringBuffer)v[1]).toString()).append('d');
                        nv[0] = new Character('d');
                        nv[2] = new Integer(1);
                        vec.addElement(nv);
                    }
                    ((StringBuffer)v[1]).append(c);
                    if (c == ((Character)v[0]).charValue()) {
                        v[2] = new Integer(n + 1);
                    } else {
                        v[0] = new Character(c);
                        v[2] = new Integer(1);
                    }
                }
                ++count;
            }
            en = vec_removelist.elements();
            while (en.hasMoreElements()) {
                v = (Object[])en.nextElement();
                vec.removeElement(v);
            }
            vec_removelist.removeAllElements();
        }
        en = vec.elements();
        while (en.hasMoreElements()) {
            boolean containsEnd;
            v = (Object[])en.nextElement();
            c = ((Character)v[0]).charValue();
            boolean bk = this.getSuccessor(c, n = ((Integer)v[2]).intValue()) != c;
            boolean atEnd = (c == 's' || c == 'm' || c == 'h' && toTime) && bk;
            boolean finishesAtDate = bk && c == 'd' && !toTime;
            boolean bl = containsEnd = ((StringBuffer)v[1]).toString().indexOf(87) != -1;
            if ((atEnd || finishesAtDate) && !containsEnd) continue;
            vec_removelist.addElement(v);
        }
        Enumeration en2 = vec_removelist.elements();
        while (en2.hasMoreElements()) {
            vec.removeElement(en2.nextElement());
        }
        vec_removelist.removeAllElements();
        v = (Object[])vec.firstElement();
        StringBuffer format = (StringBuffer)v[1];
        format.setLength(format.length() - 1);
        return format.toString();
    }

    static {
        _DoubleFormatter.setGroupingUsed(false);
        _DoubleFormatter.setMaximumFractionDigits(8);
    }
}

