package tzi.UserInput.FileTransponder;

/**
 * Der FileTransponder 
 *
 * @author Zuletzt bearbeitet von $Author: midi $
 * @version $Revision: 1.1 $ $Date: 2004/10/04 09:21:07 $
 */

import java.io.*;
import java.util.ResourceBundle;

public class FileTransponder implements Runnable
{
    /**
     * Der eigene Thread
     */
    private Thread myThread;

    /**
     * Solange true => Thread aktiv
     */
    private boolean isRunning;

    /**
     * Die Datei, in der das Transponderergebnis abgelegt wird
     */
    private String transponderFile;

    /**
     * Der EventListener
     */
    private TransponderListener myListener;

    public FileTransponder()
    {
	myThread = null;
	isRunning = false;
	ResourceBundle mRB = ResourceBundle.getBundle("tzi.UserInput.FileTransponder.fileTransponder");
	transponderFile = mRB.getString("file");	
    }

    /**
     * Bekommt den Thread, in dem er läuft
     *
     * @param thread der Thread
     */
    public void setThread(Thread thread)
    {
	myThread = thread;
	isRunning = true;
    }

    /**
     * Bekommt den Listener
     */
    public void setListener(TransponderListener listener)
    {
	myListener = listener;
    }

    /**
     * Stoppt den Thread
     */
    public void stop()
    {
	isRunning = false;
    }

    /**
     * Die Schleife
     */
    public void run()
    {
	if(myThread != null)
	{
	    while(isRunning)
	    {
		// Wenn Datei existiert, dann auslesen und löschen
		if(exist(transponderFile))
		{
		    myListener.transponderEvent(loadFile(transponderFile));
		    deleteFile(transponderFile);
		}

		// schlafen
		try
		{
		    myThread.sleep(500);
		}
		catch(Exception e)
		{
		    e.printStackTrace();
		}		
	    }
	}
	else
	{
	    System.out.println("[FileTransponder]\t Thread war noch nicht gestartet");
	}
    }

    /**
     * Liest den Inhalt einer Datei aus
     *
     * @param pfad Der Dateipfad
     * @return Den Dateiinhalt
     */
    private String loadFile(String pfad)
    {
	String out = "";

	try
	{
	    FileInputStream datei = new FileInputStream(pfad);

            int a = datei.read();
            
            while (a != -1)
            {
                out += (char)(a);
                a = datei.read();
            }

            datei.close();
 	}
        catch (Exception e)
        {
            e.printStackTrace();
        }
	
	return out;
    }
    
    /**
     * Prüft ob ein Pfad existiert
     *
     * @param pfad Der Datei-/Verzeichnispfad 
     * @return true: existiert
     */
    private boolean exist(String pfad)
    {
        File vz = new File(pfad);
            
        return vz.exists();
    }

    /**
     * Löscht eine Datei
     *
     * @param pfad Der Dateipfad
     */
    private void deleteFile(String pfad)
    {
        File datei = new File(pfad);
        
        datei.delete();
    }

    public static void main(String[] args)
    {
	FileTransponder myFT = new FileTransponder();
    }
}
