package tzi.UserInput;

import java.awt.Point;

public class MultiInputData {
  private byte[] mByteRepresentation;
  private int    mChangeInformation;

  public final static int MOUSE_CHANGED  = 0x01;
  public final static int FINGER_CHANGED = 0x02;
  public final static int THUMB_CHANGED  = 0x04;

  public final static byte THUMB_SHIFT = 2;
  public final static byte THUMB_NUM   = 4;
  public final static byte THUMB_FUNC  = 8;
  public final static byte THUMB_CTRL  = 16;
  public final static byte THUMB_ALT   = 32;
  public final static byte THUMB_MOUSE = 64;

  public MultiInputData(byte[] data) {
    mByteRepresentation = data;
    mChangeInformation  = MOUSE_CHANGED|FINGER_CHANGED|THUMB_CHANGED;
  }

  public boolean equals(byte[] data){

    return mByteRepresentation[0] == data[0]
       &&  mByteRepresentation[1] == data[1]
       &&  mByteRepresentation[2] == data[2]
       &&  mByteRepresentation[3] == data[3]
       &&  mByteRepresentation[4] == data[4];

  }

  public boolean equals(Object data){
    byte[] otherRep = ((MultiInputData)data).mByteRepresentation;
    return equals(otherRep);
  }

  public Point getMouseCoor(){
    int x  = 0;
    int y  = 0;

    y =  (0x7f&mByteRepresentation[2])
       |((0x01&mByteRepresentation[3])<<7);

    if((0x02&mByteRepresentation[3])!=0)
        y= y | 0xffffff00;

    x = ((0x7c&mByteRepresentation[3])>>2)
      | ((0x07&mByteRepresentation[4])<<5);

    if((0x08&mByteRepresentation[4])!=0)
       x= x | 0xffffff00;

       return new Point(x,y);
  }

  public int getChangeInformation(){
    return  mChangeInformation;
  }

  public void calculateChangeInformation(byte[] data){

  }

  public boolean thumbKeyPressed( byte mask )
  {
    return (mByteRepresentation[1] & mask) != 0;
  }

  public static void main(String[] args){
    byte[] data = new byte[5];

    data[0] = 0x00;
    data[1] = 0x00;
    data[2] = 0x00;
    data[3] = -2;
    data[4] = 0x0f;

    MultiInputData i = new MultiInputData(data);

    System.out.println(i.getMouseCoor());


  }



}