package tzi.UserInput;

import tzi.UserInput.Serial.SerialCommunication;
import tzi.UserInput.Serial.SerialPortErrorException;
import javax.comm.SerialPort;

import java.util.Vector;
import java.io.DataInputStream;
import java.io.PipedInputStream;
import java.io.IOException;
import java.awt.Point;


public class MultiInputDevice implements Runnable {

   private final static String COM_PORT         = "COM3";

   private Thread mReaderThread ;
   private MultiInputData mLastUpdate = null;

   private SerialCommunication mSerialPort;
   private DataInputStream mDataInput;

   private boolean mThumbKeyDown[];
   public static final int THUMB_SHIFT = 0;
   public static final int THUMB_CTRL  = 1;
   public static final int THUMB_FUNC  = 2;
   public static final int THUMB_ALT   = 3;
   public static final int THUMB_NUM   = 4;
   public static final int THUMB_MOUSE = 5;

  /**
   *@link aggregation
   *     @associates <{tzi.UserInput.CoordinateListener}>
   * @supplierCardinality *
   */
  private java.util.Vector mCoordinateListeners;
  private java.util.Vector mButtonListeners;

   public MultiInputDevice()
   {
	mCoordinateListeners = new Vector();
    mButtonListeners = new Vector();

    mThumbKeyDown = new boolean[6];
    for( int i=0; i<6; i++ ) mThumbKeyDown[i] = false;

    mSerialPort = new SerialCommunication( COM_PORT, 20000, 2400,
                                           SerialPort.DATABITS_8,
                                           SerialPort.STOPBITS_1,
                                           SerialPort.PARITY_NONE, true, false);
    try{
      mSerialPort.openSerialPort();
    } catch(SerialPortErrorException ex){
        System.err.println("MultiInputDevice: Can not open port "+COM_PORT );
        System.exit(-1);
    }

    try{
      mDataInput = new DataInputStream( new PipedInputStream( mSerialPort.mPOS ));
    } catch(IOException ex) {
      System.err.println("MultiInputDevice: can not open DataInputStream");
      System.exit(-1);
    }

    mReaderThread = new Thread(this);
    mReaderThread.start();
  }

  public void run(){
    byte[] allInput = null;
    int    pointer = 0;
    byte   input = 0;
    while(true){
       try{
         // System.out.println("vor read");
         input = (byte)mDataInput.readChar();
       //  System.out.println("nach read");
       } catch(IOException ex) {
         System.err.println("MultiInputDevice: can not read DataInputStream");
         System.exit(-1);
       }
       if( isSynchronByte(input) ){
          if(allInput!=null){
           testAndUpdate(allInput);
          }
          allInput = new byte[5];
          pointer = 0;
       }

       if(allInput!=null){
         if(pointer<5){
           allInput[pointer] = input;
           pointer++;
         } else {
           // handle sychronization problems
           System.err.println("MultiInputDevice Warning: sync problems");
           allInput = null;
           pointer = 0;
         }
       }
    }
  }


  private void testAndUpdate(byte[] data){
    if(mLastUpdate == null ||  !mLastUpdate.equals(data) ){
        mLastUpdate = new MultiInputData(data);
        dispatch( mLastUpdate );
    }
  }

  private boolean isSynchronByte(byte data){
    return (data&0x80)==0;
  }

  public synchronized void addCoordinateListener(CoordinateListener l) {
     mCoordinateListeners.addElement(l);
  }

  public synchronized void removeCoordinateListener(CoordinateListener l) {
    mCoordinateListeners.removeElement(l);
  }

  public synchronized void addButtonListener(ButtonListener l) {
     mButtonListeners.addElement(l);
  }

  public synchronized void removeButtonListener(CoordinateListener l) {
    mButtonListeners.removeElement(l);
  }

  /**
    Distribute an <code>AcquisitionEvent</code> object to the
    individual event listeners
  */
  private void dispatch(MultiInputData evt)
  {
    int i;
    ButtonEvent be;

    // Mouse Coordinates
	Point p = evt.getMouseCoor();
	CoordinateEvent cox = new CoordinateEvent( this, p.x, 0 );
	CoordinateEvent coy = new CoordinateEvent( this, p.y, 1 );

    for( i=0; i<mCoordinateListeners.size(); i++ ){
       ((CoordinateListener)mCoordinateListeners.elementAt(i)).coordinateChanged( cox );
       ((CoordinateListener)mCoordinateListeners.elementAt(i)).coordinateChanged( coy );
    }

    // Thumb Buttons
    if( evt.thumbKeyPressed( MultiInputData.THUMB_SHIFT ) != mThumbKeyDown[THUMB_SHIFT] ) {
        mThumbKeyDown[THUMB_SHIFT] = evt.thumbKeyPressed( MultiInputData.THUMB_SHIFT );
        be = new ButtonEvent( this, THUMB_SHIFT );
        if( mThumbKeyDown[THUMB_SHIFT] ) {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonPressed( be );
        } else {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonReleased( be );
        }
    }

    if( evt.thumbKeyPressed( MultiInputData.THUMB_CTRL ) != mThumbKeyDown[THUMB_CTRL] ) {
        mThumbKeyDown[THUMB_CTRL] = evt.thumbKeyPressed( MultiInputData.THUMB_CTRL );
        be = new ButtonEvent( this, THUMB_CTRL );
        if( mThumbKeyDown[THUMB_CTRL] ) {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonPressed( be );
        } else {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonReleased( be );
        }
    }

    if( evt.thumbKeyPressed( MultiInputData.THUMB_FUNC ) != mThumbKeyDown[THUMB_FUNC] ) {
        mThumbKeyDown[THUMB_FUNC] = evt.thumbKeyPressed( MultiInputData.THUMB_FUNC );
        be = new ButtonEvent( this, THUMB_FUNC );
        if( mThumbKeyDown[THUMB_FUNC] ) {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonPressed( be );
        } else {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonReleased( be );
        }
    }

    if( evt.thumbKeyPressed( MultiInputData.THUMB_ALT ) != mThumbKeyDown[THUMB_ALT] ) {
        mThumbKeyDown[THUMB_ALT] = evt.thumbKeyPressed( MultiInputData.THUMB_ALT );
        be = new ButtonEvent( this, THUMB_ALT );
        if( mThumbKeyDown[THUMB_ALT] ) {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonPressed( be );
        } else {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonReleased( be );
        }
    }

    if( evt.thumbKeyPressed( MultiInputData.THUMB_NUM ) != mThumbKeyDown[THUMB_NUM] ) {
        mThumbKeyDown[THUMB_NUM] = evt.thumbKeyPressed( MultiInputData.THUMB_NUM );
        be = new ButtonEvent( this, THUMB_NUM );
        if( mThumbKeyDown[THUMB_NUM] ) {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonPressed( be );
        } else {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonReleased( be );
        }
    }

    if( evt.thumbKeyPressed( MultiInputData.THUMB_MOUSE ) != mThumbKeyDown[THUMB_MOUSE] ) {
        mThumbKeyDown[THUMB_MOUSE] = evt.thumbKeyPressed( MultiInputData.THUMB_MOUSE );
        be = new ButtonEvent( this, THUMB_MOUSE );
        if( mThumbKeyDown[THUMB_MOUSE] ) {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonPressed( be );
        } else {
            for( i=0; i<mButtonListeners.size(); i++ )
               ((ButtonListener)mButtonListeners.elementAt(i)).buttonReleased( be );
        }
    }

  }

  public static void main(String[] args){
    new MultiInputDevice();
  }

}
